/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.List;
import java.util.Set;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.IntegPolicy;
import jif.types.label.Label;
import jif.types.label.Policy;
import jif.types.label.Policy_c;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class IntegProjectionPolicy_c
extends Policy_c
implements IntegPolicy {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final Label label;

    public IntegProjectionPolicy_c(Label label, JifTypeSystem ts, Position pos) {
        super(ts, pos);
        this.label = label;
    }

    public Label label() {
        return this.label;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isCanonical() {
        return this.label.isCanonical();
    }

    @Override
    public boolean isRuntimeRepresentable() {
        return this.label.isRuntimeRepresentable();
    }

    @Override
    protected Policy simplifyImpl() {
        return this;
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IntegProjectionPolicy_c) {
            IntegProjectionPolicy_c that = (IntegProjectionPolicy_c)o;
            return this.label == that.label || this.label != null && this.label.equals(that.label);
        }
        return false;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    @Override
    public boolean leq_(IntegPolicy p, LabelEnv env, LabelEnv.SearchState state) {
        if (p instanceof IntegProjectionPolicy_c) {
            return env.leq(this.label(), ((IntegProjectionPolicy_c)p).label(), state);
        }
        if (p.isTopIntegrity()) {
            return true;
        }
        Label ub = env.findUpperBound(this.label);
        return env.leq(ub.integProjection(), p, state);
    }

    @Override
    public String toString(Set<Label> printedLabels) {
        return "I(" + this.label.componentString(printedLabels) + ")";
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        return this.label.throwTypes(ts);
    }

    @Override
    public Policy subst(LabelSubstitution substitution) throws SemanticException {
        Label newLabel = this.label.subst(substitution);
        if (newLabel == this.label) {
            return substitution.substPolicy(this).simplify();
        }
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        IntegPolicy newPolicy = ts.integProjection(newLabel);
        return substitution.substPolicy(newPolicy).simplify();
    }

    @Override
    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        return this.label.labelCheck(A, lc);
    }

    @Override
    public boolean isBottomIntegrity() {
        return this.label.isBottom();
    }

    @Override
    public boolean isTopIntegrity() {
        return this.label.isTop();
    }

    @Override
    public boolean isTop() {
        return this.isTopIntegrity();
    }

    @Override
    public boolean isBottom() {
        return this.isBottomIntegrity();
    }

    @Override
    public boolean hasWritersToReaders() {
        return this.label.hasWritersToReaders();
    }

    @Override
    public boolean hasVariables() {
        return this.label.hasVariables();
    }

    @Override
    public IntegPolicy meet(IntegPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.meet(this, p);
    }

    @Override
    public IntegPolicy join(IntegPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.join(this, p);
    }
}

