/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.List;
import java.util.Set;
import jif.translate.LabelToJavaExpr;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathConstant;
import jif.types.label.DynamicLabel;
import jif.types.label.Label;
import jif.types.label.Label_c;
import jif.visit.LabelChecker;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class DynamicLabel_c
extends Label_c
implements DynamicLabel {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final AccessPath path;

    public DynamicLabel_c(AccessPath path, JifTypeSystem ts, Position pos, LabelToJavaExpr trans) {
        super(ts, pos, trans);
        this.path = path;
        if (path instanceof AccessPathConstant) {
            throw new InternalCompilerError("Don't expect to get AccessPathConstants for dynamic labels");
        }
        this.setDescription(ts.accessPathDescrip(path, "label"));
    }

    @Override
    public AccessPath path() {
        return this.path;
    }

    @Override
    public boolean isRuntimeRepresentable() {
        return true;
    }

    @Override
    public boolean isCovariant() {
        return false;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    protected boolean isDisambiguatedImpl() {
        return this.isCanonical();
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicLabel)) {
            return false;
        }
        DynamicLabel that = (DynamicLabel)o;
        return this.path.equals(that.path());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String componentString(Set<Label> printedLabels) {
        if (Report.should_report((String)"debug", (int)1)) {
            return "<dynamic " + this.path + ">";
        }
        return "*" + this.path();
    }

    @Override
    public boolean leq_(Label L, LabelEnv env, LabelEnv.SearchState state) {
        DynamicLabel that;
        return L instanceof DynamicLabel && env.equivalentAccessPaths(this.path, (that = (DynamicLabel)L).path());
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        return this.path.throwTypes(ts);
    }

    @Override
    public Label subst(LabelSubstitution substitution) throws SemanticException {
        AccessPath newPath = substitution.substAccessPath(this.path);
        if (newPath != this.path) {
            JifTypeSystem ts = this.typeSystem();
            Label newDL = ts.pathToLabel(this.position(), newPath);
            return substitution.substLabel(newDL);
        }
        return substitution.substLabel(this);
    }

    @Override
    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        return this.path.labelcheck(A, lc);
    }
}

