/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathRoot;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.UnknownType;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class AccessPathLocal
extends AccessPathRoot {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected LocalInstance li;
    protected String name;
    private boolean neverNull = false;

    public AccessPathLocal(LocalInstance li, String name, Position pos) {
        super(pos);
        this.li = li;
        this.name = name;
        if (li != null && !name.startsWith(li.name())) {
            throw new InternalCompilerError("Inconsistent local names");
        }
    }

    @Override
    public boolean isCanonical() {
        return !(this.li.type() instanceof UnknownType);
    }

    @Override
    public AccessPath subst(AccessPathRoot r, AccessPath e) {
        if (r instanceof AccessPathLocal && this.li.equals(((AccessPathLocal)r).li)) {
            return e;
        }
        return this;
    }

    public AccessPathLocal name(String name) {
        AccessPathLocal apl = (AccessPathLocal)this.copy();
        apl.name = name;
        if (apl.li != null && !name.startsWith(apl.li.name())) {
            throw new InternalCompilerError("Inconsistent local names");
        }
        return apl;
    }

    @Override
    public boolean isNeverNull() {
        return this.neverNull;
    }

    public void setIsNeverNull() {
        this.neverNull = true;
    }

    public String toString() {
        return this.niceName();
    }

    @Override
    public String exprString() {
        return this.niceName();
    }

    private String niceName() {
        if (this.li != null && this.li.name() != null && this.name.startsWith(this.li.name())) {
            return this.li.name();
        }
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public LocalInstance localInstance() {
        return this.li;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AccessPathLocal) {
            AccessPathLocal that = (AccessPathLocal)o;
            return this.name.equals(that.name) && this.li == that.li;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Type type() {
        if (this.li == null) {
            return null;
        }
        return this.li.type();
    }

    @Override
    public PathMap labelcheck(JifContext A, LabelChecker lc) {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        Label L = ts.labelOfLocal(this.li, A.pc());
        PathMap X = ts.pathMap();
        X = X.N(A.pc());
        X = X.NV(lc.upperBound(L, A.pc()));
        return X;
    }

    @Override
    public void verify(JifContext A) throws SemanticException {
        if (this.li == null) {
            this.li = A.findLocal(this.name);
        } else if (!this.li.equals(A.findLocal(this.name))) {
            throw new InternalCompilerError("Unexpected local instance for name " + this.name);
        }
        if (!this.li.flags().isFinal()) {
            throw new SemanticException("Non-final local variable used in access path", this.position());
        }
    }
}

