/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import jif.types.JifTypeSystem;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathRoot;
import jif.types.label.Label;
import jif.types.principal.Principal;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class AccessPathConstant
extends AccessPathRoot {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private Object constantValue;
    private Type type;

    public AccessPathConstant(Label label, Type type, Position pos) {
        super(pos);
        this.constantValue = label;
        this.type = type;
    }

    public AccessPathConstant(Principal principal, Type type, Position pos) {
        super(pos);
        this.constantValue = principal;
        this.type = type;
    }

    public Object constantValue() {
        return this.constantValue;
    }

    public boolean isLabelConstant() {
        return ((JifTypeSystem)this.type.typeSystem()).isLabel(this.type);
    }

    @Override
    public boolean isNeverNull() {
        return false;
    }

    public boolean isPrincipalConstant() {
        return ((JifTypeSystem)this.type.typeSystem()).isPrincipal(this.type);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public AccessPath subst(AccessPathRoot r, AccessPath e) {
        throw new InternalCompilerError("Shouldn't be calling subst on an AccessPathConstant! \"" + this + "\"");
    }

    public String toString() {
        return this.constantValue.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AccessPathConstant) {
            AccessPathConstant that = (AccessPathConstant)o;
            return this.constantValue.equals(that.constantValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.constantValue.hashCode();
    }

    @Override
    public Type type() {
        return this.type;
    }
}

