/*
 * Decompiled with CFR 0.152.
 */
package jif.types.hierarchy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import jif.types.principal.ConjunctivePrincipal;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.Principal;

public class PrincipalHierarchy {
    private final Map<Principal, Set<Principal>> actsfor = new HashMap<Principal, Set<Principal>>();
    private final Map<Principal, Set<Principal>> grants = new HashMap<Principal, Set<Principal>>();
    private final Map<Principal, Set<Principal>> actorCache = new HashMap<Principal, Set<Principal>>();

    public String toString() {
        return "[" + this.actsForString() + "]";
    }

    private static void addAlreadyReported(Map<Principal, Set<Principal>> alreadyReported, Principal p, Principal q) {
        Set<Principal> s = alreadyReported.get(q);
        if (s == null) {
            s = new HashSet<Principal>();
            alreadyReported.put(q, s);
        }
        s.add(p);
    }

    private static boolean isAlreadyReported(Map<Principal, Set<Principal>> alreadyReported, Principal p, Principal q) {
        Set<Principal> s = alreadyReported.get(p);
        if (s != null) {
            return s.contains(q);
        }
        return false;
    }

    public String actsForString() {
        StringBuffer sb = new StringBuffer();
        HashMap<Principal, Set<Principal>> alreadyReported = new HashMap<Principal, Set<Principal>>();
        boolean needsComma = false;
        for (Map.Entry<Principal, Set<Principal>> e : this.actsfor.entrySet()) {
            Principal p = e.getKey();
            Set<Principal> a = e.getValue();
            for (Principal q : a) {
                if (PrincipalHierarchy.isAlreadyReported(alreadyReported, p, q)) continue;
                if (needsComma) {
                    sb.append(", ");
                }
                sb.append("(");
                sb.append(p.toString());
                Set<Principal> b = this.actsfor.get(q);
                if (b != null && b.contains(p)) {
                    sb.append(" equiv ");
                    PrincipalHierarchy.addAlreadyReported(alreadyReported, p, q);
                } else {
                    sb.append(" actsFor ");
                }
                sb.append(q.toString());
                sb.append(")");
                needsComma = true;
            }
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.actsfor.isEmpty();
    }

    public void add(Principal actor, Principal granter) {
        Set<Principal> s = this.actsfor.get(actor);
        if (s == null) {
            s = new LinkedHashSet<Principal>();
            this.actsfor.put(actor, s);
        }
        s.add(granter);
        Set<Principal> t = this.grants.get(granter);
        if (t == null) {
            t = new LinkedHashSet<Principal>();
            this.grants.put(granter, t);
        }
        t.add(actor);
    }

    public boolean actsFor(Principal actor, Principal granter) {
        return this.actsFor(actor, granter, new LinkedList<PrincipalPair>());
    }

    protected boolean actsFor(Principal actor, Principal granter, LinkedList<PrincipalPair> goalStack) {
        Set<Principal> t;
        DisjunctivePrincipal dp;
        Object cp;
        if (actor.isTopPrincipal()) {
            return true;
        }
        if (granter.isBottomPrincipal()) {
            return true;
        }
        Set<Principal> actorCached = this.actorCache.get(actor);
        if (actorCached != null && actorCached.contains(granter)) {
            return true;
        }
        PrincipalPair currentGoal = new PrincipalPair(actor, granter);
        if (goalStack.contains(currentGoal)) {
            return false;
        }
        if (actor.equals(granter)) {
            return true;
        }
        Set<Principal> s = this.actsfor.get(actor);
        if (s != null && s.contains(granter)) {
            this.cacheResult(actor, granter);
            return true;
        }
        goalStack.addLast(currentGoal);
        if (actor instanceof ConjunctivePrincipal) {
            cp = (ConjunctivePrincipal)actor;
            for (Principal principal : cp.conjuncts()) {
                if (!this.actsFor(principal, granter, goalStack)) continue;
                this.cacheResult(actor, granter);
                return true;
            }
        }
        if (actor instanceof DisjunctivePrincipal) {
            dp = (DisjunctivePrincipal)actor;
            boolean all = true;
            for (Principal p : dp.disjuncts()) {
                if (this.actsFor(p, granter, goalStack)) continue;
                all = false;
                break;
            }
            if (all) {
                this.cacheResult(actor, granter);
                return true;
            }
        }
        if (granter instanceof DisjunctivePrincipal) {
            dp = (DisjunctivePrincipal)granter;
            for (Principal principal : dp.disjuncts()) {
                if (!this.actsFor(actor, principal, goalStack)) continue;
                this.cacheResult(actor, granter);
                return true;
            }
        }
        if (granter instanceof ConjunctivePrincipal) {
            cp = (ConjunctivePrincipal)granter;
            boolean all = true;
            for (Principal p : cp.conjuncts()) {
                if (this.actsFor(actor, p, goalStack)) continue;
                all = false;
                break;
            }
            if (all) {
                this.cacheResult(actor, granter);
                return true;
            }
        }
        if (s != null) {
            for (Principal p : s) {
                if (!this.actsFor(p, granter, goalStack)) continue;
                this.cacheResult(actor, granter);
                return true;
            }
        }
        if ((t = this.grants.get(granter)) != null) {
            for (Principal principal : t) {
                if (!this.actsFor(actor, principal, goalStack)) continue;
                this.cacheResult(actor, granter);
                return true;
            }
        }
        goalStack.removeLast();
        return false;
    }

    private void cacheResult(Principal actor, Principal granter) {
        Set<Principal> s = this.actorCache.get(actor);
        if (s == null) {
            s = new HashSet<Principal>();
            this.actorCache.put(actor, s);
        }
        s.add(granter);
    }

    public PrincipalHierarchy copy() {
        Set<Principal> s;
        Principal p;
        PrincipalHierarchy dup = new PrincipalHierarchy();
        for (Map.Entry<Principal, Set<Principal>> e : this.actsfor.entrySet()) {
            p = e.getKey();
            s = e.getValue();
            dup.actsfor.put(p, new LinkedHashSet<Principal>(s));
        }
        for (Map.Entry<Principal, Set<Principal>> e : this.grants.entrySet()) {
            p = e.getKey();
            s = e.getValue();
            dup.grants.put(p, new LinkedHashSet<Principal>(s));
        }
        return dup;
    }

    public void clear() {
        this.actsfor.clear();
    }

    private static class PrincipalPair {
        final Principal actor;
        final Principal granter;

        PrincipalPair(Principal actor, Principal granter) {
            this.actor = actor;
            this.granter = granter;
        }

        public int hashCode() {
            return this.actor.hashCode() ^ this.granter.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof PrincipalPair) {
                PrincipalPair that = (PrincipalPair)o;
                return this.actor.equals(that.actor) && this.granter.equals(that.granter);
            }
            return false;
        }
    }
}

