/*
 * Decompiled with CFR 0.152.
 */
package jif.types.hierarchy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.Topics;
import jif.types.Assertion;
import jif.types.JifTypeSystem;
import jif.types.LabelLeAssertion;
import jif.types.LabelSubstitution;
import jif.types.Solver;
import jif.types.VarMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.hierarchy.PrincipalHierarchy;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathConstant;
import jif.types.label.AccessPathRoot;
import jif.types.label.ArgLabel;
import jif.types.label.ConfPolicy;
import jif.types.label.CovariantParamLabel;
import jif.types.label.DynamicLabel;
import jif.types.label.IntegPolicy;
import jif.types.label.JoinConfPolicy_c;
import jif.types.label.JoinIntegPolicy_c;
import jif.types.label.JoinLabel;
import jif.types.label.JoinPolicy_c;
import jif.types.label.Label;
import jif.types.label.MeetLabel;
import jif.types.label.MeetPolicy_c;
import jif.types.label.PairLabel;
import jif.types.label.ParamLabel;
import jif.types.label.Policy;
import jif.types.label.VarLabel_c;
import jif.types.label.WriterPolicy;
import jif.types.label.WritersToReadersLabel;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class LabelEnv_c
implements LabelEnv {
    protected final PrincipalHierarchy ph;
    protected final List<LabelLeAssertion> labelAssertions;
    protected final StringBuffer displayLabelAssertions;
    protected final JifTypeSystem ts;
    protected final Map<AccessPath, AccessPath> accessPathEquivReps;
    protected final LabelEnv_c parent;
    protected Solver solver;
    protected boolean hasVariables;
    protected static Collection<String> topics = CollectionUtil.list((Object)Topics.jif, (Object)Topics.labelEnv);
    private final Set<LeqGoal> cacheTrue;
    private final Set<LeqGoal> cacheFalse;
    protected final boolean useCache;
    private static final int ASSERTION_USE_BOUND = 1;
    private static final int EQUIV_PATH_USE_BOUND = 1;
    private static final int ASSERTION_TOTAL_BOUND = 6;
    private static final int EQUIV_PATH_TOTAL_BOUND = 8;

    public LabelEnv_c(JifTypeSystem ts, boolean useCache) {
        this(ts, new PrincipalHierarchy(), new LinkedList<LabelLeAssertion>(), "", false, useCache, new LinkedHashMap<AccessPath, AccessPath>(), null);
    }

    protected LabelEnv_c(JifTypeSystem ts, PrincipalHierarchy ph, List<LabelLeAssertion> assertions, String displayLabelAssertions, boolean hasVariables, boolean useCache, Map<AccessPath, AccessPath> accessPathEquivReps, LabelEnv_c parent) {
        this.ph = ph;
        this.labelAssertions = assertions;
        this.accessPathEquivReps = accessPathEquivReps;
        this.displayLabelAssertions = new StringBuffer(displayLabelAssertions);
        this.hasVariables = false;
        this.solver = null;
        this.hasVariables = hasVariables;
        this.ts = ts;
        this.useCache = useCache;
        this.parent = parent;
        this.cacheTrue = new HashSet<LeqGoal>();
        this.cacheFalse = new HashSet<LeqGoal>();
    }

    @Override
    public void setSolver(Solver s) {
        if (this.solver == null) {
            this.solver = s;
        } else if (this.solver != s) {
            throw new InternalCompilerError("LabelEnv given two different solvers");
        }
    }

    @Override
    public PrincipalHierarchy principalHierarchy() {
        return this.ph;
    }

    @Override
    public Collection<LabelLeAssertion> labelAssertions() {
        return Collections.unmodifiableCollection(this.labelAssertions);
    }

    public PrincipalHierarchy ph() {
        return this.ph;
    }

    @Override
    public boolean hasVariables() {
        return this.hasVariables;
    }

    public void addActsFor(Principal p1, Principal p2) {
        this.cacheFalse.clear();
        this.ph.add(p1, p2);
    }

    public void addEquiv(Principal p1, Principal p2) {
        this.cacheFalse.clear();
        AccessPath pathp = null;
        AccessPath pathq = null;
        if (p1 instanceof DynamicPrincipal) {
            pathp = ((DynamicPrincipal)p1).path();
        } else if (p1.isRuntimeRepresentable()) {
            pathp = new AccessPathConstant(p1, (Type)this.ts.Principal(), p1.position());
        }
        if (p2 instanceof DynamicPrincipal) {
            pathq = ((DynamicPrincipal)p2).path();
        } else if (p2.isRuntimeRepresentable()) {
            pathq = new AccessPathConstant(p2, (Type)this.ts.Principal(), p2.position());
        }
        if (pathp != null && pathq != null) {
            this.addEquiv(pathp, pathq);
        }
        this.ph.add(p1, p2);
        this.ph.add(p2, p1);
    }

    public void addAssertionLE(Label L1, Label L2) {
        this.addAssertionLE(L1, L2, true);
    }

    private boolean addAssertionLE(Label L1, Label L2, boolean updateDisplayString) {
        this.cacheFalse.clear();
        boolean added = false;
        if (L1 instanceof JoinLabel) {
            for (Label cmp : ((JoinLabel)L1).joinComponents()) {
                added = this.addAssertionLE(cmp, L2, false) || added;
            }
        } else if (L2 instanceof MeetLabel) {
            for (Label cmp : ((MeetLabel)L2).meetComponents()) {
                added = this.addAssertionLE(L1, cmp, false) || added;
            }
        } else if (L1.hasVariables() || L2.hasVariables() || !this.leq(L1, L2, this.freshSearchState())) {
            this.labelAssertions.add(this.ts.labelLeAssertion(Position.compilerGenerated(), L1, L2));
            added = true;
            if (!this.hasVariables && (L1.hasVariables() || L2.hasVariables())) {
                this.hasVariables = true;
            }
        }
        if (updateDisplayString && added) {
            if (this.displayLabelAssertions.length() > 0) {
                this.displayLabelAssertions.append("\n");
            }
            this.displayLabelAssertions.append("   " + L1 + " <= " + L2);
        }
        return added;
    }

    public void addEquiv(Label L1, Label L2) {
        this.addAssertionLE(L1, L2, false);
        this.addAssertionLE(L2, L1, false);
        if (this.displayLabelAssertions.length() > 0) {
            this.displayLabelAssertions.append("\n");
        }
        this.displayLabelAssertions.append("   " + L1 + " equiv " + L2);
    }

    public LabelEnv_c copy() {
        return new LabelEnv_c(this.ts, this.ph.copy(), new LinkedList<LabelLeAssertion>(this.labelAssertions), this.displayLabelAssertions.toString(), this.hasVariables, this.useCache, new LinkedHashMap<AccessPath, AccessPath>(this.accessPathEquivReps), this);
    }

    @Override
    public boolean actsFor(Principal p, Principal q) {
        AccessPath pathp = null;
        AccessPath pathq = null;
        if (p instanceof DynamicPrincipal) {
            pathp = ((DynamicPrincipal)p).path();
        } else if (p.isRuntimeRepresentable()) {
            pathp = new AccessPathConstant(p, (Type)this.ts.Principal(), p.position());
        }
        if (q instanceof DynamicPrincipal) {
            pathq = ((DynamicPrincipal)q).path();
        } else if (q.isRuntimeRepresentable()) {
            pathq = new AccessPathConstant(q, (Type)this.ts.Principal(), q.position());
        }
        if (pathp != null && pathq != null && this.equivalentAccessPaths(pathp, pathq)) {
            return true;
        }
        return this.ph.actsFor(p, q);
    }

    @Override
    public boolean leq(Label L1, Label L2) {
        if (Report.should_report(topics, (int)1)) {
            Report.report((int)1, (String)("Testing " + L1 + " <= " + L2));
        }
        return this.leq(L1, L2, (LabelEnv.SearchState)new SearchState_c(new AssertionUseCount()));
    }

    @Override
    public boolean equivalentAccessPaths(AccessPath p, AccessPath q) {
        if (p == q) {
            return true;
        }
        if (this.findAccessPathRepr(p).equals(this.findAccessPathRepr(q))) {
            return true;
        }
        return p.equivalentTo(q, this);
    }

    private AccessPath findAccessPathRepr(AccessPath p) {
        AccessPath last = p;
        AccessPath next = this.accessPathEquivReps.get(last);
        while (next != null && next != last) {
            last = next;
            next = this.accessPathEquivReps.get(last);
        }
        return last;
    }

    public void addEquiv(AccessPath p, AccessPath q) {
        this.cacheFalse.clear();
        AccessPath repr1 = this.findAccessPathRepr(p);
        AccessPath repr2 = this.findAccessPathRepr(q);
        this.accessPathEquivReps.put(p, repr2);
        if (repr1 != p) {
            this.accessPathEquivReps.put(repr1, repr2);
        }
        if (!this.accessPathEquivReps.containsKey(q)) {
            this.accessPathEquivReps.put(q, repr2);
        }
    }

    protected Set<Serializable> equivAccessPaths(AccessPathRoot p) {
        if (!this.accessPathEquivReps.containsKey(p)) {
            return Collections.emptySet();
        }
        LinkedHashSet<Serializable> s = new LinkedHashSet<Serializable>();
        AccessPath repr = this.findAccessPathRepr(p);
        for (AccessPath q : this.accessPathEquivReps.keySet()) {
            if (repr != this.findAccessPathRepr(q)) continue;
            s.add(q);
        }
        return s;
    }

    @Override
    public boolean leq(Label L1, Label L2, LabelEnv.SearchState state) {
        if (!this.useCache || !((SearchState_c)state).useAssertions || this.hasVariables()) {
            if (Report.should_report(topics, (int)3)) {
                Report.report((int)3, (String)("Not using cache for " + L1 + " <= " + L2 + " : useCache = " + this.useCache + "; state.useAssertions = " + ((SearchState_c)state).useAssertions + "; this.hasVariables() = " + this.hasVariables()));
            }
            return this.leqImpl(L1, L2, (SearchState_c)state);
        }
        LeqGoal g = new LeqGoal(L1, L2);
        Boolean b = this.checkCache(g);
        if (b != null) {
            if (Report.should_report(topics, (int)3)) {
                Report.report((int)3, (String)("Found cache value for " + L1 + " <= " + L2 + " : " + b));
            }
            return b;
        }
        boolean result = this.leqImpl(L1, L2, (SearchState_c)state);
        this.cacheResult(g, state, result);
        return result;
    }

    protected Boolean checkCache(LeqGoal g) {
        if (!this.useCache || this.hasVariables()) {
            return null;
        }
        if (this.cacheTrue.contains(g)) {
            return Boolean.TRUE;
        }
        if (this.cacheFalse.contains(g)) {
            return Boolean.FALSE;
        }
        LabelEnv_c ancestor = this.parent;
        while (ancestor != null && ancestor.useCache && !ancestor.hasVariables()) {
            if (ancestor.cacheTrue.contains(g)) {
                this.cacheTrue.add(g);
                return Boolean.TRUE;
            }
            ancestor = ancestor.parent;
        }
        return null;
    }

    protected void cacheResult(LeqGoal g, LabelEnv.SearchState s, boolean result) {
        if (!this.useCache || this.hasVariables() || !((SearchState_c)s).auc.allZero()) {
            return;
        }
        (result ? this.cacheTrue : this.cacheFalse).add(g);
    }

    private boolean leqImpl(Label L1, Label L2, SearchState_c state) {
        ArgLabel al;
        AssertionUseCount auc = state.auc;
        L1 = L1.normalize();
        L2 = L2.normalize();
        if (L1 instanceof WritersToReadersLabel) {
            Label tL1 = this.triggerTransforms(L1).normalize();
            if (Report.should_report(topics, (int)3)) {
                Report.report((int)3, (String)("Transforming " + L1 + " to " + tL1));
            }
            if (!L1.equals(tL1)) {
                return this.leq(tL1, L2, (LabelEnv.SearchState)state);
            }
        }
        if (L2 instanceof WritersToReadersLabel) {
            Label tL2 = this.triggerTransforms(L2).normalize();
            if (Report.should_report(topics, (int)3)) {
                Report.report((int)3, (String)("Transforming " + L2 + " to " + tL2));
            }
            if (!L2.equals(tL2)) {
                return this.leq(L1, tL2, (LabelEnv.SearchState)state);
            }
        }
        if (!L1.isComparable() || !L2.isComparable()) {
            if (Report.should_report(topics, (int)3)) {
                Report.report((int)3, (String)("Goal " + L1 + " <= " + L2 + " already on goal stack"));
            }
            throw new InternalCompilerError("Cannot compare " + L1 + " with " + L2 + ".");
        }
        if (L1.isBottom()) {
            return true;
        }
        if (L2.isTop()) {
            return true;
        }
        LeqGoal newGoal = new LeqGoal(L1, L2);
        if (state.containsGoal(newGoal)) {
            if (Report.should_report(topics, (int)3)) {
                Report.report((int)3, (String)("Goal " + L1 + " <= " + L2 + " already on goal stack"));
            }
            return false;
        }
        state = new SearchState_c(auc, state, newGoal);
        if (L1.equals(L2)) {
            return true;
        }
        if (!L1.isEnumerable()) {
            return L1.leq_(L2, this, state);
        }
        if (!L1.isEnumerable() || !L2.isEnumerable()) {
            throw new InternalCompilerError("Cannot compare " + L1 + " <= " + L2);
        }
        if (L2 instanceof MeetLabel) {
            MeetLabel ml = (MeetLabel)L2;
            boolean allSat = true;
            for (Label cj : ml.meetComponents()) {
                if (this.leq(L1, cj, (LabelEnv.SearchState)state)) continue;
                allSat = false;
                break;
            }
            if (allSat) {
                return true;
            }
        }
        if (L2 instanceof JoinLabel) {
            JoinLabel jl = (JoinLabel)L2;
            for (Label cj : jl.joinComponents()) {
                if (!this.leq(L1, cj, (LabelEnv.SearchState)state)) continue;
                return true;
            }
        }
        if (L1.leq_(L2, this, state)) {
            return true;
        }
        if (L1 instanceof ArgLabel && this.leq((al = (ArgLabel)L1).upperBound(), L2, (LabelEnv.SearchState)state)) {
            return true;
        }
        if (L1 instanceof MeetLabel || L1 instanceof JoinLabel || L2 instanceof MeetLabel || L2 instanceof JoinLabel) {
            ConfPolicy conf1 = this.ts.confProjection(L1);
            ConfPolicy conf2 = this.ts.confProjection(L2);
            IntegPolicy integ1 = this.ts.integProjection(L1);
            IntegPolicy integ2 = this.ts.integProjection(L2);
            if (this.leq(conf1, conf2, (LabelEnv.SearchState)state) && this.leq(integ1, integ2, (LabelEnv.SearchState)state)) {
                return true;
            }
        }
        if (L1 instanceof PairLabel && !(L2 instanceof PairLabel) && this.fineGrainPairLabelSearch((PairLabel)L1, L2)) {
            return true;
        }
        return this.leqApplyAssertions(L1, L2, state, true);
    }

    private boolean fineGrainPairLabelSearch(PairLabel L1, Label L2) {
        Collection joinComponents;
        ConfPolicy cp = L1.confPolicy();
        IntegPolicy ip = L1.integPolicy();
        if (!(cp instanceof JoinConfPolicy_c) && !(ip instanceof JoinIntegPolicy_c) || cp.isSingleton() && ip.isSingleton()) {
            return false;
        }
        Position pos = L1.position();
        if (cp instanceof JoinConfPolicy_c) {
            JoinConfPolicy_c jcp = (JoinConfPolicy_c)cp;
            IntegPolicy bottomInteg = this.ts.bottomIntegPolicy(pos);
            joinComponents = jcp.joinComponents();
            for (Policy joinComponent : joinComponents) {
                if (this.leq(this.ts.pairLabel(pos, (ConfPolicy)joinComponent, bottomInteg), L2)) continue;
                return false;
            }
        } else if (!this.leq(this.ts.pairLabel(pos, cp, this.ts.bottomIntegPolicy(pos)), L2)) {
            return false;
        }
        if (ip instanceof JoinIntegPolicy_c) {
            JoinIntegPolicy_c jip = (JoinIntegPolicy_c)ip;
            ConfPolicy bottomConf = this.ts.bottomConfPolicy(pos);
            joinComponents = jip.joinComponents();
            for (Policy joinComponent : joinComponents) {
                if (this.leq(this.ts.pairLabel(pos, bottomConf, (IntegPolicy)joinComponent), L2)) continue;
                return false;
            }
        } else if (!this.leq(this.ts.pairLabel(pos, this.ts.bottomConfPolicy(pos), ip), L2)) {
            return false;
        }
        return true;
    }

    private boolean leqApplyAssertions(Label L1, Label L2, SearchState_c state, boolean beSmart) {
        DynamicLabel equiv;
        SearchState_c newState;
        AssertionUseCount newAUC;
        AccessPathEquivalence ea;
        AccessPath p;
        Set<Serializable> equivAccessPaths;
        AssertionUseCount auc = state.auc;
        if (!state.useAssertions || auc.size() >= 6 || auc.accessPathSize() > 8) {
            return false;
        }
        if (Report.should_report(topics, (int)2)) {
            Report.report((int)2, (String)("Applying assertions for " + L1 + " <= " + L2));
        }
        for (LabelLeAssertion c : this.labelAssertions) {
            Label cRHS;
            if (auc.get(c) >= 1) continue;
            AssertionUseCount newAUC2 = new AssertionUseCount(auc, c);
            SearchState_c newState2 = new SearchState_c(newAUC2, state, null);
            Label cLHS = c.lhs();
            if (cLHS.hasVariables()) {
                cLHS = this.solver.applyBoundsTo(c.lhs());
            }
            if ((cRHS = c.rhs()).hasVariables()) {
                cRHS = this.solver.applyBoundsTo(c.rhs());
            }
            if (Report.should_report(topics, (int)4)) {
                Report.report((int)4, (String)("Considering assertion " + c + " for " + L1 + " <= " + L2));
            }
            if (beSmart && !L1.equals(cLHS) && !L2.equals(cRHS)) continue;
            if (Report.should_report(topics, (int)3)) {
                Report.report((int)3, (String)("Trying assertion " + c + " for " + L1 + " <= " + L2));
            }
            if (!this.leq(L1, cLHS, (LabelEnv.SearchState)newState2) || !this.leq(cRHS, L2, (LabelEnv.SearchState)newState2)) continue;
            return true;
        }
        if (L2 instanceof DynamicLabel) {
            AccessPath p2 = ((DynamicLabel)L2).path();
            AccessPathRoot p2root = p2.root();
            equivAccessPaths = this.equivAccessPaths(p2root);
            for (Serializable serializable : equivAccessPaths) {
                p = (AccessPath)serializable;
                if (p.equals(p2root) || auc.get(ea = new AccessPathEquivalence(p, p2root)) >= 1) continue;
                newAUC = new AssertionUseCount(auc, ea);
                newState = new SearchState_c(newAUC, state, null);
                equiv = this.ts.dynamicLabel(Position.compilerGenerated(), p2.subst(p2root, p));
                if (!this.leq(L1, equiv, (LabelEnv.SearchState)newState)) continue;
                return true;
            }
        }
        if (L1 instanceof DynamicLabel) {
            AccessPath p1 = ((DynamicLabel)L1).path();
            AccessPathRoot p1root = p1.root();
            equivAccessPaths = this.equivAccessPaths(p1root);
            for (Serializable serializable : equivAccessPaths) {
                p = (AccessPath)serializable;
                if (p.equals(p1root) || auc.get(ea = new AccessPathEquivalence(p, p1root)) >= 1) continue;
                newAUC = new AssertionUseCount(auc, ea);
                newState = new SearchState_c(newAUC, state, null);
                equiv = this.ts.dynamicLabel(Position.compilerGenerated(), p1.subst(p1root, p));
                if (!this.leq(equiv, L2, (LabelEnv.SearchState)newState)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean leq(Policy p1, Policy p2) {
        return this.leq(p1.simplify(), p2.simplify(), (LabelEnv.SearchState)new SearchState_c(new AssertionUseCount()));
    }

    @Override
    public boolean leq(Policy p1, Policy p2, LabelEnv.SearchState state_) {
        SearchState_c state = (SearchState_c)state_;
        AssertionUseCount auc = state.auc;
        LeqGoal newGoal = new LeqGoal(p1, p2);
        if (state.containsGoal(newGoal)) {
            return false;
        }
        state = new SearchState_c(auc, state, newGoal);
        if (p1 instanceof ConfPolicy && p2 instanceof ConfPolicy) {
            return this.leq((ConfPolicy)p1, (ConfPolicy)p2, (LabelEnv.SearchState)state);
        }
        if (p1 instanceof IntegPolicy && p2 instanceof IntegPolicy) {
            return this.leq((IntegPolicy)p1, (IntegPolicy)p2, (LabelEnv.SearchState)state);
        }
        return false;
    }

    public boolean leq(ConfPolicy p1, ConfPolicy p2, LabelEnv.SearchState state) {
        if ((p2.isSingleton() || !p1.isSingleton()) && p1.leq_(p2, this, state)) {
            return true;
        }
        if (p2 instanceof JoinPolicy_c) {
            JoinPolicy_c jp = (JoinPolicy_c)((Object)p2);
            Collection joinComponents = jp.joinComponents();
            for (ConfPolicy ci : joinComponents) {
                if (!this.leq(p1, ci, state)) continue;
                return true;
            }
        } else if (p2 instanceof MeetPolicy_c) {
            MeetPolicy_c mp = (MeetPolicy_c)((Object)p2);
            boolean allSat = true;
            Collection meetComponents = mp.meetComponents();
            for (ConfPolicy ci : meetComponents) {
                if (this.leq(p1, ci, state)) continue;
                allSat = false;
                break;
            }
            if (allSat) {
                return true;
            }
        }
        if (p2.isSingleton() || !p1.isSingleton()) {
            return false;
        }
        return p1.leq_(p2, this, state);
    }

    public boolean leq(IntegPolicy p1, IntegPolicy p2, LabelEnv.SearchState state) {
        WriterPolicy wp2;
        if (p2 instanceof WriterPolicy && (wp2 = (WriterPolicy)p2).writer().isBottomPrincipal()) {
            return true;
        }
        if ((p2.isSingleton() || !p1.isSingleton()) && p1.leq_(p2, this, state)) {
            return true;
        }
        if (p2 instanceof JoinPolicy_c) {
            JoinPolicy_c jp = (JoinPolicy_c)((Object)p2);
            Collection joinComponents = jp.joinComponents();
            for (IntegPolicy ci : joinComponents) {
                if (!this.leq(p1, ci, state)) continue;
                return true;
            }
        } else if (p2 instanceof MeetPolicy_c) {
            MeetPolicy_c mp = (MeetPolicy_c)((Object)p2);
            boolean allSat = true;
            Collection meetComponents = mp.meetComponents();
            for (IntegPolicy ci : meetComponents) {
                if (this.leq(p1, ci, state)) continue;
                allSat = false;
                break;
            }
            if (allSat) {
                return true;
            }
        }
        if (p2.isSingleton() || !p1.isSingleton()) {
            return false;
        }
        return p1.leq_(p2, this, state);
    }

    @Override
    public boolean isEmpty() {
        return this.labelAssertions.isEmpty() && this.ph.isEmpty();
    }

    @Override
    public Label findLowerBound(Label L) {
        return this.findLowerBound(L, Collections.emptySet(), false);
    }

    protected Label findLowerBound(Label L, Collection<Serializable> seen, boolean noArgLabels) {
        Label ret;
        if (L instanceof PairLabel) {
            return L;
        }
        if (L instanceof VarLabel_c) {
            return L;
        }
        if (noArgLabels && (L instanceof DynamicLabel || L instanceof ParamLabel || L instanceof CovariantParamLabel)) {
            return L;
        }
        if (seen.contains(L)) {
            return this.ts.bottomLabel();
        }
        ArrayList<Serializable> newSeen = new ArrayList<Serializable>(seen.size() + 1);
        newSeen.addAll(seen);
        newSeen.add((Serializable)((Object)L));
        LinkedHashSet<Label> allBounds = new LinkedHashSet<Label>();
        if (L instanceof JoinLabel) {
            JoinLabel jl = (JoinLabel)L;
            ret = this.ts.bottomLabel();
            for (Label comp : jl.joinComponents()) {
                ret = this.ts.join(ret, this.findLowerBound(comp, newSeen, noArgLabels));
            }
            allBounds.add(ret);
        }
        if (L instanceof MeetLabel) {
            MeetLabel ml = (MeetLabel)L;
            ret = this.ts.topLabel();
            for (Label comp : ml.meetComponents()) {
                ret = this.ts.meet(ret, this.findLowerBound(comp, newSeen, noArgLabels));
            }
            allBounds.add(ret);
        }
        for (LabelLeAssertion c : this.labelAssertions) {
            Label cRHS;
            Label cLHS = c.lhs();
            if (cLHS.hasVariables()) {
                cLHS = this.solver.applyBoundsTo(c.lhs());
            }
            if ((cRHS = c.rhs()).hasVariables()) {
                cRHS = this.solver.applyBoundsTo(c.rhs());
            }
            if (!L.equals(cRHS)) continue;
            allBounds.add(this.findLowerBound(cLHS, newSeen, noArgLabels));
        }
        if (L instanceof ArgLabel) {
            if (Report.should_report(topics, (int)4)) {
                Report.report((int)4, (String)("ArgLabel " + L + " does not have a non-trivial lower bound"));
            }
            return this.ts.bottomLabel();
        }
        if (!allBounds.isEmpty()) {
            Label lowerBound = allBounds.size() == 1 ? (Label)allBounds.iterator().next() : this.ts.joinLabel(L.position(), allBounds);
            if (Report.should_report(topics, (int)4)) {
                Report.report((int)4, (String)("Using " + lowerBound + " as lower bound for " + L));
            }
            return lowerBound;
        }
        if (Report.should_report(topics, (int)4)) {
            Report.report((int)4, (String)("Using bottom as lower bound for " + L));
        }
        return this.ts.bottomLabel();
    }

    @Override
    public Label findUpperBound(Label L) {
        return this.findUpperBound(L, Collections.emptySet(), false);
    }

    @Override
    public Label findNonArgLabelUpperBound(Label L) {
        return this.findUpperBound(L, Collections.emptySet(), true);
    }

    protected Label findUpperBound(Label L, Collection<Label> seen, boolean noArgLabels) {
        ArgLabel al;
        Label ret;
        if (L instanceof PairLabel) {
            return L;
        }
        if (L instanceof VarLabel_c) {
            return L;
        }
        if (noArgLabels && (L instanceof DynamicLabel || L instanceof ParamLabel || L instanceof CovariantParamLabel)) {
            return L;
        }
        if (seen.contains(L)) {
            return this.ts.topLabel();
        }
        ArrayList<Label> newSeen = new ArrayList<Label>(seen.size() + 1);
        newSeen.addAll(seen);
        newSeen.add(L);
        LinkedHashSet<Label> allBounds = new LinkedHashSet<Label>();
        if (L instanceof JoinLabel) {
            JoinLabel jl = (JoinLabel)L;
            ret = this.ts.bottomLabel();
            for (Label comp : jl.joinComponents()) {
                ret = this.ts.join(ret, this.findUpperBound(comp, newSeen, noArgLabels));
            }
            allBounds.add(ret);
        }
        if (L instanceof MeetLabel) {
            MeetLabel ml = (MeetLabel)L;
            ret = this.ts.topLabel();
            for (Label comp : ml.meetComponents()) {
                ret = this.ts.meet(ret, this.findUpperBound(comp, newSeen, noArgLabels));
            }
            allBounds.add(ret);
        }
        for (LabelLeAssertion c : this.labelAssertions) {
            Label cRHS;
            Label cLHS = c.lhs();
            if (cLHS.hasVariables()) {
                cLHS = this.solver.applyBoundsTo(c.lhs());
            }
            if ((cRHS = c.rhs()).hasVariables()) {
                cRHS = this.solver.applyBoundsTo(c.rhs());
            }
            if (!L.equals(cLHS)) continue;
            allBounds.add(this.findUpperBound(cRHS, newSeen, noArgLabels));
        }
        if (L instanceof ArgLabel && !this.argLabelBoundRecursive(al = (ArgLabel)L)) {
            allBounds.add(this.findUpperBound(al.upperBound(), newSeen, noArgLabels));
        }
        if (!allBounds.isEmpty()) {
            Label upperBound = allBounds.size() == 1 ? (Label)allBounds.iterator().next() : this.ts.meetLabel(L.position(), allBounds);
            if (Report.should_report(topics, (int)4)) {
                Report.report((int)4, (String)("Using " + upperBound + " as upper bound for " + L));
            }
            return upperBound;
        }
        if (Report.should_report(topics, (int)4)) {
            Report.report((int)4, (String)("Using top as upper bound for " + L));
        }
        return this.ts.topLabel();
    }

    private boolean argLabelBoundRecursive(ArgLabel al) {
        ArgLabelGatherer alg = new ArgLabelGatherer();
        try {
            al.upperBound().subst(alg);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpcted SemanticError");
        }
        return alg.argLabels.contains(al);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.displayLabelAssertions);
        if (!this.ph().isEmpty()) {
            if (!this.labelAssertions.isEmpty()) {
                sb.append(", ");
            }
            sb.append(this.ph().actsForString());
        }
        if (!this.accessPathEquivReps.isEmpty()) {
            for (Map.Entry<AccessPath, AccessPath> e : this.accessPathEquivReps.entrySet()) {
                if (e.getKey() == e.getValue()) continue;
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(e.getKey().exprString());
                sb.append("==");
                sb.append(e.getValue().exprString());
            }
        }
        return sb.toString();
    }

    @Override
    public Map<String, List<String>> definitions(VarMap bounds, Set<Label> seenComponents) {
        LinkedHashMap<String, List<String>> defns = new LinkedHashMap<String, List<String>>();
        LinkedHashSet<Label> labelComponents = new LinkedHashSet<Label>();
        for (LabelLeAssertion c : this.labelAssertions) {
            Label bound = bounds.applyTo(c.lhs());
            Collection<Label> components = bound instanceof JoinLabel ? ((JoinLabel)bound).joinComponents() : (bound instanceof MeetLabel ? ((MeetLabel)bound).meetComponents() : Collections.singleton(bound));
            for (Label l : components) {
                labelComponents.add(l);
            }
            bound = bounds.applyTo(c.rhs());
            components = bound instanceof JoinLabel ? ((JoinLabel)bound).joinComponents() : (bound instanceof MeetLabel ? ((MeetLabel)bound).meetComponents() : Collections.singleton(bound));
            for (Label l : components) {
                labelComponents.add(l);
            }
        }
        labelComponents.removeAll(seenComponents);
        for (Label l : labelComponents) {
            if (l.description() == null) continue;
            String s = l.componentString();
            if (s.length() == 0) {
                s = l.toString();
            }
            defns.put(s, Collections.singletonList(l.description()));
        }
        return defns;
    }

    @Override
    public Label triggerTransforms(Label label) {
        LabelSubstitution subst = new LabelSubstitution(){

            @Override
            public Label substLabel(Label L) throws SemanticException {
                if (L instanceof WritersToReadersLabel) {
                    return ((WritersToReadersLabel)L).transform(LabelEnv_c.this);
                }
                return L;
            }
        };
        try {
            return label.subst(subst).simplify();
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException", (Throwable)e);
        }
    }

    protected LabelEnv.SearchState freshSearchState() {
        return new SearchState_c(null, null, null);
    }

    private static class AccessPathEquivalence {
        private final AccessPath p;
        private final AccessPath q;

        AccessPathEquivalence(AccessPath p, AccessPath q) {
            this.p = p;
            this.q = q;
        }

        public boolean equalsImpl(TypeObject t) {
            if (t instanceof AccessPathEquivalence) {
                AccessPathEquivalence that = (AccessPathEquivalence)t;
                return this.p.equals(that.p) && this.q.equals(that.q) || this.p.equals(that.q) && this.q.equals(that.p);
            }
            return false;
        }
    }

    private static class SearchState_c
    implements LabelEnv.SearchState {
        public final AssertionUseCount auc;
        public final LeqGoal currentGoal;
        public final SearchState_c prevState;
        public final boolean useAssertions;

        SearchState_c(AssertionUseCount auc, SearchState_c prevState, LeqGoal currentGoal) {
            this.useAssertions = auc != null;
            this.auc = auc;
            this.prevState = prevState;
            this.currentGoal = currentGoal;
        }

        public SearchState_c(AssertionUseCount auc) {
            this(auc, null, null);
        }

        public boolean containsGoal(LeqGoal g) {
            if (this.currentGoal != null && this.currentGoal.equals(g)) {
                return true;
            }
            if (this.prevState != null) {
                return this.prevState.containsGoal(g);
            }
            return false;
        }
    }

    private static class AssertionUseCount {
        private final AssertionUseCount previousAUC;
        private final Object use;
        private final int size;
        private final int accesspathsize;

        AssertionUseCount() {
            this.use = null;
            this.previousAUC = null;
            this.size = 0;
            this.accesspathsize = 0;
        }

        AssertionUseCount(AssertionUseCount auc, Assertion a) {
            this.use = a;
            this.previousAUC = auc;
            int s = 0;
            int aps = 0;
            if (this.previousAUC != null) {
                s = this.previousAUC.size();
                aps = this.previousAUC.accessPathSize();
            }
            if (this.use != null) {
                ++s;
            }
            this.size = s;
            this.accesspathsize = aps;
        }

        AssertionUseCount(AssertionUseCount auc, AccessPathEquivalence a) {
            this.use = a;
            this.previousAUC = auc;
            int s = 0;
            int aps = 0;
            if (this.previousAUC != null) {
                s = this.previousAUC.size();
                aps = this.previousAUC.accessPathSize();
            }
            if (this.use != null) {
                ++aps;
            }
            this.size = s;
            this.accesspathsize = aps;
        }

        public boolean allZero() {
            return this.size() == 0 && this.accessPathSize() == 0;
        }

        public int get(Assertion a) {
            int prev = 0;
            if (this.previousAUC != null) {
                prev = this.previousAUC.get(a);
            }
            if (this.use != null && this.use.equals(a)) {
                return 1 + prev;
            }
            return prev;
        }

        public int get(AccessPathEquivalence a) {
            int prev = 0;
            if (this.previousAUC != null) {
                prev = this.previousAUC.get(a);
            }
            if (this.use != null && this.use.equals(a)) {
                return 1 + prev;
            }
            return prev;
        }

        public int size() {
            return this.size;
        }

        public int accessPathSize() {
            return this.accesspathsize;
        }
    }

    private static class ArgLabelGatherer
    extends LabelSubstitution {
        private final Set<Label> argLabels = new LinkedHashSet<Label>();

        private ArgLabelGatherer() {
        }

        @Override
        public Label substLabel(Label L) {
            if (L instanceof ArgLabel) {
                this.argLabels.add(L);
            }
            return L;
        }
    }

    private static class LeqGoal {
        final int hash;
        final Object lhs;
        final Object rhs;

        LeqGoal(Policy lhs, Policy rhs) {
            int rhash;
            this.lhs = lhs;
            this.rhs = rhs;
            if (lhs == null || rhs == null) {
                throw new InternalCompilerError("Null policy!");
            }
            int lhash = lhs.hashCode();
            this.hash = lhash == (rhash = rhs.hashCode()) ? lhash : lhash ^ rhash;
        }

        LeqGoal(Label lhs, Label rhs) {
            int rhash;
            this.lhs = lhs;
            this.rhs = rhs;
            if (lhs == null || rhs == null) {
                throw new InternalCompilerError("Null label!");
            }
            int lhash = lhs.hashCode();
            this.hash = lhash == (rhash = rhs.hashCode()) ? lhash : lhash ^ rhash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o instanceof LeqGoal) {
                LeqGoal that = (LeqGoal)o;
                return this.hash == that.hash && this.lhs.equals(that.lhs) && this.rhs.equals(that.rhs);
            }
            return false;
        }

        public String toString() {
            return this.lhs + "<=" + this.rhs;
        }
    }
}

