/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jif.types.ActsForParam;
import jif.types.Equation;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.Param;
import jif.types.label.Label;
import jif.types.label.Policy;
import jif.types.label.VarLabel;
import jif.types.label.Variable;
import jif.types.principal.Principal;
import jif.types.principal.VarPrincipal;
import polyglot.types.ArrayType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;

public class VarMap {
    protected Map<Variable, ActsForParam> bounds;
    protected JifTypeSystem ts;
    protected final Label defaultLabelBound;
    protected final Principal defaultPrincipalBound;

    public VarMap(JifTypeSystem ts, Label defaultLabelBound, Principal defaultPrincipalBound) {
        this.ts = ts;
        this.bounds = new LinkedHashMap<Variable, ActsForParam>();
        this.defaultLabelBound = defaultLabelBound;
        this.defaultPrincipalBound = defaultPrincipalBound;
        if (defaultLabelBound == null || defaultPrincipalBound == null) {
            throw new InternalCompilerError("default bounds cannot be null");
        }
    }

    private VarMap(JifTypeSystem ts, Map<Variable, ActsForParam> bounds, Label defaultLabelBound, Principal defaultPrincipalBound) {
        this.ts = ts;
        this.bounds = new LinkedHashMap<Variable, ActsForParam>(bounds);
        this.defaultLabelBound = defaultLabelBound;
        this.defaultPrincipalBound = defaultPrincipalBound;
        if (defaultLabelBound == null || defaultPrincipalBound == null) {
            throw new InternalCompilerError("default bounds cannot be null");
        }
    }

    public VarMap copy() {
        return new VarMap(this.ts, this.bounds, this.defaultLabelBound, this.defaultPrincipalBound);
    }

    public Principal boundOf(VarPrincipal v) {
        Principal bound = (Principal)this.bounds.get(v);
        if (bound == null) {
            bound = this.defaultPrincipalBound;
            this.setBound((Variable)v, bound);
        }
        return bound;
    }

    public Label boundOf(VarLabel v) {
        Label bound = (Label)this.bounds.get(v);
        if (bound == null) {
            bound = this.defaultLabelBound;
            this.setBound((Variable)v, bound);
        }
        return bound;
    }

    public void setBound(Variable v, Label bound) {
        if (bound == null) {
            throw new InternalCompilerError("Null bound label.");
        }
        this.bounds.put(v, bound);
    }

    public void setBound(Variable v, Principal bound) {
        if (bound == null) {
            throw new InternalCompilerError("Null bound principal.");
        }
        this.bounds.put(v, bound);
    }

    public Policy applyTo(Policy p) {
        VarMapLabelSubstitution s = new VarMapLabelSubstitution();
        try {
            return p.subst(s);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException", (Throwable)e);
        }
    }

    public Param applyTo(Param c) {
        if (c instanceof Label) {
            return this.applyTo((Label)c);
        }
        if (c instanceof Principal) {
            return this.applyTo((Principal)c);
        }
        throw new InternalCompilerError("Unexpected Param" + c);
    }

    public Label applyTo(Label c) {
        VarMapLabelSubstitution s = new VarMapLabelSubstitution();
        try {
            return c.subst(s);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException", (Throwable)e);
        }
    }

    public void applyTo(Equation eqn) {
        VarMapLabelSubstitution s = new VarMapLabelSubstitution();
        try {
            eqn.subst(s);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException", (Throwable)e);
        }
    }

    public Principal applyTo(Principal p) {
        VarMapLabelSubstitution s = new VarMapLabelSubstitution();
        try {
            return p.subst(s);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException", (Throwable)e);
        }
    }

    public Type applyTo(Type t) {
        if (this.ts.isLabeled(t)) {
            Type baseType = this.ts.unlabel(t);
            Label L = this.ts.labelOfType(t);
            return this.ts.labeledType(t.position(), this.applyTo(baseType), this.applyTo(L));
        }
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            return at.base(this.applyTo(at.base()));
        }
        if (t instanceof JifSubstType) {
            JifSubstType jst = (JifSubstType)t;
            LinkedHashMap newMap = new LinkedHashMap();
            boolean diff = false;
            Iterator i = jst.entries();
            while (i.hasNext()) {
                ActsForParam p;
                Map.Entry e = (Map.Entry)i.next();
                Param arg = (Param)e.getValue();
                if (arg instanceof Label) {
                    p = this.applyTo((Label)arg);
                } else if (arg instanceof Principal) {
                    p = this.applyTo((Principal)arg);
                } else {
                    throw new InternalCompilerError("Unexpected type for entry: " + arg.getClass().getName());
                }
                newMap.put(e.getKey(), (Label)p);
                if (p == arg) continue;
                diff = true;
            }
            if (diff) {
                JifTypeSystem ts = (JifTypeSystem)t.typeSystem();
                t = ts.subst(jst.base(), newMap);
                return t;
            }
        }
        return t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("======== VAR MAP ========");
        sb.append('\n');
        for (Map.Entry<Variable, ActsForParam> e : this.bounds.entrySet()) {
            Variable var = e.getKey();
            ActsForParam bound = e.getValue();
            String s = "";
            if (var instanceof VarLabel) {
                s = ((VarLabel)var).componentString() + " = " + bound.toString();
                if (((VarLabel)var).description() != null) {
                    s = s + "    \t" + ((VarLabel)var).description();
                }
            } else {
                s = var + " = " + bound.toString();
            }
            sb.append(s);
            sb.append('\n');
        }
        sb.append("Variables not in this map will receive default bound of " + this.defaultLabelBound + " or " + this.defaultPrincipalBound + " as appropriate.");
        sb.append('\n');
        sb.append("=========================\n");
        return sb.toString();
    }

    public void dump(CodeWriter w) {
        w.write("======== VAR MAP ========");
        w.newline(0);
        for (Map.Entry<Variable, ActsForParam> e : this.bounds.entrySet()) {
            Variable var = e.getKey();
            ActsForParam bound = e.getValue();
            String s = "";
            if (var instanceof VarLabel) {
                s = ((VarLabel)var).componentString() + " = " + bound.toString();
                if (((VarLabel)var).description() != null) {
                    s = s + "    \t" + ((VarLabel)var).description();
                }
            } else {
                s = var + " = " + bound.toString();
            }
            w.write(s);
            w.newline(0);
        }
        w.write("Variables not in this map will receive default bound of " + this.defaultLabelBound + " or " + this.defaultPrincipalBound + " as appropriate.");
        w.newline(0);
        w.write("=========================");
        w.newline(0);
    }

    private class VarMapLabelSubstitution
    extends LabelSubstitution {
        private VarMapLabelSubstitution() {
        }

        @Override
        public Label substLabel(Label L) throws SemanticException {
            if (L instanceof VarLabel) {
                VarLabel v = (VarLabel)L;
                return VarMap.this.boundOf(v);
            }
            return L;
        }

        @Override
        public Principal substPrincipal(Principal p) throws SemanticException {
            if (p instanceof VarPrincipal) {
                VarPrincipal v = (VarPrincipal)p;
                return VarMap.this.boundOf(v);
            }
            return p;
        }
    }
}

