/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jif.JifOptions;
import jif.types.AbstractSolver;
import jif.types.Equation;
import jif.types.FailedConstraintSnapshot;
import jif.types.LabelConstraint;
import jif.types.LabelEquation;
import jif.types.LabelLeAssertion;
import jif.types.PrincipalEquation;
import jif.types.label.Variable;
import polyglot.main.Options;
import polyglot.types.SemanticException;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;

public class UnsatisfiableConstraintException
extends SemanticException {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected final AbstractSolver solver;
    protected final Equation failure;
    protected final FailedConstraintSnapshot snapshot;

    public UnsatisfiableConstraintException(AbstractSolver solver, Equation eqn, FailedConstraintSnapshot snapshot) {
        super(eqn.position());
        this.solver = solver;
        this.failure = eqn;
        this.snapshot = snapshot;
    }

    protected void reportTraces(Collection<Variable> variables) {
        for (Variable v : variables) {
            this.solver.reportTrace(v);
        }
    }

    public final FailedConstraintSnapshot getSnapshot() {
        return this.snapshot;
    }

    public final String getMessage() {
        StringBuffer sb = new StringBuffer();
        if (this.errorShowConstraint()) {
            sb.append("Unsatisfiable constraint");
            sb.append('\n');
            sb.append('\t');
            sb.append("general constraint:");
            sb.append('\n');
            sb.append('\t');
            sb.append('\t');
            this.appendNamedConstraint(sb);
            sb.append('\n');
            sb.append('\t');
            sb.append("in this context:");
            sb.append('\n');
            sb.append('\t');
            sb.append('\t');
            this.appendActualConstraint(sb);
            sb.append('\n');
            sb.append('\t');
            sb.append("cannot satisfy equation:");
            sb.append('\n');
            sb.append('\t');
            sb.append('\t');
            this.appendEquation(sb);
            sb.append('\n');
            sb.append('\t');
            sb.append("in environment:");
            sb.append('\n');
            for (LabelLeAssertion assertion : this.failure.env().labelAssertions()) {
                sb.append('\t');
                sb.append('\t');
                sb.append(assertion.lhs());
                sb.append(" \u2291 ");
                sb.append(assertion.rhs());
                sb.append('\n');
            }
            sb.append('\t');
            sb.append('\t');
            sb.append(this.failure.env().principalHierarchy());
            sb.append('\n');
            sb.append('\n');
        }
        if (this.errorShowDefns() && this.failure instanceof LabelEquation) {
            sb.append("Label Descriptions");
            sb.append('\n');
            sb.append("------------------");
            sb.append('\n');
            for (Map.Entry<String, List<String>> entry : this.definitions()) {
                for (String desc : entry.getValue()) {
                    sb.append(" - " + entry.getKey() + " = " + desc + "\n");
                }
            }
            sb.append('\n');
        }
        if (this.errorShowTechnicalMsg()) {
            sb.append(this.failure.constraint().technicalMsg());
        } else if (this.errorShowDetailMsg()) {
            sb.append(this.failure.constraint().detailMsg());
        } else {
            sb.append(this.failure.constraint().msg());
        }
        return sb.toString();
    }

    protected void appendNamedConstraint(StringBuffer sb) {
        if (!(this.failure instanceof LabelEquation)) {
            return;
        }
        LabelConstraint lc = ((LabelEquation)this.failure).labelConstraint();
        if (null == lc.namedLhs()) {
            return;
        }
        if (null == lc.namedRhs()) {
            return;
        }
        sb.append(lc.namedLhs());
        sb.append((Object)lc.kind());
        sb.append(lc.namedRhs());
    }

    protected void appendActualConstraint(StringBuffer sb) {
        sb.append(this.solver.bounds.applyTo(this.failure.constraint().lhs));
        sb.append((Object)this.failure.constraint.kind());
        sb.append(this.solver.bounds.applyTo(this.failure.constraint().rhs));
    }

    protected void appendEquation(StringBuffer sb) {
        if (this.failure instanceof LabelEquation) {
            LabelEquation le = (LabelEquation)this.failure;
            sb.append(le.lhs());
            sb.append(" \u2291 ");
            sb.append(le.rhs());
        } else if (this.failure instanceof PrincipalEquation) {
            PrincipalEquation pe = (PrincipalEquation)this.failure;
            sb.append(pe.lhs());
            sb.append(" \u227d ");
            sb.append(pe.rhs());
        } else {
            throw new InternalCompilerError(this.failure.position(), "unexpected equation type");
        }
    }

    protected Iterable<Map.Entry<String, List<String>>> definitions() {
        if (this.failure instanceof LabelEquation) {
            return ((LabelEquation)this.failure).labelConstraint().definitions(this.solver.bounds).entrySet();
        }
        return Collections.emptyList();
    }

    protected boolean errorShowConstraint() {
        return this.errorShowTechnicalMsg() || this.errorShowDetailMsg();
    }

    protected boolean errorShowTechnicalMsg() {
        return false;
    }

    protected boolean errorShowDetailMsg() {
        return ((JifOptions)Options.global).explainErrors;
    }

    protected boolean errorShowDefns() {
        return (this.errorShowTechnicalMsg() || this.errorShowDetailMsg()) && this.errorShowConstraint();
    }
}

