/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jif.types.ActsForConstraint;
import jif.types.ActsForParam;
import jif.types.Assertion;
import jif.types.AuthConstraint;
import jif.types.AutoEndorseConstraint;
import jif.types.CallerConstraint;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.LabelLeAssertion;
import jif.types.LabelSubstitution;
import jif.types.LabeledType;
import jif.types.label.Label;
import jif.types.principal.Principal;
import polyglot.types.ArrayType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;

public class TypeSubstitutor {
    private LabelSubstitution substitution;

    public TypeSubstitutor(LabelSubstitution substitution) {
        this.substitution = substitution;
    }

    public Type rewriteType(Type t) throws SemanticException {
        if (t instanceof LabeledType && this.recurseIntoLabeledType((LabeledType)t)) {
            LabeledType lt = (LabeledType)t;
            Label L = lt.labelPart();
            Type bt = lt.typePart();
            return lt.labelPart(this.rewriteLabel(L)).typePart(this.rewriteType(bt));
        }
        if (t instanceof ArrayType && this.recurseIntoArrayType((ArrayType)t)) {
            ArrayType at = (ArrayType)t;
            return at.base(this.rewriteType(at.base()));
        }
        if (t instanceof JifSubstType && this.recurseIntoSubstType((JifSubstType)t)) {
            JifSubstType jst = (JifSubstType)t;
            LinkedHashMap newMap = new LinkedHashMap();
            boolean diff = false;
            Iterator i = jst.entries();
            while (i.hasNext()) {
                ActsForParam p;
                Map.Entry e = (Map.Entry)i.next();
                Object arg = e.getValue();
                if (arg instanceof Label) {
                    p = this.rewriteLabel((Label)arg);
                } else if (arg instanceof Principal) {
                    p = this.rewritePrincipal((Principal)arg);
                } else {
                    throw new InternalCompilerError("Unexpected type for entry: " + arg.getClass().getName());
                }
                newMap.put(e.getKey(), (Label)p);
                if (p == arg) continue;
                diff = true;
            }
            if (diff) {
                JifTypeSystem ts = (JifTypeSystem)t.typeSystem();
                t = ts.subst(jst.base(), newMap);
                return t;
            }
        }
        return t;
    }

    protected boolean recurseIntoSubstType(JifSubstType type) {
        return true;
    }

    protected boolean recurseIntoArrayType(ArrayType type) {
        return true;
    }

    protected boolean recurseIntoLabeledType(LabeledType type) {
        return true;
    }

    public <P extends ActsForParam> P rewriteActsForParam(P param) throws SemanticException {
        if (param == null) {
            return null;
        }
        ActsForParam result = param.subst(this.substitution);
        return (P)result;
    }

    public Label rewriteLabel(Label L) throws SemanticException {
        return this.rewriteActsForParam(L);
    }

    protected Principal rewritePrincipal(Principal p) throws SemanticException {
        return this.rewriteActsForParam(p);
    }

    public <Actor extends ActsForParam, Granter extends ActsForParam> Assertion rewriteAssertion(Assertion a) throws SemanticException {
        if (a instanceof ActsForConstraint) {
            ActsForConstraint c = (ActsForConstraint)a.copy();
            c = c.actor(this.rewriteActsForParam((ActsForParam)c.actor()));
            c = c.granter(this.rewriteActsForParam((ActsForParam)c.granter()));
            return c;
        }
        if (a instanceof AuthConstraint) {
            AuthConstraint c = (AuthConstraint)a.copy();
            c = c.principals(this.rewritePrincipalList(c.principals()));
            return c;
        }
        if (a instanceof AutoEndorseConstraint) {
            AutoEndorseConstraint c = (AutoEndorseConstraint)a.copy();
            c = c.endorseTo(this.rewriteLabel(c.endorseTo()));
            return c;
        }
        if (a instanceof CallerConstraint) {
            CallerConstraint c = (CallerConstraint)a.copy();
            c = c.principals(this.rewritePrincipalList(c.principals()));
            return c;
        }
        if (a instanceof LabelLeAssertion) {
            LabelLeAssertion c = (LabelLeAssertion)a.copy();
            c = c.lhs(this.rewriteLabel(c.lhs()));
            c = c.rhs(this.rewriteLabel(c.rhs()));
            return c;
        }
        throw new InternalCompilerError("Unexpected assertion " + a);
    }

    private List<Principal> rewritePrincipalList(List<Principal> list) throws SemanticException {
        ArrayList<Principal> newList = new ArrayList<Principal>(list.size());
        for (Principal p : list) {
            newList.add(this.rewritePrincipal(p));
        }
        return newList;
    }
}

