/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.LinkedHashSet;
import java.util.Set;
import jif.types.Equation;
import jif.types.LabelSubstitution;
import jif.types.PrincipalConstraint;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.Variable;
import jif.types.principal.ConjunctivePrincipal;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.Principal;
import polyglot.types.SemanticException;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class PrincipalEquation
extends Equation {
    private Principal lhs;
    private Principal rhs;

    PrincipalEquation(Principal lhs, Principal rhs, PrincipalConstraint constraint) {
        super(constraint);
        this.lhs = lhs;
        this.rhs = rhs.simplify();
        if (lhs instanceof DisjunctivePrincipal) {
            throw new InternalCompilerError("LHS of equation must not be a disjunctive principal.");
        }
        if (rhs instanceof ConjunctivePrincipal) {
            throw new InternalCompilerError("LHS of equation must not be a conjunctive principal.");
        }
    }

    public Principal lhs() {
        return this.lhs;
    }

    public Principal rhs() {
        return this.rhs;
    }

    @Override
    public LabelEnv env() {
        return this.constraint().env();
    }

    @Override
    public Position position() {
        return this.constraint().position();
    }

    @Override
    public Object copy() {
        return new PrincipalEquation(this.lhs, this.rhs, (PrincipalConstraint)this.constraint);
    }

    public PrincipalConstraint principalConstraint() {
        return (PrincipalConstraint)this.constraint;
    }

    @Override
    public Set<Variable> variables() {
        LinkedHashSet<Variable> l = new LinkedHashSet<Variable>();
        l.addAll(this.lhs.variables());
        l.addAll(this.rhs.variables());
        return l;
    }

    @Override
    public int hashCode() {
        return this.lhs.hashCode() ^ this.rhs.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PrincipalEquation)) {
            return false;
        }
        PrincipalEquation eqn = (PrincipalEquation)o;
        if (this.constraint != eqn.constraint) {
            return false;
        }
        return this.lhs.equals(eqn.lhs) && this.rhs.equals(eqn.rhs);
    }

    @Override
    public String toString() {
        return this.lhs.toString() + " actsfor " + this.rhs.toString() + " in environment " + this.env() + " (produced from " + this.principalConstraint().lhsPrincipal() + (Object)((Object)this.principalConstraint().kind()) + this.principalConstraint().rhsPrincipal() + ") " + this.position();
    }

    @Override
    public void subst(LabelSubstitution subst) throws SemanticException {
        this.rhs = this.rhs.subst(subst);
        this.lhs = this.lhs.subst(subst);
    }
}

