/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jif.types.ExceptionPath;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.Path;
import jif.types.VarMap;
import jif.types.label.Label;
import jif.types.label.NotTaken;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;

public class PathMap {
    protected Map<Path, Label> map;
    protected JifTypeSystem ts;

    public PathMap(JifTypeSystem ts) {
        this.ts = ts;
        this.map = new HashMap<Path, Label>(5);
    }

    public Label get(Path p) {
        Label l = this.map.get(p);
        if (l == null) {
            return this.ts.notTaken();
        }
        return l;
    }

    public PathMap set(Path p, Label L) {
        PathMap n = this.ts.pathMap();
        n.map.putAll(this.map);
        if (L instanceof NotTaken) {
            n.map.remove(p);
        } else {
            n.map.put(p, L);
        }
        return n;
    }

    public Label N() {
        return this.get(Path.N);
    }

    public PathMap N(Label label) {
        return this.set(Path.N, label);
    }

    public Label NV() {
        return this.get(Path.NV);
    }

    public PathMap NV(Label label) {
        return this.set(Path.NV, label);
    }

    public Label R() {
        return this.get(Path.R);
    }

    public PathMap R(Label label) {
        return this.set(Path.R, label);
    }

    public PathMap exception(Type type, Label label) {
        return this.set(this.ts.exceptionPath(type), label);
    }

    public PathMap exc(Label label, Type type) {
        if (this.ts.isUncheckedException(type)) {
            return this;
        }
        ExceptionPath C = this.ts.exceptionPath(type);
        Label c = this.ts.join(label, this.get(C));
        Label n = this.ts.join(label, this.N());
        Label nv = this.ts.join(label, this.NV());
        return this.N(n).NV(nv).set(C, c);
    }

    public Set<Path> paths() {
        Set<Path> s = this.allPaths();
        s.remove(Path.NV);
        return s;
    }

    public Set<Path> allPaths() {
        return new LinkedHashSet<Path>(this.map.keySet());
    }

    public PathMap join(PathMap m) {
        PathMap n = this.ts.pathMap();
        n.map.putAll(this.map);
        for (Map.Entry<Path, Label> e : m.map.entrySet()) {
            Path p = e.getKey();
            Label l1 = e.getValue();
            Label l2 = n.get(p);
            n.map.put(p, this.ts.join(l1, l2));
        }
        return n;
    }

    public PathMap subst(LabelSubstitution subst) throws SemanticException {
        PathMap n = this.ts.pathMap();
        for (Map.Entry<Path, Label> e : this.map.entrySet()) {
            Path p = e.getKey();
            Label L = e.getValue();
            n.map.put(p, L.subst(subst));
        }
        return n;
    }

    public PathMap subst(VarMap bounds) {
        PathMap n = this.ts.pathMap();
        for (Map.Entry<Path, Label> e : this.map.entrySet()) {
            Path p = e.getKey();
            Label L = e.getValue();
            n.map.put(p, bounds.applyTo(L));
        }
        return n;
    }

    public String toString() {
        String s = "";
        Iterator<Map.Entry<Path, Label>> i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Path, Label> e = i.next();
            Path p = e.getKey();
            Label L = e.getValue();
            s = s + p.toString() + ":" + L.toString();
            if (!i.hasNext()) continue;
            s = s + " ";
        }
        return s;
    }

    public void dump(CodeWriter w) {
        w.write("X[");
        w.begin(0);
        boolean first = true;
        for (Map.Entry<Path, Label> e : this.map.entrySet()) {
            Path p = e.getKey();
            Label L = e.getValue();
            if (!first) {
                w.allowBreak(0);
                first = false;
            }
            w.write(p.toString() + ":" + L.toString());
        }
        w.end();
        w.write("]");
    }

    public boolean singlePath() {
        for (Path p : this.paths()) {
            if (p.equals(Path.N) || p.equals(Path.R)) continue;
            return false;
        }
        return true;
    }
}

