/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.Topics;
import jif.types.Equation;
import jif.types.FailedConstraintSnapshot;
import jif.types.Graph;
import jif.types.InformationFlowTrace;
import jif.types.LabelEquation;
import jif.types.label.JoinLabel;
import jif.types.label.Label;
import jif.types.label.VarLabel;
import jif.types.label.VarLabel_c;
import polyglot.main.Report;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;

public class LabelFlowGraph
extends Graph {
    List<InformationFlowTrace> tr;
    Set<String> files;
    FailedConstraintSnapshot jiferror;
    boolean generated;
    LabelNode root;
    static int count = 1;
    final FlowEdge staticEdge = new FlowEdge(null);
    public static final Collection<String> flowgraphtopic = CollectionUtil.list((Object)Topics.labelFlow);
    public static final int messageOnly = 1;
    public static final int detailedMessage = 2;
    public static final int showSlicedGraph = 3;
    public static final int showWholeGraph = 4;
    Map<LabelWrapper, LabelNode> lblToNode = new HashMap<LabelWrapper, LabelNode>();
    int varCounter = 0;

    public static boolean shouldReport(int obscurity) {
        return Report.should_report(flowgraphtopic, (int)obscurity);
    }

    public LabelFlowGraph(List<InformationFlowTrace> t, FailedConstraintSnapshot snapshot) {
        this.tr = t;
        this.generated = false;
        this.root = new LabelNode("ROOT", new VarLabel_c("ROOT", "fake label", null, null));
        this.files = new HashSet<String>();
        this.jiferror = snapshot;
    }

    public LabelNode getNode(Label label) {
        LabelWrapper lbl = new LabelWrapper(label);
        if (!this.lblToNode.containsKey(lbl)) {
            String vid = "v" + this.varCounter;
            LabelNode n = new LabelNode(vid, label);
            ++this.varCounter;
            if (label.position() != null) {
                this.files.add(label.position().path());
            }
            this.addEdge(this.root, n, this.staticEdge);
            this.lblToNode.put(lbl, n);
        }
        return this.lblToNode.get(lbl);
    }

    public void generateGraph() {
        if (this.generated || this.tr == null) {
            return;
        }
        for (InformationFlowTrace t : this.tr) {
            LabelNode to = this.getNode(t.varlbl);
            LabelNode source = this.getNode(t.lblflows);
            FlowEdge edge = new FlowEdge(t.equ);
            this.addEdge(source, to, edge);
            if (t.dir != InformationFlowTrace.Direction.BOTH) continue;
            this.addEdge(to, source, edge);
        }
        Equation con = this.jiferror.failedConstraint;
        if (con instanceof LabelEquation) {
            LabelEquation e = (LabelEquation)con;
            Label lhs = e.lhs();
            Label rhs = e.rhs();
            LabelNode to = this.getNode(rhs);
            LabelNode from = this.getNode(lhs);
            this.addEdge(from, to, new FlowEdge(e));
        }
        ArrayList<LabelNode> workingList = new ArrayList<LabelNode>(this.lblToNode.values());
        HashSet<LabelNode> processed = new HashSet<LabelNode>();
        while (workingList.size() != 0) {
            LabelNode currentnode = (LabelNode)workingList.get(0);
            workingList.remove(0);
            processed.add(currentnode);
            Label lbl = currentnode.label;
            if (!(lbl instanceof JoinLabel)) continue;
            JoinLabel join = (JoinLabel)lbl;
            Collection<Label> sourceset = join.joinComponents();
            for (Label srclbl : sourceset) {
                LabelNode srcnode = this.getNode(srclbl);
                if (!processed.contains(srclbl) && !workingList.contains(srclbl)) {
                    workingList.add(this.getNode(srclbl));
                }
                this.addEdge(srcnode, currentnode, this.staticEdge);
            }
        }
        this.generated = true;
    }

    private String sanitaze(String s) {
        if (s != null) {
            return s.replace('\"', '\'').replace("\\", "\\\\");
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDotString() {
        String ret = "";
        ToDotVisitor v = new ToDotVisitor();
        ArrayList<Graph.Node> visited = new ArrayList<Graph.Node>();
        this.root.acceptForward(v, visited);
        ret = ret + "digraph G1 {\n";
        for (String s : this.files) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(s));
                String line = reader.readLine();
                int linenum = 1;
                ret = ret + "source [shape=box, label=\"";
                while (line != null) {
                    ret = ret + linenum + ":\t" + this.sanitaze(line) + "\\l";
                    line = reader.readLine();
                    ++linenum;
                }
                ret = ret + "\"];\n";
            }
            catch (IOException e) {}
            continue;
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException line) {}
            }
        }
        ret = ret + "node [color = grey, style = filled];\n";
        ret = ret + v.getNodeString();
        ret = ret + v.getLinkString();
        ret = ret + "}\n";
        return ret;
    }

    public void slicing(Graph.Node backward, Graph.Node forward) {
        ArrayList<Graph.Node> visited = new ArrayList<Graph.Node>();
        backward.acceptBackward(new Graph.LabellingVisitor(), visited);
        visited = new ArrayList();
        forward.acceptForward(new Graph.LabellingVisitor(), visited);
    }

    public void showErrorPath() {
        FailedConstraintSnapshot snapshot = this.jiferror;
        boolean detail = LabelFlowGraph.shouldReport(2);
        if (!this.generated) {
            this.generateGraph();
        }
        if (snapshot.failedConstraint instanceof LabelEquation) {
            LabelEquation equ = (LabelEquation)snapshot.failedConstraint;
            Set<List<Graph.Node>> leftPaths = this.getBackwardPaths(this.getNode(equ.lhs()));
            Set<List<Graph.Node>> rightPaths = this.getForwardPaths(this.getNode(equ.rhs()));
            for (List<Graph.Node> leftpath : leftPaths) {
                LabelNode leftmost = (LabelNode)leftpath.get(0);
                for (List<Graph.Node> rightpath : rightPaths) {
                    FlowEdge edge;
                    LabelNode next;
                    int i;
                    boolean skip = false;
                    LabelNode rightmost = null;
                    for (Graph.Node n : rightpath) {
                        rightmost = (LabelNode)n;
                        if (!leftpath.contains(n)) continue;
                        skip = true;
                        break;
                    }
                    if (skip || snapshot.failedConstraint.env().leq(snapshot.bounds.applyTo(leftmost.label), snapshot.bounds.applyTo(rightmost.label))) continue;
                    System.out.println("\n----Start of one path----");
                    System.out.println(leftmost.getName());
                    LabelNode prev = leftmost;
                    for (i = 1; i < leftpath.size(); ++i) {
                        next = (LabelNode)leftpath.get(i);
                        edge = (FlowEdge)prev.outs.get(next);
                        System.out.println("--> (" + (detail ? edge.toStringDetail() : edge.toString()) + ")");
                        System.out.println(next.getName());
                        prev = next;
                    }
                    edge = new FlowEdge(snapshot.failedConstraint);
                    System.out.println("-> (" + (detail ? edge.toStringDetail() : edge.toString()) + ")");
                    prev = (LabelNode)rightpath.get(0);
                    System.out.println(prev.getName());
                    for (i = 1; i < rightpath.size(); ++i) {
                        next = (LabelNode)rightpath.get(i);
                        edge = (FlowEdge)prev.outs.get(next);
                        System.out.println("--> (" + (detail ? edge.toStringDetail() : edge.toString()) + ")");
                        System.out.println(next.getName());
                        prev = next;
                    }
                    System.out.println("----End of one path----\n");
                }
            }
        }
    }

    public void writeToDotFile() {
        FailedConstraintSnapshot snapshot = this.jiferror;
        String filename = "error" + count + ".dot";
        ++count;
        if (!this.generated) {
            this.generateGraph();
        }
        try {
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            if (!LabelFlowGraph.shouldReport(4)) {
                LabelEquation equ = (LabelEquation)snapshot.failedConstraint;
                this.slicing(this.getNode(equ.lhs()), this.getNode(equ.rhs()));
            } else {
                this.labelAll(this.root);
            }
            this.root.shouldprint = false;
            out.write(this.toDotString());
            out.close();
        }
        catch (IOException e) {
            System.out.println("Unable to write the DOT file to: " + filename);
        }
    }

    private class ToDotVisitor
    implements Graph.NodeVisitor {
        Set<Integer> sourcePosition = new HashSet<Integer>();
        String nodes = "";
        String links = "";

        private ToDotVisitor() {
        }

        @Override
        public void discoverVertex(Graph.Node n) {
        }

        @Override
        public void leaveVertex(Graph.Node n) {
        }

        @Override
        public void visit(Graph.Node node) {
            if (node instanceof LabelNode) {
                LabelNode n = (LabelNode)node;
                if (!n.shouldprint) {
                    return;
                }
                this.sourcePosition.addAll(n.getPositions());
                this.nodes = this.nodes + n.printNodeToDotString();
                this.links = this.links + n.printLinkToDotString();
            }
        }

        String getNodeString() {
            return this.nodes;
        }

        String getLinkString() {
            return this.links;
        }
    }

    private class LabelNode
    extends Graph.Node {
        String uid;
        Label label;

        public LabelNode(String id, Label label) {
            this.uid = id;
            this.label = label;
        }

        public String getName() {
            if (this.label == null) {
                System.out.println("NULL!!");
            }
            if (this.label instanceof VarLabel) {
                return ((VarLabel)this.label).name() + (this.label.position() == null ? "" : "@" + this.label.position().toString());
            }
            return (this.label.description() == null ? "" : this.label.description()) + this.label.toString() + (this.label.position() == null ? "" : "@" + this.label.position().toString());
        }

        public Position position() {
            return this.label.position();
        }

        @Override
        public boolean isend(boolean isbackward) {
            if (isbackward) {
                return !this.label.hasVariableComponents() && !(this.label instanceof JoinLabel);
            }
            return !this.label.hasVariableComponents();
        }

        public String toString() {
            return "Current node: " + this.getName() + "\n";
        }

        public String printNodeToDotString() {
            return this.uid + " [label=\"" + this.getName() + "\\n" + this.label.position() + "\"];\n";
        }

        public String printLinkToDotString() {
            String ret = "";
            for (Graph.Node node : this.outs.keySet()) {
                LabelNode n = (LabelNode)node;
                String linkinfo = ((FlowEdge)this.outs.get(n)).toDotString();
                if (!n.shouldprint) continue;
                ret = ret + this.uid + "->" + n.uid + " [label=\"" + linkinfo + "\"];\n";
            }
            return ret;
        }

        public Set<Integer> getPositions() {
            HashSet<Integer> ret = new HashSet<Integer>();
            if (this.position() != null) {
                ret.add(this.position().line());
            }
            for (Graph.Node n : this.outs.keySet()) {
                if (!n.shouldprint) continue;
                ret.add(((FlowEdge)this.outs.get(n)).getLineno());
            }
            return ret;
        }
    }

    private class LabelWrapper {
        Label label;

        public LabelWrapper(Label lbl) {
            this.label = lbl;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LabelWrapper)) {
                return false;
            }
            LabelWrapper labelwrap = (LabelWrapper)obj;
            return this.label == labelwrap.label;
        }

        public int hashCode() {
            return this.label.hashCode();
        }
    }

    private class FlowEdge
    extends Graph.Edge {
        Equation equ;

        public FlowEdge(Equation eq) {
            this.equ = eq;
        }

        public int getLineno() {
            if (this.equ != null) {
                return this.equ.position().line();
            }
            return 0;
        }

        public String toString() {
            if (this.equ != null) {
                return "because of constraint: " + this.equ.constraint.toString();
            }
            return "join";
        }

        public String toStringDetail() {
            if (this.equ != null) {
                return this.toString() + "\n(Why this constraint?) " + this.equ.constraint.detailMsg();
            }
            return this.toString();
        }

        public String toDotString() {
            if (this.equ != null) {
                return this.equ.constraint().lhs.toString() + this.equ.constraint.kind.toString() + this.equ.constraint.rhs.toString();
            }
            return "join";
        }
    }
}

