/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jif.extension.LabelTypeCheckUtil;
import jif.types.Constraint;
import jif.types.ConstraintMessage;
import jif.types.Equation;
import jif.types.LabelEquation;
import jif.types.NamedLabel;
import jif.types.VarMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.JoinLabel;
import jif.types.label.Label;
import jif.types.label.MeetLabel;
import jif.types.label.WritersToReadersLabel;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class LabelConstraint
extends Constraint {
    public static final Constraint.Kind EQUAL = new Constraint.Kind(" == ");
    public static final Constraint.Kind LEQ = new Constraint.Kind(" \u2291 ");
    protected NamedLabel namedLHS;
    protected NamedLabel namedRHS;

    public LabelConstraint(NamedLabel lhs, Constraint.Kind kind, NamedLabel rhs, LabelEnv env, Position pos, ConstraintMessage msg, boolean report) {
        super(lhs.label(), kind, rhs.label(), env, pos, msg, report);
        this.namedLHS = lhs;
        this.namedRHS = rhs;
    }

    public Label lhsLabel() {
        return (Label)this.lhs;
    }

    public Label rhsLabel() {
        return (Label)this.rhs;
    }

    public NamedLabel namedLhs() {
        return this.namedLHS;
    }

    public NamedLabel namedRhs() {
        return this.namedRHS;
    }

    protected Map<String, Label> namedLabels() {
        LinkedHashMap<String, Label> ne = new LinkedHashMap<String, Label>();
        if (this.namedLHS != null) {
            ne.putAll(this.namedLHS.nameToLabels);
        }
        if (this.namedRHS != null) {
            ne.putAll(this.namedRHS.nameToLabels);
        }
        return ne;
    }

    protected Map<String, String> namedDescrips() {
        LinkedHashMap<String, String> ne = new LinkedHashMap<String, String>();
        if (this.namedLHS != null) {
            ne.putAll(this.namedLHS.nameToDescrip);
        }
        if (this.namedRHS != null) {
            ne.putAll(this.namedRHS.nameToDescrip);
        }
        return ne;
    }

    public Map<String, List<String>> definitions(VarMap bounds) {
        LinkedHashMap<String, List<String>> defns = new LinkedHashMap<String, List<String>>();
        LinkedHashSet<Label> labelComponents = new LinkedHashSet<Label>();
        Map<String, Label> namedLabels = this.namedLabels();
        Map<String, String> namedDescrips = this.namedDescrips();
        LabelTypeCheckUtil ltcu = this.lhs.typeSystem().labelTypeCheckUtil();
        for (String s : namedLabels.keySet()) {
            ArrayList<String> arrayList = new ArrayList<String>(2);
            defns.put(s, arrayList);
            if (namedDescrips.get(s) != null) {
                arrayList.add(namedDescrips.get(s));
            }
            Label bound = bounds.applyTo(namedLabels.get(s));
            arrayList.add(bound.toString());
            labelComponents.addAll(ltcu.labelComponents(bound));
        }
        Label bound = bounds.applyTo(this.lhsLabel());
        labelComponents.addAll(ltcu.labelComponents(bound));
        bound = bounds.applyTo(this.rhsLabel());
        labelComponents.addAll(ltcu.labelComponents(bound));
        for (Label label : labelComponents) {
            if (label.description() == null) continue;
            String s = label.componentString();
            if (s.length() == 0) {
                s = label.toString();
            }
            ArrayList<String> list = new ArrayList<String>(2);
            list.add(label.description());
            defns.put(s, list);
            if (!(label instanceof WritersToReadersLabel)) continue;
            list.add(this.env.triggerTransforms(label).toString());
        }
        defns.putAll(this.env.definitions(bounds, labelComponents));
        return defns;
    }

    @Override
    public Collection<Equation> getEquations() {
        LinkedList<Equation> eqns = new LinkedList<Equation>();
        if (this.kind == LEQ) {
            this.addLEQEqns(eqns, this.lhsLabel(), this.rhsLabel());
        } else if (this.kind == EQUAL) {
            this.addLEQEqns(eqns, this.lhsLabel(), this.rhsLabel());
            this.addLEQEqns(eqns, this.rhsLabel(), this.lhsLabel());
        } else {
            throw new InternalCompilerError("Inappropriate kind of equation: " + (Object)((Object)this.kind));
        }
        return eqns;
    }

    protected void addLEQEqns(Collection<Equation> eqns, Label left, Label right) {
        left = left.simplify();
        right = right.simplify();
        if (left instanceof JoinLabel) {
            for (Label jc : ((JoinLabel)left).joinComponents()) {
                this.addLEQEqns(eqns, jc, right);
            }
        } else if (right instanceof MeetLabel) {
            for (Label mc : ((MeetLabel)right).meetComponents()) {
                this.addLEQEqns(eqns, left, mc);
            }
        } else {
            LabelEquation eqn = new LabelEquation(left, right, this);
            eqns.add(eqn);
        }
    }

    @Override
    public boolean hasVariables() {
        return this.lhsLabel().hasVariables() || this.rhsLabel().hasVariables();
    }
}

