/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.JifOptions;
import jif.ast.DowngradeExpr;
import jif.ast.LabelExpr;
import jif.ast.PrincipalExpr;
import jif.ast.PrincipalNode;
import jif.extension.LabelTypeCheckUtil;
import jif.translate.ActsForConstraintToJavaExpr;
import jif.translate.ActsForConstraintToJavaExpr_c;
import jif.translate.ConjunctivePrincipalToJavaExpr_c;
import jif.translate.DisjunctivePrincipalToJavaExpr_c;
import jif.translate.DynamicLabelToJavaExpr_c;
import jif.translate.DynamicPrincipalToJavaExpr_c;
import jif.translate.JoinLabelToJavaExpr_c;
import jif.translate.LabelLeAssertionToJavaExpr;
import jif.translate.LabelLeAssertionToJavaExpr_c;
import jif.translate.LabelToJavaExpr;
import jif.translate.MeetLabelToJavaExpr_c;
import jif.translate.PairLabelToJavaExpr_c;
import jif.translate.ParamToJavaExpr_c;
import jif.translate.PrincipalToJavaExpr;
import jif.translate.ProviderLabelToJavaExpr_c;
import jif.types.ActsForConstraint;
import jif.types.ActsForConstraint_c;
import jif.types.ActsForParam;
import jif.types.Assertion;
import jif.types.AuthConstraint;
import jif.types.AuthConstraint_c;
import jif.types.AutoEndorseConstraint;
import jif.types.AutoEndorseConstraint_c;
import jif.types.CallerConstraint;
import jif.types.CallerConstraint_c;
import jif.types.ConstArrayType;
import jif.types.ConstArrayType_c;
import jif.types.DefaultSignature;
import jif.types.ExceptionPath;
import jif.types.ExceptionPath_c;
import jif.types.FixedSignature;
import jif.types.GotoPath_c;
import jif.types.JifClassType;
import jif.types.JifConstructorInstance;
import jif.types.JifConstructorInstance_c;
import jif.types.JifContext;
import jif.types.JifContext_c;
import jif.types.JifDeserializedClassInitializer;
import jif.types.JifFieldInstance;
import jif.types.JifFieldInstance_c;
import jif.types.JifLazyClassInitializer_c;
import jif.types.JifLocalInstance;
import jif.types.JifLocalInstance_c;
import jif.types.JifMethodInstance;
import jif.types.JifMethodInstance_c;
import jif.types.JifMuPClass_c;
import jif.types.JifParsedPolyType;
import jif.types.JifParsedPolyType_c;
import jif.types.JifPolyType;
import jif.types.JifProcedureInstance;
import jif.types.JifSubstType;
import jif.types.JifSubst_c;
import jif.types.JifTypeSystem;
import jif.types.LabelLeAssertion;
import jif.types.LabelLeAssertion_c;
import jif.types.LabeledType;
import jif.types.LabeledType_c;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.ParamInstance_c;
import jif.types.Path;
import jif.types.PathMap;
import jif.types.PrincipalInstance;
import jif.types.PrincipalInstance_c;
import jif.types.SemanticDetailedException;
import jif.types.Solver;
import jif.types.SolverGLB;
import jif.types.UnknownParam_c;
import jif.types.hierarchy.LabelEnv;
import jif.types.hierarchy.LabelEnv_c;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathClass;
import jif.types.label.AccessPathConstant;
import jif.types.label.AccessPathField;
import jif.types.label.AccessPathLocal;
import jif.types.label.AccessPathRoot;
import jif.types.label.AccessPathThis;
import jif.types.label.ArgLabel;
import jif.types.label.ArgLabel_c;
import jif.types.label.ConfPolicy;
import jif.types.label.ConfProjectionPolicy_c;
import jif.types.label.CovariantParamLabel;
import jif.types.label.CovariantParamLabel_c;
import jif.types.label.DynamicLabel;
import jif.types.label.DynamicLabel_c;
import jif.types.label.IntegPolicy;
import jif.types.label.IntegProjectionPolicy_c;
import jif.types.label.JoinConfPolicy_c;
import jif.types.label.JoinIntegPolicy_c;
import jif.types.label.JoinLabel;
import jif.types.label.JoinLabel_c;
import jif.types.label.Label;
import jif.types.label.MeetConfPolicy_c;
import jif.types.label.MeetIntegPolicy_c;
import jif.types.label.MeetLabel;
import jif.types.label.MeetLabel_c;
import jif.types.label.NotTaken;
import jif.types.label.NotTaken_c;
import jif.types.label.PairLabel;
import jif.types.label.PairLabel_c;
import jif.types.label.ParamLabel;
import jif.types.label.ParamLabel_c;
import jif.types.label.Policy;
import jif.types.label.ProviderLabel;
import jif.types.label.ProviderLabel_c;
import jif.types.label.ReaderPolicy;
import jif.types.label.ReaderPolicy_c;
import jif.types.label.ThisLabel;
import jif.types.label.ThisLabel_c;
import jif.types.label.UnknownLabel;
import jif.types.label.UnknownLabel_c;
import jif.types.label.VarLabel;
import jif.types.label.VarLabel_c;
import jif.types.label.WriterPolicy;
import jif.types.label.WriterPolicy_c;
import jif.types.label.WritersToReadersLabel;
import jif.types.label.WritersToReadersLabel_c;
import jif.types.principal.BottomPrincipal;
import jif.types.principal.BottomPrincipal_c;
import jif.types.principal.ConjunctivePrincipal;
import jif.types.principal.ConjunctivePrincipal_c;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.DisjunctivePrincipal_c;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.DynamicPrincipal_c;
import jif.types.principal.ExternalPrincipal;
import jif.types.principal.ExternalPrincipal_c;
import jif.types.principal.ParamPrincipal;
import jif.types.principal.ParamPrincipal_c;
import jif.types.principal.Principal;
import jif.types.principal.TopPrincipal;
import jif.types.principal.TopPrincipal_c;
import jif.types.principal.UnknownPrincipal;
import jif.types.principal.UnknownPrincipal_c;
import jif.types.principal.VarPrincipal;
import jif.types.principal.VarPrincipal_c;
import polyglot.ast.Branch;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Local;
import polyglot.ast.NullLit;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.TypeNode;
import polyglot.ext.param.types.MuPClass;
import polyglot.ext.param.types.PClass;
import polyglot.ext.param.types.ParamTypeSystem_c;
import polyglot.ext.param.types.Subst;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Source;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.InitializerInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.PrimitiveType_c;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownQualifier;
import polyglot.types.UnknownType;
import polyglot.types.VarInstance;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLazyClassInitializer;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JifTypeSystem_c
extends ParamTypeSystem_c<ParamInstance, Param>
implements JifTypeSystem {
    protected final TypeSystem jlts;
    private final LabelEnv emptyLabelEnv = this.createEmptyLabelEnv();
    private final DefaultSignature ds;
    private static final PrimitiveType.Kind PRINCIPAL_KIND = new PrimitiveType.Kind("principal");
    private static final PrimitiveType.Kind LABEL_KIND = new PrimitiveType.Kind("label");
    protected PrimitiveType PRINCIPAL_;
    protected PrimitiveType LABEL_;
    protected Type PRINCIPAL_CLASS_ = null;
    private Label top = null;
    private Label bottom = null;
    private Label noComponents = null;
    private Label notTaken = null;
    static String JIF_SIG_OF_JAVA_MARKER = "__JIF_SIG_OF_JAVA_CLASS$20030619";
    static String JIF_PARAMS_RUNTIME_MARKER = "__JIF_PARAMS_RUNTIME_REPRESENTED$20051007";
    static String JIF_SAFE_CONSTRUCTOR_MARKER = "__JIF_SAFE_CONSTRUCTORS$20050907";
    protected LabelTypeCheckUtil ltcu = null;

    public JifTypeSystem_c(TypeSystem jlts) {
        this.jlts = jlts;
        this.ds = new FixedSignature(this);
    }

    public LazyClassInitializer deserializedClassInitializer() {
        return new JifDeserializedClassInitializer((TypeSystem)this);
    }

    @Override
    public Solver createSolver(String solverName) {
        return new SolverGLB(this, this.extInfo.compiler(), solverName);
    }

    protected LabelEnv createEmptyLabelEnv() {
        return new LabelEnv_c(this, false);
    }

    @Override
    public LabelEnv createLabelEnv() {
        return new LabelEnv_c(this, true);
    }

    public MuPClass<ParamInstance, Param> mutablePClass(Position pos) {
        return new JifMuPClass_c(this, pos);
    }

    public LazyClassInitializer defaultClassInitializer() {
        return new JifLazyClassInitializer_c((TypeSystem)this);
    }

    public void initialize(TopLevelResolver loadedResolver, ExtensionInfo extInfo) throws SemanticException {
        super.initialize(loadedResolver, extInfo);
        this.PRINCIPAL_ = new PrimitiveType_c((TypeSystem)this, PRINCIPAL_KIND);
        this.LABEL_ = new PrimitiveType_c((TypeSystem)this, LABEL_KIND);
    }

    public UnknownType unknownType(Position pos) {
        UnknownType t = super.unknownType(pos);
        return t;
    }

    public UnknownQualifier unknownQualifier(Position pos) {
        UnknownQualifier t = super.unknownQualifier(pos);
        return t;
    }

    @Override
    public String PrincipalClassName() {
        return "jif.lang.Principal";
    }

    @Override
    public String PrincipalUtilClassName() {
        return "jif.lang.PrincipalUtil";
    }

    @Override
    public String LabelClassName() {
        return "jif.lang.Label";
    }

    @Override
    public String LabelUtilClassName() {
        return "jif.lang.LabelUtil";
    }

    @Override
    public String RuntimePackageName() {
        return "jif.runtime";
    }

    @Override
    public PrimitiveType Principal() {
        return this.PRINCIPAL_;
    }

    @Override
    public Type PrincipalClass() {
        if (this.PRINCIPAL_CLASS_ == null) {
            try {
                this.PRINCIPAL_CLASS_ = this.typeForName(this.PrincipalClassName());
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Cannot find Jif class " + this.PrincipalClassName(), (Throwable)e);
            }
        }
        return this.PRINCIPAL_CLASS_;
    }

    @Override
    public PrimitiveType Label() {
        return this.LABEL_;
    }

    @Override
    public JifContext createContext() {
        return new JifContext_c(this, this.jlts);
    }

    @Override
    public ConstArrayType constArrayOf(Type type) {
        return this.constArrayOf(type.position(), type);
    }

    @Override
    public ConstArrayType constArrayOf(Position pos, Type type) {
        return this.constArrayOf(pos, type, false);
    }

    public ConstArrayType constArrayOf(Position pos, Type type, boolean castableToNonConst) {
        return new ConstArrayType_c(this, pos, type, true, castableToNonConst);
    }

    @Override
    public ConstArrayType constArrayOf(Type type, int dims) {
        return this.constArrayOf(null, type, dims);
    }

    @Override
    public ConstArrayType constArrayOf(Position pos, Type type, int dims) {
        return this.constArrayOf(pos, type, dims, false);
    }

    @Override
    public ConstArrayType constArrayOf(Position pos, Type type, int dims, boolean castableToNonConst) {
        return this.constArrayOf(pos, type, dims, castableToNonConst, false);
    }

    @Override
    public ConstArrayType constArrayOf(Position pos, Type type, int dims, boolean castableToNonConst, boolean recurseIntoBaseType) {
        if (recurseIntoBaseType && type.isArray()) {
            ArrayType baseArray = type.toArray();
            type = this.constArrayOf(pos, baseArray.base(), 1, castableToNonConst, recurseIntoBaseType);
        }
        if (dims > 1) {
            return this.constArrayOf(pos, (Type)this.constArrayOf(pos, (Type)type, dims - 1, castableToNonConst));
        }
        if (dims == 1) {
            return this.constArrayOf(pos, (Type)type, castableToNonConst);
        }
        throw new InternalCompilerError("Must call constArrayOf(type, dims) with dims > 0");
    }

    protected ArrayType arrayType(Position pos, Type type) {
        if (!this.isLabeled(type)) {
            type = this.labeledType(pos, type, this.defaultSignature().defaultArrayBaseLabel(type));
        }
        return new ConstArrayType_c(this, pos, type, false);
    }

    public InitializerInstance initializerInstance(Position pos, ClassType container, Flags flags) {
        InitializerInstance ii = super.initializerInstance(pos, container, flags);
        return ii;
    }

    public FieldInstance fieldInstance(Position pos, ReferenceType container, Flags flags, Type type, String name) {
        JifFieldInstance_c fi = new JifFieldInstance_c(this, pos, container, flags, type, name);
        return fi;
    }

    public LocalInstance localInstance(Position pos, Flags flags, Type type, String name) {
        JifLocalInstance_c li = new JifLocalInstance_c(this, pos, flags, type, name);
        return li;
    }

    public ConstructorInstance constructorInstance(Position pos, ClassType container, Flags flags, List<? extends Type> formalTypes, List<? extends Type> excTypes) {
        return this.jifConstructorInstance(pos, container, flags, this.unknownLabel(pos), false, this.unknownLabel(pos), false, formalTypes, Collections.emptyList(), excTypes, Collections.emptyList());
    }

    public JifConstructorInstance jifConstructorInstance(Position pos, ClassType container, Flags flags, Label startLabel, boolean isDefaultStartLabel, Label returnLabel, boolean isDefaultReturnLabel, List<? extends Type> formalTypes, List<Label> formalArgLabels, List<? extends Type> excTypes, List<Assertion> constraints) {
        JifConstructorInstance_c ci = new JifConstructorInstance_c(this, pos, container, flags, startLabel, isDefaultStartLabel, returnLabel, isDefaultReturnLabel, formalTypes, formalArgLabels, excTypes, constraints);
        return ci;
    }

    public MethodInstance methodInstance(Position pos, ReferenceType container, Flags flags, Type returnType, String name, List<? extends Type> formalTypes, List<? extends Type> excTypes) {
        return this.jifMethodInstance(pos, container, flags, returnType, name, this.unknownLabel(pos), false, formalTypes, Collections.emptyList(), this.unknownLabel(pos), false, excTypes, Collections.emptyList());
    }

    @Override
    public JifMethodInstance jifMethodInstance(Position pos, ReferenceType container, Flags flags, Type returnType, String name, Label startLabel, boolean isDefaultStartLabel, List<? extends Type> formalTypes, List<Label> formalArgLabels, Label endLabel, boolean isDefaultEndLabel, List<? extends Type> excTypes, List<Assertion> constraints) {
        JifMethodInstance_c mi = new JifMethodInstance_c(this, pos, container, flags, returnType, name, startLabel, isDefaultStartLabel, formalTypes, formalArgLabels, endLabel, isDefaultEndLabel, excTypes, constraints);
        return mi;
    }

    @Override
    public ParamInstance paramInstance(Position pos, JifClassType container, ParamInstance.Kind kind, String name) {
        ParamInstance_c pi = new ParamInstance_c(this, pos, container, kind, name);
        return pi;
    }

    @Override
    public PrincipalInstance principalInstance(Position pos, ExternalPrincipal principal) {
        PrincipalInstance_c pi = new PrincipalInstance_c(this, pos, principal);
        return pi;
    }

    public boolean descendsFrom(Type child, Type ancestor) {
        return super.descendsFrom(this.strip(child), this.strip(ancestor));
    }

    public boolean isSubtype(Type child, Type ancestor) {
        return super.isSubtype(this.strip(child), this.strip(ancestor));
    }

    public boolean isCastValid(Type fromType, Type toType) {
        Type strpFromType = this.strip(fromType);
        Type strpToType = this.strip(toType);
        if (this.Principal().equals(strpFromType) && this.isCastValid(this.PrincipalClass(), toType)) {
            return true;
        }
        if (this.Principal().equals(strpToType) && this.isSubtype(strpFromType, this.PrincipalClass())) {
            return true;
        }
        return super.isCastValid(strpFromType, strpToType);
    }

    public boolean isImplicitCastValid(Type fromType, Type toType) {
        Type strpFromType = this.strip(fromType);
        Type strpToType = this.strip(toType);
        if (this.Principal().equals(strpFromType) && this.PrincipalClass().equals(strpToType)) {
            return true;
        }
        if (this.Principal().equals(strpToType) && this.isSubtype(strpFromType, this.PrincipalClass())) {
            return true;
        }
        return super.isImplicitCastValid(strpFromType, strpToType);
    }

    public Type staticTarget(Type t) {
        JifParsedPolyType jppt;
        if (t instanceof JifParsedPolyType && (jppt = (JifParsedPolyType)t).params().size() > 0) {
            return jppt.instantiatedFrom().clazz();
        }
        return super.staticTarget(t);
    }

    @Override
    public boolean equalsNoStrip(TypeObject t1, TypeObject t2) {
        return super.equals(t1, t2);
    }

    @Override
    public boolean equalsStrip(TypeObject t1, TypeObject t2) {
        if (t1 instanceof Type) {
            t1 = this.strip((Type)t1);
        }
        if (t2 instanceof Type) {
            t2 = this.strip((Type)t2);
        }
        return super.equals(t1, t2);
    }

    public boolean equals(TypeObject t1, TypeObject t2) {
        return this.equalsStrip(t1, t2);
    }

    public boolean typeEquals(Type t1, Type t2) {
        return this.equals((TypeObject)t1, (TypeObject)t2);
    }

    protected Type leastCommonAncestorSubtype(Type subtype, Type supertype) {
        while (subtype != null && !this.equals((TypeObject)subtype, (TypeObject)supertype)) {
            subtype = subtype.toClass().superType();
        }
        Iterator<Param> iter1 = ((JifClassType)subtype).actuals().iterator();
        Iterator<Param> iter2 = ((JifClassType)supertype).actuals().iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            Param p1 = iter1.next();
            Param p2 = iter2.next();
            if (p1 instanceof Principal && p2 instanceof Principal && !((Principal)p1).equals(p2)) {
                return null;
            }
            if (!(p1 instanceof Label && p2 instanceof Label ? !this.leq((Label)p1, (Label)p2) || !this.leq((Label)p2, (Label)p1) : !p1.equals(p2))) continue;
            return null;
        }
        if (iter1.hasNext() || iter2.hasNext()) {
            return null;
        }
        return supertype;
    }

    public Type leastCommonAncestor(Type type1, Type type2) throws SemanticException {
        this.assert_((TypeObject)type1);
        this.assert_((TypeObject)type2);
        type1 = this.unlabel(type1);
        type2 = this.unlabel(type2);
        if (type1.isNumeric() || type2.isNumeric() || type1.isNull() || type2.isNull()) {
            return super.leastCommonAncestor(this.strip(type1), this.strip(type2));
        }
        if (type1.isArray() && type2.isArray()) {
            Type base1 = type1.toArray().base();
            Type base2 = type2.toArray().base();
            Label L1 = this.labelOfType(base1);
            Label L2 = this.labelOfType(base2);
            Label arrL = null;
            if (L1 instanceof VarLabel) {
                arrL = L2;
            } else if (L2 instanceof VarLabel) {
                arrL = L1;
            } else if (this.leq(L1, L2) && this.leq(L2, L1)) {
                arrL = L1;
            }
            if (arrL != null) {
                return this.arrayOf(this.labeledType(base1.position(), this.leastCommonAncestor(this.unlabel(base1), this.unlabel(base2)), arrL));
            }
            return this.Object();
        }
        if (type1 == type2) {
            return type1;
        }
        if (type1.isReference() && type2.isReference()) {
            Type t2;
            Type t;
            if (type1.isClass() && type1.toClass().flags().isInterface()) {
                return this.Object();
            }
            if (type2.isClass() && type2.toClass().flags().isInterface()) {
                return this.Object();
            }
            if (this.equals((TypeObject)type1, (TypeObject)this.Object())) {
                return type1;
            }
            if (this.equals((TypeObject)type2, (TypeObject)this.Object())) {
                return type2;
            }
            if (!(type1 instanceof JifClassType) || !(type2 instanceof JifClassType)) {
                return this.Object();
            }
            if (this.isSubtype(type1, type2) && (t = this.leastCommonAncestorSubtype(type1, type2)) != null) {
                return t;
            }
            if (this.isSubtype(type2, type1) && (t = this.leastCommonAncestorSubtype(type2, type1)) != null) {
                return t;
            }
            Type t1 = this.leastCommonAncestor(type1.toReference().superType(), type2);
            if (this.equals((TypeObject)t1, (TypeObject)(t2 = this.leastCommonAncestor(type2.toReference().superType(), type1)))) {
                return t1;
            }
            return this.Object();
        }
        throw new SemanticException("No least common ancestor found for types \"" + type1 + "\" and \"" + type2 + "\".");
    }

    public boolean numericConversionValid(Type t, Object value) {
        return super.numericConversionValid(this.strip(t), value);
    }

    public ParsedClassType createClassType(LazyClassInitializer init, Source fromSource) {
        if (!init.fromClassFile()) {
            return new JifParsedPolyType_c(this, init, fromSource);
        }
        return super.createClassType(init, fromSource);
    }

    public List<String> defaultPackageImports() {
        ArrayList<String> l = new ArrayList<String>(2);
        l.add("java.lang");
        l.add("jif.lang");
        return l;
    }

    public ClassFileLazyClassInitializer classFileLazyClassInitializer(ClassFile clazz) {
        throw new UnsupportedOperationException("Raw classfiles are not supported by Jif.");
    }

    @Override
    public LabeledType labeledType(Position pos, Type type, Label label) {
        if (this.isLabeled(type)) {
            throw new InternalCompilerError("Trying to label a labeled type");
        }
        return new LabeledType_c(this, pos, type, label);
    }

    @Override
    public PathMap pathMap() {
        return new PathMap(this);
    }

    @Override
    public PathMap pathMap(Path path, Label L) {
        PathMap m = this.pathMap();
        return m.set(path, L);
    }

    @Override
    public ExceptionPath exceptionPath(Type type) {
        return new ExceptionPath_c(this.unlabel(type));
    }

    @Override
    public Path gotoPath(Branch.Kind kind, String target) {
        return new GotoPath_c(kind, target);
    }

    @Override
    public Param unknownParam(Position pos) {
        return new UnknownParam_c(this, pos);
    }

    @Override
    public ClassType nullInstantiate(Position pos, PClass<ParamInstance, Param> pc) {
        if (pc.clazz() instanceof JifPolyType) {
            JifPolyType pt = (JifPolyType)pc.clazz();
            LinkedHashMap<ParamInstance, Param> subst = new LinkedHashMap<ParamInstance, Param>();
            Iterator<ParamInstance> i = pt.params().iterator();
            Iterator<Param> j = pt.actuals().iterator();
            while (i.hasNext() && j.hasNext()) {
                ParamInstance param = i.next();
                Param actual = j.next();
                subst.put(param, actual);
            }
            if (i.hasNext() || j.hasNext()) {
                throw new InternalCompilerError("Params and actuals had different lengths");
            }
            return (ClassType)this.subst((Type)pt, subst);
        }
        throw new InternalCompilerError("Cannot null instantiate \"" + pc + "\".");
    }

    public void checkInstantiation(Position pos, PClass<ParamInstance, Param> t, List<? extends Param> args) throws SemanticException {
        super.checkInstantiation(pos, t, args);
        Iterator<? extends Param> i = args.iterator();
        Iterator<ParamInstance> j = ((JifPolyType)t.clazz()).params().iterator();
        while (i.hasNext() && j.hasNext()) {
            Param p = i.next();
            ParamInstance pi = j.next();
            if (pi.isLabel() && !(p instanceof Label)) {
                throw new SemanticException("Cannot use " + p + " as a label.", p.position());
            }
            if (!pi.isPrincipal() || p instanceof Principal) continue;
            throw new SemanticException("Cannot use " + p + " as a principal.", p.position());
        }
    }

    public ClassType uncheckedInstantiate(Position pos, PClass<ParamInstance, Param> t, List<? extends Param> actuals) {
        return super.uncheckedInstantiate(pos, t, actuals);
    }

    protected Subst<ParamInstance, Param> substImpl(Map<ParamInstance, ? extends Param> substMap) {
        return new JifSubst_c(this, substMap);
    }

    @Override
    public ClassType fatalException() {
        return this.Error();
    }

    @Override
    public VarLabel freshLabelVariable(Position pos, String s, String description) {
        VarLabel_c t = new VarLabel_c(s, description, this, pos);
        return t;
    }

    @Override
    public VarPrincipal freshPrincipalVariable(Position pos, String s, String description) {
        VarPrincipal_c t = new VarPrincipal_c(s, description, this, pos);
        return t;
    }

    @Override
    public ParamPrincipal principalParam(Position pos, ParamInstance pi) {
        ParamPrincipal_c t = new ParamPrincipal_c(pi, this, pos);
        return t;
    }

    @Override
    public DynamicPrincipal dynamicPrincipal(Position pos, AccessPath path) {
        DynamicPrincipal_c t = new DynamicPrincipal_c(path, this, pos, this.dynamicPrincipalTranslator());
        return t;
    }

    protected PrincipalToJavaExpr dynamicPrincipalTranslator() {
        return new DynamicPrincipalToJavaExpr_c();
    }

    @Override
    public Principal pathToPrincipal(Position pos, AccessPath path) {
        if (path instanceof AccessPathConstant) {
            AccessPathConstant apc = (AccessPathConstant)path;
            if (!apc.isPrincipalConstant()) {
                throw new InternalCompilerError("Dynamic principal with a constant access path: " + apc);
            }
            return (Principal)apc.constantValue();
        }
        DynamicPrincipal_c t = new DynamicPrincipal_c(path, this, pos, this.dynamicPrincipalTranslator());
        return t;
    }

    @Override
    public ExternalPrincipal externalPrincipal(Position pos, String name) {
        ExternalPrincipal_c t = new ExternalPrincipal_c(name, this, pos);
        return t;
    }

    @Override
    public UnknownPrincipal unknownPrincipal(Position pos) {
        UnknownPrincipal_c t = new UnknownPrincipal_c(this, pos);
        return t;
    }

    @Override
    public TopPrincipal topPrincipal(Position pos) {
        return new TopPrincipal_c(this, pos);
    }

    @Override
    public BottomPrincipal bottomPrincipal(Position pos) {
        return new BottomPrincipal_c(this, pos);
    }

    @Override
    public Principal conjunctivePrincipal(Position pos, Principal l, Principal r) {
        return this.conjunctivePrincipal(pos, Arrays.asList(l, r));
    }

    @Override
    public Principal conjunctivePrincipal(Position pos, Collection<Principal> ps) {
        if (ps.isEmpty()) {
            return this.bottomPrincipal(pos);
        }
        if ((ps = this.flattenConjuncts(ps)).size() == 1) {
            return ps.iterator().next();
        }
        return new ConjunctivePrincipal_c(ps, this, pos, this.conjunctivePrincipalTranslator());
    }

    @Override
    public PrincipalToJavaExpr conjunctivePrincipalTranslator() {
        return new ConjunctivePrincipalToJavaExpr_c();
    }

    @Override
    public Principal disjunctivePrincipal(Position pos, Principal l, Principal r) {
        return this.disjunctivePrincipal(pos, Arrays.asList(l, r));
    }

    @Override
    public Principal disjunctivePrincipal(Position pos, Collection<Principal> ps) {
        if (ps.isEmpty()) {
            return this.topPrincipal(pos);
        }
        if ((ps = this.flattenDisjuncts(ps)).size() == 1) {
            return ps.iterator().next();
        }
        return new DisjunctivePrincipal_c(ps, this, pos, this.disjunctivePrincipalTranslator());
    }

    @Override
    public PrincipalToJavaExpr disjunctivePrincipalTranslator() {
        return new DisjunctivePrincipalToJavaExpr_c();
    }

    @Override
    public LabelToJavaExpr paramLabelTranslator() {
        return new ParamToJavaExpr_c();
    }

    @Override
    public PrincipalToJavaExpr paramPrincipalTranslator() {
        return new ParamToJavaExpr_c();
    }

    private Collection<Principal> flattenConjuncts(Collection<Principal> ps) {
        LinkedHashSet<Principal> newps = new LinkedHashSet<Principal>();
        for (Principal p : ps) {
            if (p instanceof ConjunctivePrincipal) {
                ConjunctivePrincipal cp = (ConjunctivePrincipal)p;
                newps.addAll(cp.conjuncts());
                continue;
            }
            newps.add(p);
        }
        LinkedHashSet<Principal> needed = new LinkedHashSet<Principal>();
        for (Principal p : newps) {
            boolean essential = true;
            for (Principal q : needed) {
                if (!this.emptyLabelEnv.actsFor(q, p)) continue;
                essential = false;
                break;
            }
            if (!essential) continue;
            needed.add(p);
        }
        return needed;
    }

    private Collection<Principal> flattenDisjuncts(Collection<Principal> ps) {
        LinkedHashSet<Principal> newps = new LinkedHashSet<Principal>();
        for (Principal p : ps) {
            if (p instanceof DisjunctivePrincipal) {
                DisjunctivePrincipal dp = (DisjunctivePrincipal)p;
                newps.addAll(dp.disjuncts());
                continue;
            }
            newps.add(p);
        }
        LinkedHashSet<Principal> needed = new LinkedHashSet<Principal>();
        for (Principal p : newps) {
            boolean essential = true;
            for (Principal q : needed) {
                if (!this.emptyLabelEnv.actsFor(p, q)) continue;
                essential = false;
                break;
            }
            if (!essential) continue;
            needed.add(p);
        }
        return needed;
    }

    @Override
    public Label topLabel(Position pos) {
        return this.pairLabel(pos, this.topConfPolicy(pos), this.topIntegPolicy(pos));
    }

    @Override
    public Label topLabel() {
        if (this.top == null) {
            this.top = this.topLabel(Position.COMPILER_GENERATED);
        }
        return this.top;
    }

    @Override
    public Label bottomLabel(Position pos) {
        return this.pairLabel(pos, this.bottomConfPolicy(pos), this.bottomIntegPolicy(pos));
    }

    @Override
    public Label bottomLabel() {
        if (this.bottom == null) {
            this.bottom = this.bottomLabel(Position.COMPILER_GENERATED);
        }
        return this.bottom;
    }

    @Override
    public ProviderLabel providerLabel(JifClassType ct) {
        return new ProviderLabel_c(ct, this.providerLabelTranslator());
    }

    @Override
    public ProviderLabel providerLabel(Position position, JifClassType ct) {
        return ct.provider().position(position);
    }

    protected LabelToJavaExpr providerLabelTranslator() {
        return new ProviderLabelToJavaExpr_c();
    }

    @Override
    public Label noComponentsLabel() {
        if (this.noComponents == null) {
            this.noComponents = this.noComponentsLabel(Position.COMPILER_GENERATED);
        }
        return this.noComponents;
    }

    @Override
    public Label noComponentsLabel(Position pos) {
        return this.pairLabel(pos, this.bottomConfPolicy(pos), this.topIntegPolicy(pos));
    }

    @Override
    public Label notTaken(Position pos) {
        NotTaken_c t = new NotTaken_c(this, pos);
        return t;
    }

    @Override
    public Label notTaken() {
        if (this.notTaken == null) {
            this.notTaken = this.notTaken(Position.COMPILER_GENERATED);
        }
        return this.notTaken;
    }

    @Override
    public CovariantParamLabel covariantLabel(Position pos, ParamInstance pi) {
        CovariantParamLabel_c t = new CovariantParamLabel_c(pi, this, pos);
        return t;
    }

    @Override
    public ParamLabel paramLabel(Position pos, ParamInstance pi) {
        ParamLabel_c t = new ParamLabel_c(pi, this, pos);
        return t;
    }

    @Override
    public ReaderPolicy readerPolicy(Position pos, Principal owner, Principal reader) {
        ReaderPolicy_c t = new ReaderPolicy_c(owner, reader, this, pos);
        return t;
    }

    @Override
    public ReaderPolicy readerPolicy(Position pos, Principal owner, Collection<Principal> readers) {
        Principal r = this.disjunctivePrincipal(pos, readers);
        return this.readerPolicy(pos, owner, r);
    }

    @Override
    public WriterPolicy writerPolicy(Position pos, Principal owner, Principal writer) {
        WriterPolicy_c t = new WriterPolicy_c(owner, writer, this, pos);
        return t;
    }

    @Override
    public WriterPolicy writerPolicy(Position pos, Principal owner, Collection<Principal> writers) {
        Principal w = this.disjunctivePrincipal(pos, writers);
        return this.writerPolicy(pos, owner, w);
    }

    @Override
    public ConfPolicy bottomConfPolicy(Position pos) {
        return this.readerPolicy(pos, (Principal)this.bottomPrincipal(pos), this.bottomPrincipal(pos));
    }

    @Override
    public IntegPolicy bottomIntegPolicy(Position pos) {
        return this.writerPolicy(pos, (Principal)this.topPrincipal(pos), this.topPrincipal(pos));
    }

    @Override
    public ConfPolicy topConfPolicy(Position pos) {
        return this.readerPolicy(pos, (Principal)this.topPrincipal(pos), this.topPrincipal(pos));
    }

    @Override
    public IntegPolicy topIntegPolicy(Position pos) {
        return this.writerPolicy(pos, (Principal)this.bottomPrincipal(pos), this.bottomPrincipal(pos));
    }

    @Override
    public Label joinLabel(Position pos, Set<Label> components) {
        if (components == null) {
            components = Collections.emptySet();
        }
        if (components.isEmpty()) {
            return this.bottomLabel(pos);
        }
        if (components.size() == 1) {
            return components.iterator().next();
        }
        JoinLabel_c t = new JoinLabel_c(components, this, pos, this.joinLabelTranslator());
        return t;
    }

    public LabelToJavaExpr joinLabelTranslator() {
        return new JoinLabelToJavaExpr_c();
    }

    @Override
    public Label meetLabel(Position pos, Set<Label> components) {
        if (components == null) {
            components = Collections.emptySet();
        }
        if (components.isEmpty()) {
            return this.topLabel(pos);
        }
        if (components.size() == 1) {
            return components.iterator().next();
        }
        MeetLabel_c t = new MeetLabel_c(components, this, pos, this.meetLabelTranslator());
        return t;
    }

    public LabelToJavaExpr meetLabelTranslator() {
        return new MeetLabelToJavaExpr_c();
    }

    @Override
    public DynamicLabel dynamicLabel(Position pos, AccessPath path) {
        DynamicLabel_c t = new DynamicLabel_c(path, this, pos, this.dynamicLabelTranslator());
        return t;
    }

    @Override
    public Label pathToLabel(Position pos, AccessPath path) {
        if (path instanceof AccessPathConstant) {
            AccessPathConstant apc = (AccessPathConstant)path;
            if (!apc.isLabelConstant()) {
                throw new InternalCompilerError("Dynamic label with a constant access path: " + apc);
            }
            return (Label)apc.constantValue();
        }
        DynamicLabel t = this.dynamicLabel(pos, path);
        return t;
    }

    protected LabelToJavaExpr dynamicLabelTranslator() {
        return new DynamicLabelToJavaExpr_c();
    }

    @Override
    public ArgLabel argLabel(Position pos, LocalInstance vi, CodeInstance ci) {
        ArgLabel_c t = new ArgLabel_c((JifTypeSystem)this, (VarInstance)vi, ci, pos);
        return t;
    }

    @Override
    public ArgLabel argLabel(Position pos, ParamInstance pi) {
        ArgLabel_c t = new ArgLabel_c((JifTypeSystem)this, pi, null, pos);
        return t;
    }

    @Override
    public Label callSitePCLabel(JifProcedureInstance pi) {
        ArgLabel_c pcLabel = new ArgLabel_c((JifTypeSystem)this, pi, "caller_pc", pi.position());
        pcLabel.setUpperBound(pi.pcBound());
        pcLabel.setDescription("The pc at the call site of this " + pi.designator() + " (bounded above by " + pi.pcBound() + ")");
        return pcLabel;
    }

    @Override
    public ThisLabel thisLabel(JifClassType ct) {
        return this.thisLabel(ct.position(), ct);
    }

    @Override
    public ThisLabel thisLabel(ArrayType at) {
        return this.thisLabel(at.position(), (ReferenceType)at);
    }

    @Override
    public ThisLabel thisLabel(Position pos, JifClassType ct) {
        return this.thisLabel(pos, (ReferenceType)ct);
    }

    public ThisLabel thisLabel(Position pos, ReferenceType ct) {
        return new ThisLabel_c((JifTypeSystem)this, ct, pos);
    }

    @Override
    public UnknownLabel unknownLabel(Position pos) {
        UnknownLabel_c t = new UnknownLabel_c(this, pos);
        return t;
    }

    @Override
    public PairLabel pairLabel(Position pos, ConfPolicy confPol, IntegPolicy integPol) {
        return new PairLabel_c(this, confPol, integPol, pos, this.pairLabelTranslator());
    }

    protected LabelToJavaExpr pairLabelTranslator() {
        return new PairLabelToJavaExpr_c();
    }

    @Override
    public WritersToReadersLabel writersToReadersLabel(Position pos, Label L) {
        WritersToReadersLabel_c t = new WritersToReadersLabel_c(L, this, pos);
        return t;
    }

    @Override
    public <Actor extends ActsForParam, Granter extends ActsForParam> ActsForConstraint<Actor, Granter> actsForConstraint(Position pos, Actor actor, Granter granter, boolean isEquiv) {
        return new ActsForConstraint_c<Actor, Granter>((TypeSystem)this, pos, actor, granter, isEquiv, this.actsForConstraintTranslator());
    }

    protected ActsForConstraintToJavaExpr actsForConstraintTranslator() {
        return new ActsForConstraintToJavaExpr_c();
    }

    @Override
    public LabelLeAssertion labelLeAssertion(Position pos, Label lhs, Label rhs) {
        return new LabelLeAssertion_c(this, lhs, rhs, pos, this.labelLeAssertionTranslator());
    }

    protected LabelLeAssertionToJavaExpr labelLeAssertionTranslator() {
        return new LabelLeAssertionToJavaExpr_c();
    }

    @Override
    public AuthConstraint authConstraint(Position pos, List<Principal> principals) {
        return new AuthConstraint_c(this, pos, principals);
    }

    @Override
    public AutoEndorseConstraint autoEndorseConstraint(Position pos, Label endorseTo) {
        return new AutoEndorseConstraint_c(this, pos, endorseTo);
    }

    @Override
    public CallerConstraint callerConstraint(Position pos, List<Principal> principals) {
        return new CallerConstraint_c(this, pos, principals);
    }

    @Override
    public Label labelOfField(FieldInstance vi, Label pc) {
        return ((JifFieldInstance)vi).label();
    }

    @Override
    public Label labelOfLocal(LocalInstance vi, Label pc) {
        return ((JifLocalInstance)vi).label();
    }

    @Override
    public Label labelOfType(Type type) {
        return this.labelOfType(type, this.bottomLabel(type.position()));
    }

    @Override
    public Label labelOfType(Type type, Label defaultLabel) {
        if (type instanceof LabeledType) {
            return ((LabeledType)type).labelPart();
        }
        return defaultLabel;
    }

    protected Type strip(Type type) {
        if (type instanceof LabeledType) {
            return this.strip(((LabeledType)type).typePart());
        }
        if (type instanceof JifSubstType) {
            return this.strip(((JifSubstType)type).base());
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            return at.base(this.strip(at.base()));
        }
        return type;
    }

    @Override
    public Type unlabel(Type type) {
        if (type instanceof LabeledType) {
            return ((LabeledType)type).typePart();
        }
        return type;
    }

    @Override
    public boolean isLabel(Type type) {
        return this.equals((TypeObject)this.unlabel(type), (TypeObject)this.LABEL_);
    }

    @Override
    public boolean isPrincipal(Type type) {
        return this.equals((TypeObject)this.unlabel(type), (TypeObject)this.PRINCIPAL_);
    }

    @Override
    public boolean isLabeled(Type type) {
        return type instanceof LabeledType;
    }

    @Override
    public boolean isSignature(Type type) {
        FieldInstance fi;
        ClassType ct = type.toClass();
        return ct != null && (fi = ct.fieldNamed(JIF_SIG_OF_JAVA_MARKER)) != null && (fi.flags().isPrivate() || ct.flags().isInterface()) && fi.flags().isStatic();
    }

    @Override
    public boolean isMarkerFieldName(String s) {
        return JIF_SIG_OF_JAVA_MARKER.equals(s) || JIF_PARAMS_RUNTIME_MARKER.equals(s) || JIF_SAFE_CONSTRUCTOR_MARKER.equals(s);
    }

    @Override
    public boolean isParamsRuntimeRep(Type t) {
        FieldInstance fi;
        if (!this.isSignature(t)) {
            return true;
        }
        ClassType ct = t.toClass();
        return ct != null && (fi = ct.fieldNamed(JIF_PARAMS_RUNTIME_MARKER)) != null && fi.flags().isPrivate() && fi.flags().isStatic();
    }

    @Override
    public ClassType hasUntrustedAncestor(Type t) {
        if (t == null || t.toReference() == null) {
            return null;
        }
        Type st = t.toReference().superType();
        if (st == null || st.toClass() == null) {
            return null;
        }
        ClassType ct = st.toClass();
        if (!this.hasSafeConstructors(ct)) {
            return ct;
        }
        return this.hasUntrustedAncestor((Type)ct);
    }

    public boolean hasSafeConstructors(ClassType ct) {
        FieldInstance fi;
        if (!this.isSignature((Type)ct)) {
            return true;
        }
        return ct != null && (fi = ct.fieldNamed(JIF_SAFE_CONSTRUCTOR_MARKER)) != null && fi.flags().isPrivate() && fi.flags().isStatic();
    }

    public boolean canCoerceToString(Type t, Context c) {
        return this.equalsStrip((TypeObject)t, (TypeObject)this.String()) || t.isPrimitive() && !this.isPrincipal(t) && !this.isLabel(t);
    }

    @Override
    public Label join(Label L1, Label L2) {
        if (L1 instanceof NotTaken) {
            return L2.simplify();
        }
        if (L2 instanceof NotTaken) {
            return L1.simplify();
        }
        if (L1.isTop() || L2.isBottom()) {
            return L1.simplify();
        }
        if (L2.isTop() || L1.isBottom()) {
            return L2.simplify();
        }
        LinkedHashSet<Label> s = new LinkedHashSet<Label>();
        s.add(L1);
        s.add(L2);
        Position pos = L1.position();
        if (pos == null) {
            pos = L2.position();
        }
        return this.joinLabel(pos, s).simplify();
    }

    @Override
    public Label meet(Label L1, Label L2) {
        if (L1.isTop() || L2.isBottom()) {
            return L2.simplify();
        }
        if (L2.isTop() || L1.isBottom()) {
            return L1.simplify();
        }
        LinkedHashSet<Label> s = new LinkedHashSet<Label>();
        s.add(L1);
        s.add(L2);
        Position pos = L1.position();
        if (pos == null) {
            pos = L2.position();
        }
        return this.meetLabel(pos, s).simplify();
    }

    @Override
    public boolean actsFor(Principal p, Principal q) {
        return this.emptyLabelEnv.actsFor(p, q);
    }

    @Override
    public boolean leq(Label L1, Label L2) {
        return this.emptyLabelEnv.leq(L1, L2);
    }

    @Override
    public boolean leq(Policy p1, Policy p2) {
        return this.emptyLabelEnv.leq(p1, p2);
    }

    @Override
    public ConfPolicy joinConfPolicy(Position pos, Set<ConfPolicy> components) {
        if (components.isEmpty()) {
            return this.bottomConfPolicy(pos);
        }
        if (components.size() == 1) {
            return components.iterator().next();
        }
        return (ConfPolicy)new JoinConfPolicy_c(components, (JifTypeSystem)this, pos).simplify();
    }

    @Override
    public IntegPolicy joinIntegPolicy(Position pos, Set<IntegPolicy> components) {
        if (components.isEmpty()) {
            return this.bottomIntegPolicy(pos);
        }
        if (components.size() == 1) {
            return components.iterator().next();
        }
        return (IntegPolicy)new JoinIntegPolicy_c(components, (JifTypeSystem)this, pos).simplify();
    }

    @Override
    public ConfPolicy meetConfPolicy(Position pos, Set<ConfPolicy> components) {
        if (components.isEmpty()) {
            return this.topConfPolicy(pos);
        }
        if (components.size() == 1) {
            return components.iterator().next();
        }
        return (ConfPolicy)new MeetConfPolicy_c(components, (JifTypeSystem)this, pos).simplify();
    }

    @Override
    public IntegPolicy meetIntegPolicy(Position pos, Set<IntegPolicy> components) {
        if (components.isEmpty()) {
            return this.topIntegPolicy(pos);
        }
        if (components.size() == 1) {
            return components.iterator().next();
        }
        return (IntegPolicy)new MeetIntegPolicy_c(components, (JifTypeSystem)this, pos).simplify();
    }

    @Override
    public ConfPolicy join(ConfPolicy p1, ConfPolicy p2) {
        if (p1.isTop() || p2.isBottom()) {
            return (ConfPolicy)p1.simplify();
        }
        if (p2.isTop() || p1.isBottom()) {
            return (ConfPolicy)p2.simplify();
        }
        HashSet<ConfPolicy> s = new HashSet<ConfPolicy>();
        s.add(p1);
        s.add(p2);
        Position pos = p1.position();
        if (pos == null) {
            pos = p2.position();
        }
        return (ConfPolicy)this.joinConfPolicy(pos, s).simplify();
    }

    @Override
    public IntegPolicy join(IntegPolicy p1, IntegPolicy p2) {
        if (p1.isTop() || p2.isBottom()) {
            return (IntegPolicy)p1.simplify();
        }
        if (p2.isTop() || p1.isBottom()) {
            return (IntegPolicy)p2.simplify();
        }
        HashSet<IntegPolicy> s = new HashSet<IntegPolicy>();
        s.add(p1);
        s.add(p2);
        Position pos = p1.position();
        if (pos == null) {
            pos = p2.position();
        }
        return (IntegPolicy)this.joinIntegPolicy(pos, s).simplify();
    }

    @Override
    public ConfPolicy meet(ConfPolicy p1, ConfPolicy p2) {
        if (p1.isTop() || p2.isBottom()) {
            return (ConfPolicy)p2.simplify();
        }
        if (p2.isTop() || p1.isBottom()) {
            return (ConfPolicy)p1.simplify();
        }
        HashSet<ConfPolicy> s = new HashSet<ConfPolicy>();
        s.add(p1);
        s.add(p2);
        Position pos = p1.position();
        if (pos == null) {
            pos = p2.position();
        }
        return (ConfPolicy)this.meetConfPolicy(pos, s).simplify();
    }

    @Override
    public IntegPolicy meet(IntegPolicy p1, IntegPolicy p2) {
        if (p1.isTop() || p2.isBottom()) {
            return (IntegPolicy)p2.simplify();
        }
        if (p2.isTop() || p1.isBottom()) {
            return (IntegPolicy)p1.simplify();
        }
        HashSet<IntegPolicy> s = new HashSet<IntegPolicy>();
        s.add(p1);
        s.add(p2);
        Position pos = p1.position();
        if (pos == null) {
            pos = p2.position();
        }
        return (IntegPolicy)this.meetIntegPolicy(pos, s).simplify();
    }

    @Override
    public ConfPolicy confProjection(Label L) {
        if (L instanceof MeetLabel || L instanceof JoinLabel || L instanceof PairLabel) {
            return L.confProjection();
        }
        return new ConfProjectionPolicy_c(L, this, L.position());
    }

    @Override
    public IntegPolicy integProjection(Label L) {
        if (L instanceof MeetLabel || L instanceof JoinLabel || L instanceof PairLabel) {
            return L.integProjection();
        }
        return new IntegProjectionPolicy_c(L, this, L.position());
    }

    public String translateClass(Resolver c, ClassType t) {
        if (t.package_() != null && (t.package_().equals(this.createPackage("jif.lang")) || t.package_().equals(this.createPackage("jif.principals")))) {
            return super.translateClass(null, t);
        }
        return super.translateClass(c, t);
    }

    public String translatePrimitive(Resolver c, PrimitiveType t) {
        if (this.isLabel((Type)t)) {
            return this.LabelClassName();
        }
        if (this.isPrincipal((Type)t)) {
            return this.PrincipalClassName();
        }
        return super.translatePrimitive(c, t);
    }

    @Override
    public List<ReferenceType> abstractSuperInterfaces(ReferenceType rt) {
        return super.abstractSuperInterfaces(rt);
    }

    @Override
    public boolean isAccessible(MemberInstance mi, ClassType contextClass) {
        return super.isAccessible(mi, contextClass);
    }

    public PrimitiveType primitiveForName(String name) throws SemanticException {
        if (name.equals("label")) {
            return this.Label();
        }
        if (name.equals("principal")) {
            return this.Principal();
        }
        return super.primitiveForName(name);
    }

    public Collection<Type> uncheckedExceptions() {
        return Collections.singletonList(this.Error());
    }

    @Override
    public DefaultSignature defaultSignature() {
        return this.ds;
    }

    public ConstructorInstance defaultConstructor(Position pos, ClassType container) {
        this.assert_((TypeObject)container);
        return this.jifConstructorInstance(pos, container, this.Public(), this.topLabel(), true, this.bottomLabel(), true, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public LabelTypeCheckUtil labelTypeCheckUtil() {
        if (this.ltcu == null) {
            this.ltcu = new LabelTypeCheckUtil(this);
        }
        return this.ltcu;
    }

    @Override
    public boolean promoteToFatal(Type t) {
        return ((JifOptions)this.extInfo.getOptions()).fatalExceptions && this.descendsFrom(t, (Type)this.RuntimeException());
    }

    @Override
    public Label toLabel(Principal p) {
        ConfPolicy toConf = this.topConfPolicy(Position.compilerGenerated((int)2));
        WriterPolicy toInteg = this.writerPolicy(Position.compilerGenerated((int)2), p, p);
        return this.pairLabel(p.position(), toConf, toInteg);
    }

    @Override
    public AccessPath exprToAccessPath(Expr e, JifContext context) throws SemanticException {
        Type expectedType = null;
        if (e != null && e.type() != null && !e.type().isNull()) {
            expectedType = e.type();
        }
        return this.exprToAccessPath(e, expectedType, context);
    }

    @Override
    public AccessPath exprToAccessPath(Expr e, Type expectedType, JifContext context) throws SemanticException {
        if (e instanceof Local) {
            Local l = (Local)e;
            return new AccessPathLocal(l.localInstance(), l.name(), e.position());
        }
        if (e instanceof Field) {
            Field f = (Field)e;
            Receiver target = f.target();
            if (target instanceof Expr) {
                AccessPath prefix = this.exprToAccessPath((Expr)f.target(), null, context);
                return this.accessPathField(prefix, f.fieldInstance(), f.name(), f.position());
            }
            if (target instanceof TypeNode && ((TypeNode)target).type().isClass()) {
                AccessPathClass prefix = new AccessPathClass(((TypeNode)target).type().toClass(), target.position());
                return this.accessPathField(prefix, f.fieldInstance(), f.name(), f.position());
            }
            throw new InternalCompilerError("Not currently supporting access paths for targets of " + target.getClass());
        }
        if (e instanceof Special) {
            Special s = (Special)e;
            if (Special.THIS.equals((Object)s.kind())) {
                if (context.currentClass() == null || context.inStaticContext()) {
                    throw new SemanticException("Cannot use \"this\" in this scope.", e.position());
                }
                return new AccessPathThis(context.currentClass(), s.position());
            }
            throw new InternalCompilerError("Not currently supporting access paths for special of kind " + s.kind());
        }
        if (e instanceof LabelExpr) {
            LabelExpr le = (LabelExpr)e;
            return new AccessPathConstant(le.label().label(), le.type(), le.position());
        }
        if (e instanceof PrincipalNode) {
            PrincipalNode pn = (PrincipalNode)e;
            return new AccessPathConstant(pn.principal(), pn.type(), pn.position());
        }
        if (e instanceof NullLit && expectedType != null && this.isImplicitCastValid(expectedType, (Type)this.Principal())) {
            BottomPrincipal bot = this.bottomPrincipal(e.position());
            return new AccessPathConstant(bot, (Type)this.Principal(), e.position());
        }
        if (e instanceof Cast) {
            return this.exprToAccessPath(((Cast)e).expr(), expectedType, context);
        }
        if (e instanceof DowngradeExpr) {
            return this.exprToAccessPath(((DowngradeExpr)e).expr(), expectedType, context);
        }
        throw new SemanticDetailedException("Expression " + e + " not suitable for an access path.", "The expression " + e + " is not suitable for a final access " + "path. A final access path is an expression starting with either " + "\"this\" or a final local variable \"v\", followed by zero or more final field accesses. That is, " + "a final access path is either this.f1.f2....fn, or v.f1.f2.....fn, where v is a " + "final local variables, and each field f1 to fn is a final field.", e.position());
    }

    @Override
    public String accessPathDescrip(AccessPath path, String kind) {
        if (path.isUninterpreted()) {
            return "an uninterpreted dynamic " + kind;
        }
        return "dynamic " + kind + " represented by the final access path " + path;
    }

    @Override
    public Principal exprToPrincipal(JifTypeSystem ts, Expr e, JifContext context) throws SemanticException {
        if (e instanceof PrincipalNode) {
            return ((PrincipalNode)e).principal();
        }
        if (e instanceof PrincipalExpr) {
            return ((PrincipalExpr)e).principal().principal();
        }
        if (e instanceof Cast) {
            return this.exprToPrincipal(ts, ((Cast)e).expr(), context);
        }
        if (e instanceof DowngradeExpr) {
            return this.exprToPrincipal(ts, ((DowngradeExpr)e).expr(), context);
        }
        if (e instanceof NullLit) {
            return ts.bottomPrincipal(e.position());
        }
        if (this.isFinalAccessExpr(e)) {
            return ts.dynamicPrincipal(e.position(), ts.exprToAccessPath(e, (Type)ts.Principal(), context));
        }
        throw new InternalCompilerError("Expected a final access expression, or constant");
    }

    @Override
    public Label exprToLabel(JifTypeSystem ts, Expr e, JifContext context) throws SemanticException {
        if (e instanceof LabelExpr) {
            return ((LabelExpr)e).label().label();
        }
        if (e instanceof DowngradeExpr) {
            return this.exprToLabel(ts, ((DowngradeExpr)e).expr(), context);
        }
        if (this.isFinalAccessExpr(e)) {
            return ts.dynamicLabel(e.position(), ts.exprToAccessPath(e, (Type)ts.Label(), context));
        }
        throw new InternalCompilerError("Expected a final access expression, or constant");
    }

    @Override
    public boolean isFinalAccessExpr(Expr e) {
        if (e instanceof Local) {
            Local l = (Local)e;
            if (l.type() != null && l.type().isCanonical()) {
                return l.localInstance().flags().isFinal();
            }
            return true;
        }
        if (e instanceof Field) {
            Field f = (Field)e;
            if (f.type() != null && f.type().isCanonical()) {
                Flags flgs = f.flags();
                return flgs.isFinal() && (flgs.isStatic() || f.target() instanceof Expr && this.isFinalAccessExpr((Expr)f.target()));
            }
            return true;
        }
        if (e instanceof Special) {
            return ((Special)e).kind() == Special.THIS;
        }
        if (e instanceof Cast) {
            return this.isFinalAccessExpr(((Cast)e).expr());
        }
        if (e instanceof DowngradeExpr) {
            return this.isFinalAccessExpr(((DowngradeExpr)e).expr());
        }
        return false;
    }

    @Override
    public boolean isFinalAccessExprOrConst(Expr e, Type expectedType) {
        return this.isFinalAccessExpr(e) || e instanceof LabelExpr || e instanceof PrincipalNode || e instanceof PrincipalExpr || e instanceof Cast && this.isFinalAccessExprOrConst(((Cast)e).expr()) || e instanceof DowngradeExpr && this.isFinalAccessExprOrConst(((DowngradeExpr)e).expr()) || e instanceof NullLit && expectedType != null && this.isImplicitCastValid(expectedType, (Type)this.Principal());
    }

    @Override
    public boolean isFinalAccessExprOrConst(Expr e) {
        Type expectedType = null;
        if (e != null && e.type() != null && !e.type().isNull()) {
            expectedType = e.type();
        }
        return this.isFinalAccessExprOrConst(e, expectedType);
    }

    @Override
    public void processFAP(VarInstance fi, AccessPath path, JifContext A) throws SemanticException {
        HashSet<ClassType> visited = new HashSet<ClassType>();
        this.processFAP(fi, path, A, visited);
    }

    protected void processFAP(VarInstance fi, AccessPath path, JifContext A, Set<ClassType> visited) throws SemanticException {
        if (fi.flags().isFinal()) {
            ReferenceType rt = fi.type().toReference();
            this.processFAP(rt, path, A, visited);
        }
    }

    @Override
    public void processFAP(ReferenceType rt, AccessPath path, JifContext A) throws SemanticException {
        HashSet<ClassType> visited = new HashSet<ClassType>();
        this.processFAP(rt, path, A, visited);
    }

    protected void processFAP(ReferenceType rt, AccessPath path, JifContext A, Set<ClassType> visited) throws SemanticException {
        if (!(rt instanceof ClassType)) {
            return;
        }
        JifClassType ct = (JifClassType)rt;
        if (visited.contains(ct)) {
            return;
        }
        visited.add(ct);
        if (ct == null || ct.fields() == null) {
            return;
        }
        for (FieldInstance fieldInstance : ct.fields()) {
            JifFieldInstance jfi = (JifFieldInstance)fieldInstance;
            if (!jfi.flags().isFinal()) continue;
            AccessPathField path2 = this.accessPathField(path, jfi, jfi.name(), jfi.position());
            Param init2 = jfi.initializer();
            if (jfi.hasInitializer()) {
                if (this.isLabel(jfi.type())) {
                    DynamicLabel dl = this.dynamicLabel(jfi.position(), path2);
                    Label rhs_label = (Label)init2;
                    if (rhs_label == null) {
                        throw new InternalCompilerError("FinalParams has not run yet");
                    }
                    A.addDefinitionalAssertionEquiv(dl, rhs_label, true);
                    continue;
                }
                if (this.isImplicitCastValid(jfi.type(), (Type)this.Principal())) {
                    DynamicPrincipal dp = this.dynamicPrincipal(jfi.position(), path2);
                    Principal rhs_principal = (Principal)init2;
                    if (rhs_principal == null) {
                        throw new InternalCompilerError("FinalParams has not run yet");
                    }
                    A.addDefinitionalEquiv(dp, rhs_principal);
                    continue;
                }
                jfi.setInitializer(null);
            }
            this.processFAP(jfi, (AccessPath)path2, A, visited);
        }
    }

    @Override
    public AccessPath varInstanceToAccessPath(VarInstance vi, String name, Position pos) throws SemanticException {
        if (!vi.flags().isFinal()) {
            throw new SemanticException("Only final fields and final local variables may be used as access paths.", pos);
        }
        if (vi instanceof LocalInstance) {
            return new AccessPathLocal((LocalInstance)vi, name, pos);
        }
        if (vi instanceof FieldInstance) {
            FieldInstance fi = (FieldInstance)vi;
            AccessPathRoot root = fi.flags().isStatic() ? new AccessPathClass(fi.container().toClass(), pos) : new AccessPathThis(fi.container().toClass(), pos);
            return this.accessPathField(root, fi, name, pos);
        }
        throw new InternalCompilerError("Unexpected var instance " + vi.getClass());
    }

    @Override
    public AccessPath varInstanceToAccessPath(VarInstance vi, Position pos) throws SemanticException {
        return this.varInstanceToAccessPath(vi, vi.name(), pos);
    }

    @Override
    public boolean needsDynamicTypeMethods(Type ct) {
        boolean hasParams = ct instanceof JifSubstType && !((JifSubstType)ct).actuals().isEmpty() || ct instanceof JifPolyType && !((JifPolyType)ct).params().isEmpty();
        return this.isParamsRuntimeRep(ct) && hasParams;
    }

    @Override
    public boolean needsImplClass(Type jpt) {
        return this.isParamsRuntimeRep(jpt);
    }

    protected AccessPathField accessPathField(AccessPath path, FieldInstance fi, String fieldName, Position pos) {
        return new AccessPathField(path, fi, fieldName, pos);
    }
}

