/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jif.JifOptions;
import jif.types.Assertion;
import jif.types.JifParsedPolyType;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.label.ParamLabel;
import jif.types.label.ProviderLabel;
import jif.types.label.ThisLabel;
import jif.types.principal.ParamPrincipal;
import jif.types.principal.Principal;
import polyglot.ext.param.types.PClass;
import polyglot.frontend.Source;
import polyglot.main.Options;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.ParsedClassType_c;
import polyglot.types.TypeSystem;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class JifParsedPolyType_c
extends ParsedClassType_c
implements JifParsedPolyType {
    private static final long serialVersionUID = SerialVersionUID.generate();
    List<ParamInstance> params = new LinkedList<ParamInstance>();
    List<Principal> authority = new LinkedList<Principal>();
    List<Assertion> constraints = new LinkedList<Assertion>();
    ProviderLabel provider;
    boolean isUnsafe;
    PClass<ParamInstance, Param> instantiatedFrom;

    protected JifParsedPolyType_c() {
        this.provider = null;
        this.instantiatedFrom = null;
    }

    public JifParsedPolyType_c(JifTypeSystem ts, LazyClassInitializer init, Source fromSource) {
        super((TypeSystem)ts, init, fromSource);
        this.provider = ts.providerLabel(this);
        this.isUnsafe = ((JifOptions)Options.global).skipLabelChecking;
        this.instantiatedFrom = null;
    }

    @Override
    public JifTypeSystem typeSystem() {
        return (JifTypeSystem)super.typeSystem();
    }

    public PClass<ParamInstance, Param> instantiatedFrom() {
        return this.instantiatedFrom;
    }

    @Override
    public void setInstantiatedFrom(PClass<ParamInstance, Param> pc) {
        this.instantiatedFrom = pc;
    }

    public void kind(ClassType.Kind kind) {
        super.kind(kind);
    }

    public List<? extends FieldInstance> fields() {
        if (this.fields == null) {
            super.fields();
            Iterator i = this.fields.iterator();
            while (i.hasNext()) {
                FieldInstance fi = (FieldInstance)i.next();
                if (!fi.name().equals("class")) continue;
                i.remove();
                break;
            }
        }
        return this.fields;
    }

    @Override
    public List<Principal> authority() {
        return this.authority;
    }

    @Override
    public List<Principal> constructorCallAuthority() {
        ArrayList<Principal> l = new ArrayList<Principal>(this.authority.size());
        for (Principal p : this.authority) {
            if (!(p instanceof ParamPrincipal)) continue;
            l.add(p);
        }
        return l;
    }

    @Override
    public List<ParamInstance> params() {
        return this.params;
    }

    @Override
    public List<Param> actuals() {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        ArrayList<Param> actuals = new ArrayList<Param>(this.params.size());
        for (ParamInstance pi : this.params) {
            Position posi = pi.position();
            if (pi.isCovariantLabel()) {
                actuals.add(ts.covariantLabel(posi, pi));
                continue;
            }
            if (pi.isLabel()) {
                ParamLabel pl = ts.paramLabel(posi, pi);
                pl.setDescription("label parameter " + pi.name() + " of class " + pi.container().fullName());
                actuals.add(pl);
                continue;
            }
            actuals.add(ts.principalParam(posi, pi));
        }
        return actuals;
    }

    @Override
    public ThisLabel thisLabel() {
        return ((JifTypeSystem)this.ts).thisLabel(this);
    }

    @Override
    public ThisLabel thisLabel(Position p) {
        return ((JifTypeSystem)this.ts).thisLabel(p, this);
    }

    @Override
    public void setParams(List<ParamInstance> params) {
        this.params = new LinkedList<ParamInstance>(params);
    }

    @Override
    public void setAuthority(List<Principal> principals) {
        this.authority = new LinkedList<Principal>(principals);
    }

    @Override
    public List<Assertion> constraints() {
        return this.constraints;
    }

    @Override
    public void setConstraints(List<Assertion> constraints) {
        this.constraints = ListUtil.copy(constraints, (boolean)true);
    }

    public String toString() {
        if (this.kind() == null) {
            return "<unknown class " + this.name + ">";
        }
        String s = "";
        if (this.params != null) {
            Iterator<ParamInstance> i = this.params.iterator();
            while (i.hasNext()) {
                ParamInstance pi = i.next();
                s = s + pi.toString();
                if (!i.hasNext()) continue;
                s = s + ", ";
            }
        }
        if (!s.equals("")) {
            s = "[" + s + "]";
        }
        if (this.package_() != null) {
            return this.package_().toString() + "." + this.name + s;
        }
        return this.name + s;
    }

    @Override
    public ProviderLabel provider() {
        return this.provider;
    }

    @Override
    public boolean isUnsafe() {
        return this.isUnsafe;
    }
}

