/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jif.JifOptions;
import jif.types.ActsForParam;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.hierarchy.LabelEnv_c;
import jif.types.hierarchy.PrincipalHierarchy;
import jif.types.label.AccessPath;
import jif.types.label.Label;
import jif.types.label.NotTaken;
import jif.types.label.PairLabel;
import jif.types.label.ProviderLabel;
import jif.types.label.WritersToReadersLabel;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.ast.Branch;
import polyglot.ast.Expr;
import polyglot.ast.Local;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.Context_c;
import polyglot.types.LocalInstance;
import polyglot.types.Named;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JifContext_c
extends Context_c
implements JifContext {
    protected final TypeSystem jlts;
    protected final JifTypeSystem jifts;
    private LabelEnv_c env;
    private Set<Principal> auth;
    private Label pc;
    private Label currentCodePCBound;
    protected Map<LocalInstance, Label> checkedEndorsements;
    protected Map<Key, Label> gotos;
    protected boolean checkingInits;
    protected boolean inConstructorCall;
    protected boolean inPrologue = false;
    protected Label constructorReturnLabel;
    protected ProviderLabel provider;

    protected JifContext_c(JifTypeSystem ts, TypeSystem jlts) {
        super((TypeSystem)ts);
        this.jlts = jlts;
        this.jifts = ts;
        this.env = (LabelEnv_c)ts.createLabelEnv();
    }

    public JifContext_c copy() {
        JifContext_c ctxt = (JifContext_c)super.copy();
        if (this.auth != null) {
            ctxt.auth = new LinkedHashSet<Principal>(this.auth);
        }
        if (this.gotos != null) {
            ctxt.gotos = new HashMap<Key, Label>(this.gotos);
        }
        ctxt.provider = this.provider;
        return ctxt;
    }

    public VarInstance findVariableSilent(String name) {
        VarInstance vi = super.findVariableSilent(name);
        if (vi != null) {
            return vi;
        }
        return this.findStaticPrincipal(name);
    }

    protected VarInstance findStaticPrincipal(String name) {
        Type t;
        Named n;
        ClassType principal;
        try {
            principal = (ClassType)this.jlts.typeForName(this.jifts.PrincipalClassName());
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Cannot find " + this.jifts.PrincipalClassName() + " class.", (Throwable)e);
        }
        try {
            String className = "jif.principals." + name;
            n = this.jlts.loadedResolver().find(className);
        }
        catch (SemanticException e) {
            return null;
        }
        if (n instanceof Type && (t = (Type)n).isClass() && this.jlts.isSubtype((Type)t.toClass(), (Type)principal)) {
            return this.jifts.principalInstance(null, this.jifts.externalPrincipal(null, name));
        }
        return null;
    }

    @Override
    public LabelEnv labelEnv() {
        return this.env;
    }

    protected void envModification() {
        JifContext_c jifOuter = (JifContext_c)this.outer;
        if (jifOuter != null && jifOuter.env == this.env) {
            this.env = this.env.copy();
        }
    }

    @Override
    public void addAssertionLE(Label L1, Label L2) {
        this.envModification();
        this.env.addAssertionLE(L1, L2);
    }

    @Override
    public void addActsFor(Label L, Principal p) {
        this.addAssertionLE(L, this.jifts.toLabel(p));
    }

    @Override
    public void addDefinitionalAssertionEquiv(Label L1, Label L2) {
        this.addDefinitionalAssertionEquiv(L1, L2, false);
    }

    @Override
    public void addDefinitionalAssertionEquiv(Label L1, Label L2, boolean addToClass) {
        this.env.addEquiv(L1, L2);
        JifContext_c jc = this;
        LabelEnv_c lastEnvAddedTo = this.env;
        while (jc != null && (!jc.isCode() || addToClass)) {
            if ((jc = (JifContext_c)jc.pop()) == null || jc.scope != this.scope || jc.env == lastEnvAddedTo) continue;
            jc.env.addEquiv(L1, L2);
            lastEnvAddedTo = jc.env;
        }
    }

    @Override
    public void addDefinitionalAssertionEquiv(AccessPath p, AccessPath q) {
        this.env.addEquiv(p, q);
        JifContext_c jc = this;
        LabelEnv_c lastEnvAddedTo = this.env;
        while (!jc.isCode()) {
            if ((jc = (JifContext_c)jc.pop()) == null || jc.scope != this.scope || jc.env == lastEnvAddedTo) continue;
            jc.env.addEquiv(p, q);
            lastEnvAddedTo = jc.env;
        }
    }

    @Override
    public void addEquiv(Label L1, Label L2) {
        this.envModification();
        this.env.addEquiv(L1, L2);
    }

    @Override
    public void addEquiv(Principal p1, Principal p2) {
        this.envModification();
        this.env.addEquiv(p1, p2);
    }

    @Override
    public void addActsFor(Principal p1, Principal p2) {
        this.envModification();
        this.env.addActsFor(p1, p2);
    }

    @Override
    public void addActsFor(ActsForParam actor, Principal granter) {
        if (actor instanceof Label) {
            this.addActsFor((Label)actor, granter);
        } else if (actor instanceof Principal) {
            this.addActsFor((Principal)actor, granter);
        } else {
            throw new InternalCompilerError("Unexpected ActsForParam type: " + actor.getClass());
        }
    }

    @Override
    public void addEquiv(AccessPath p, AccessPath q) {
        boolean lastJCBlock;
        this.env.addEquiv(p, q);
        JifContext_c jc = this;
        LabelEnv_c lastEnvAddedTo = this.env;
        boolean bl = lastJCBlock = jc.kind == Context_c.BLOCK;
        while (!jc.isCode() && !lastJCBlock) {
            if ((jc = (JifContext_c)jc.pop()) != null && jc.scope == this.scope && jc.env != lastEnvAddedTo) {
                jc.env.addEquiv(p, q);
                lastEnvAddedTo = jc.env;
            }
            lastJCBlock = jc.kind == Context_c.BLOCK;
        }
    }

    @Override
    public void addDefinitionalEquiv(Principal p1, Principal p2) {
        this.addEquiv(p1, p2);
        JifContext_c jc = this;
        LabelEnv_c lastEnvAddedTo = this.env;
        while (!jc.isCode()) {
            if ((jc = (JifContext_c)jc.pop()) == null || jc.scope != this.scope || jc.env == lastEnvAddedTo) continue;
            jc.env.addEquiv(p1, p2);
            lastEnvAddedTo = jc.env;
        }
    }

    @Override
    public void clearPH() {
        this.envModification();
        this.env.ph().clear();
    }

    @Override
    public Label gotoLabel(Branch.Kind kind, String label) {
        if (this.gotos == null) {
            return null;
        }
        return this.gotos.get(new Key(kind, label));
    }

    @Override
    public void gotoLabel(Branch.Kind kind, String label, Label L) {
        if (this.gotos == null) {
            this.gotos = new HashMap<Key, Label>();
        }
        this.gotos.put(new Key(kind, label), L);
    }

    @Override
    public Label currentCodePCBound() {
        return this.currentCodePCBound;
    }

    @Override
    public void setCurrentCodePCBound(Label currentCodePCBound) {
        this.currentCodePCBound = currentCodePCBound;
    }

    @Override
    public Label pc() {
        return this.pc;
    }

    @Override
    public void setPc(Label pc, LabelChecker lc) {
        if (pc instanceof NotTaken) {
            this.pc = pc;
        }
        if (this.pc == pc) {
            return;
        }
        if (pc != null) {
            HashSet<Label> set = new HashSet<Label>();
            set.add(pc);
            this.pc = lc.jifTypeSystem().joinLabel(pc.position(), set);
            this.pc.setDescription("pc label");
        } else {
            this.pc = pc;
        }
    }

    @Override
    public Set<Principal> authority() {
        return this.auth;
    }

    @Override
    public void setAuthority(Set<Principal> auth) {
        this.auth = auth;
    }

    @Override
    public PrincipalHierarchy ph() {
        return this.env.ph();
    }

    @Override
    public Label authLabel() {
        JifOptions opt = (JifOptions)this.jifts.extensionInfo().getOptions();
        if (opt.authFromProvider()) {
            Position pos = Position.compilerGenerated();
            PairLabel public_untrusted = this.jifts.pairLabel(pos, this.jifts.bottomConfPolicy(pos), this.jifts.topIntegPolicy(pos));
            Label provider_integ = this.jifts.meet(public_untrusted, this.provider());
            WritersToReadersLabel L = this.jifts.writersToReadersLabel(pos, provider_integ);
            return this.env.triggerTransforms(L).normalize();
        }
        Set<Principal> auth = this.authority();
        LinkedHashSet<Label> labels = new LinkedHashSet<Label>();
        for (Principal p : auth) {
            PairLabel pl = this.jifts.pairLabel(p.position(), this.jifts.readerPolicy(p.position(), p, this.jifts.topPrincipal(p.position())), this.jifts.topIntegPolicy(p.position()));
            labels.add(pl);
        }
        if (labels.isEmpty()) {
            return this.jifts.bottomLabel(this.currentCode().position());
        }
        Label L = this.jifts.joinLabel(this.currentCode().position(), labels);
        return L;
    }

    @Override
    public Label authLabelInteg() {
        JifOptions opt = (JifOptions)this.jifts.extensionInfo().getOptions();
        if (opt.authFromProvider()) {
            Position pos = Position.compilerGenerated();
            return this.jifts.pairLabel(pos, this.jifts.bottomConfPolicy(pos), this.provider().integProjection());
        }
        LinkedHashSet<Label> labels = new LinkedHashSet<Label>();
        for (Principal p : this.authority()) {
            PairLabel pl = this.jifts.pairLabel(p.position(), this.jifts.bottomConfPolicy(p.position()), this.jifts.writerPolicy(p.position(), p, this.jifts.topPrincipal(p.position())));
            labels.add(pl);
        }
        if (labels.isEmpty()) {
            return this.jifts.topLabel(this.currentCode().position());
        }
        Label L = this.jifts.meetLabel(this.currentCode().position(), labels);
        return L;
    }

    @Override
    public boolean checkingInits() {
        return this.checkingInits;
    }

    @Override
    public void setCheckingInits(boolean checkingInits) {
        this.checkingInits = checkingInits;
    }

    @Override
    public Label constructorReturnLabel() {
        return this.constructorReturnLabel;
    }

    @Override
    public void setConstructorReturnLabel(Label Lr) {
        this.constructorReturnLabel = Lr;
    }

    @Override
    public Context pushConstructorCall() {
        JifContext_c A = (JifContext_c)this.pushStatic();
        A.inConstructorCall = true;
        return A;
    }

    public Context pushClass(ParsedClassType classScope, ClassType type) {
        JifContext_c jc = (JifContext_c)super.pushClass(classScope, type);
        jc.envModification();
        return jc;
    }

    public Context pushCode(CodeInstance ci) {
        JifContext_c jc = (JifContext_c)super.pushCode(ci);
        jc.envModification();
        return jc;
    }

    @Override
    public boolean inConstructorCall() {
        return this.inConstructorCall;
    }

    @Override
    public PathMap pathMapForLocal(LocalInstance li, LabelChecker lc) {
        JifTypeSystem ts = lc.jifTypeSystem();
        Label L = null;
        L = this.checkedEndorsements != null && this.checkedEndorsements.containsKey(li) ? this.checkedEndorsements.get(li) : ts.labelOfLocal(li, this.pc());
        PathMap X = ts.pathMap();
        X = X.N(this.pc());
        X = X.NV(lc.upperBound(L, this.pc()));
        return X;
    }

    @Override
    public boolean updateAllowed(Expr e) {
        if (e instanceof Local && this.checkedEndorsements != null) {
            return !this.checkedEndorsements.containsKey(((Local)e).localInstance());
        }
        return true;
    }

    @Override
    public void addCheckedEndorse(LocalInstance li, Label downgradeTo) {
        this.checkedEndorsements = this.checkedEndorsements == null ? new HashMap<LocalInstance, Label>() : new HashMap<LocalInstance, Label>(this.checkedEndorsements);
        this.checkedEndorsements.put(li, downgradeTo);
    }

    @Override
    public ProviderLabel provider() {
        return this.provider;
    }

    @Override
    public void setProvider(ProviderLabel provider) {
        this.provider = provider;
    }

    @Override
    public Context pushPrologue() {
        JifContext_c v = this.copy();
        v.outer = this;
        v.kind = BLOCK;
        v.inPrologue = true;
        return v;
    }

    public boolean inPrologue() {
        return this.inPrologue;
    }

    protected static class Key {
        protected Branch.Kind kind;
        protected String label;

        public Key(Branch.Kind kind, String label) {
            this.kind = kind;
            this.label = label;
        }

        public int hashCode() {
            return this.kind.hashCode() + (this.label == null ? 0 : this.label.hashCode());
        }

        public String toString() {
            return this.kind.toString() + this.label;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key that = (Key)o;
                return this.kind.equals((Object)that.kind) && (this.label == that.label || this.label != null && this.label.equals(that.label));
            }
            return false;
        }
    }
}

