/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Graph {
    protected void addEdge(Node from, Node to, Edge edge) {
        from.outs.put(to, edge);
        to.ins.put(from, edge);
    }

    public Set<List<Node>> getBackwardPaths(Node start) {
        HashSet<List<Node>> ret = new HashSet<List<Node>>();
        ArrayList<Node> visited = new ArrayList<Node>();
        start.acceptBackward(new PathFinder(ret, true), visited);
        return ret;
    }

    public Set<List<Node>> getForwardPaths(Node start) {
        HashSet<List<Node>> ret = new HashSet<List<Node>>();
        ArrayList<Node> visited = new ArrayList<Node>();
        start.acceptForward(new PathFinder(ret, false), visited);
        return ret;
    }

    public void labelAll(Node root) {
        ArrayList<Node> visited = new ArrayList<Node>();
        root.acceptForward(new LabellingVisitor(), visited);
        root.shouldprint = false;
    }

    protected class LabellingVisitor
    implements NodeVisitor {
        protected LabellingVisitor() {
        }

        @Override
        public void discoverVertex(Node n) {
        }

        @Override
        public void leaveVertex(Node n) {
        }

        @Override
        public void visit(Node n) {
            n.shouldprint = true;
        }
    }

    protected class PathFinder
    implements NodeVisitor {
        ArrayList<Node> currentpath;
        Set<List<Node>> results;
        boolean isbackward;

        public PathFinder(Set<List<Node>> results, boolean isBackward) {
            this.results = results;
            this.currentpath = new ArrayList();
            this.isbackward = isBackward;
        }

        @Override
        public void discoverVertex(Node n) {
            if (this.isbackward) {
                this.currentpath.add(0, n);
            } else {
                this.currentpath.add(n);
            }
        }

        @Override
        public void leaveVertex(Node n) {
            if (this.isbackward) {
                this.currentpath.remove(0);
            } else {
                this.currentpath.remove(this.currentpath.size() - 1);
            }
        }

        @Override
        public void visit(Node n) {
            if (n.isend(this.isbackward)) {
                List clone = (List)this.currentpath.clone();
                this.results.add(clone);
            }
        }
    }

    public static interface NodeVisitor {
        public void discoverVertex(Node var1);

        public void visit(Node var1);

        public void leaveVertex(Node var1);
    }

    abstract class Node {
        Map<Node, Edge> ins = new HashMap<Node, Edge>();
        Map<Node, Edge> outs = new HashMap<Node, Edge>();
        boolean shouldprint = false;

        public void acceptForward(NodeVisitor v, List<Node> visited) {
            if (visited.contains(this)) {
                return;
            }
            v.discoverVertex(this);
            v.visit(this);
            visited.add(this);
            for (Node n : this.outs.keySet()) {
                n.acceptForward(v, visited);
            }
            v.leaveVertex(this);
        }

        public void acceptBackward(NodeVisitor v, List<Node> visited) {
            if (visited.contains(this)) {
                return;
            }
            v.discoverVertex(this);
            v.visit(this);
            visited.add(this);
            for (Node n : this.ins.keySet()) {
                n.acceptBackward(v, visited);
            }
            v.leaveVertex(this);
        }

        abstract boolean isend(boolean var1);
    }

    abstract class Edge {
        Edge() {
        }
    }
}

