/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import jif.ast.JifProcedureDecl;
import jif.types.DefaultSignature;
import jif.types.JifProcedureInstance;
import jif.types.JifTypeSystem;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.TypeNode;
import polyglot.types.Type;
import polyglot.util.Position;

public class FixedSignature
implements DefaultSignature {
    JifTypeSystem ts;

    public FixedSignature(JifTypeSystem ts) {
        this.ts = ts;
    }

    @Override
    public Label defaultPCBound(Position pos, String methodName) {
        Label ret = this.ts.topLabel(pos);
        ret.setDescription("default pc label");
        return ret;
    }

    @Override
    public Label defaultArgBound(Formal f) {
        Label ret = this.ts.topLabel(f.position());
        ret.setDescription("default arg bound");
        return ret;
    }

    @Override
    public Label defaultReturnLabel(ProcedureDecl pd) {
        Label Lr = this.ts.bottomLabel();
        for (TypeNode tn : pd.throwTypes()) {
            Label excLabel = this.ts.labelOfType(tn.type(), this.ts.bottomLabel());
            Lr = this.ts.join(Lr, excLabel);
        }
        return Lr;
    }

    @Override
    public Label defaultReturnValueLabel(ProcedureDecl pd) {
        JifProcedureDecl jpd = (JifProcedureDecl)pd;
        Label Lrv = jpd.returnLabel() != null ? jpd.returnLabel().label() : this.defaultReturnLabel(pd);
        JifProcedureInstance pi = (JifProcedureInstance)pd.procedureInstance();
        JifTypeSystem jts = (JifTypeSystem)pi.typeSystem();
        for (Type t : pi.formalTypes()) {
            ArgLabel a = (ArgLabel)jts.labelOfType(t);
            Lrv = this.ts.join(Lrv, a);
        }
        return Lrv;
    }

    @Override
    public Label defaultFieldLabel(FieldDecl fd) {
        Label ret = this.ts.noComponentsLabel(fd.position());
        ret.setDescription("default field label");
        return this.ts.noComponentsLabel(fd.position());
    }

    @Override
    public Label defaultArrayBaseLabel(Type baseType) {
        if (baseType.isArray() && this.ts.isLabeled(baseType.toArray().ultimateBase())) {
            return this.ts.labelOfType(baseType.toArray().ultimateBase());
        }
        Label l = this.ts.noComponentsLabel(baseType.position());
        l.setDescription("default array base label");
        return l;
    }
}

