/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.Collection;
import jif.types.ConstraintMessage;
import jif.types.Equation;
import jif.types.Param;
import jif.types.hierarchy.LabelEnv;
import polyglot.util.Enum;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public abstract class Constraint {
    protected final Param lhs;
    protected final Param rhs;
    protected final Kind kind;
    protected final LabelEnv env;
    protected final Position pos;
    protected final ConstraintMessage messages;
    protected final boolean report;

    public Constraint(Param lhs, Kind kind, Param rhs, LabelEnv env, Position pos, ConstraintMessage msg, boolean report) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.kind = kind;
        this.env = env;
        this.pos = pos;
        this.messages = msg;
        this.report = report;
    }

    public Kind kind() {
        return this.kind;
    }

    public LabelEnv env() {
        return this.env;
    }

    public Position position() {
        return this.pos;
    }

    public boolean report() {
        return this.report;
    }

    public ConstraintMessage messages() {
        return this.messages;
    }

    public String msg() {
        if (this.messages == null) {
            return null;
        }
        return this.messages.msg();
    }

    public String detailMsg() {
        if (this.messages == null) {
            return null;
        }
        return this.messages.detailMsg();
    }

    public String technicalMsg() {
        if (this.messages == null) {
            return null;
        }
        return this.messages.technicalMsg();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.lhs);
        sb.append((Object)this.kind);
        sb.append(this.rhs);
        sb.append(" in environment ");
        sb.append(this.env);
        if (this.pos != null) {
            sb.append("(" + this.pos.toString() + ")");
        }
        return sb.toString();
    }

    public abstract Collection<Equation> getEquations();

    public boolean isCanonical() {
        return this.lhs.isCanonical() && this.rhs.isCanonical();
    }

    public abstract boolean hasVariables();

    public static class Kind
    extends Enum {
        private static final long serialVersionUID = SerialVersionUID.generate();

        protected Kind(String name) {
            super(name);
        }
    }
}

