/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.Topics;
import jif.types.Constraint;
import jif.types.Equation;
import jif.types.FailedConstraintSnapshot;
import jif.types.InformationFlowTrace;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.LabelEquation;
import jif.types.LabelFlowGraph;
import jif.types.PrincipalConstraint;
import jif.types.PrincipalEquation;
import jif.types.Solver;
import jif.types.UnsatisfiableConstraintException;
import jif.types.VarMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.Label;
import jif.types.label.NotTaken;
import jif.types.label.VarLabel;
import jif.types.label.Variable;
import jif.types.principal.Principal;
import jif.types.principal.VarPrincipal;
import polyglot.frontend.Compiler;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Pair;

public abstract class AbstractSolver
implements Solver {
    protected EquationQueue Q;
    protected LinkedList<Set<Equation>> scc;
    protected Set<Equation> currentSCC;
    protected Collection<Equation> equations;
    protected List<FailedConstraintSnapshot> failedEquations;
    private Map<Variable, Set<Equation>> varEqnDependencies;
    private Map<Equation, Set<Variable>> eqnVarDependencies;
    private Map<Variable, Set<Equation>> varEqnReverseDependencies;
    private Map<Equation, Set<Variable>> eqnVarReverseDependencies;
    protected Set<Variable> fixedValueVars;
    protected static final int STATUS_NOT_SOLVED = 0;
    protected static final int STATUS_SOLVING = 1;
    protected static final int STATUS_SOLVED = 2;
    protected static final int STATUS_NO_SOLUTION = 3;
    protected int status;
    protected VarMap bounds;
    protected JifTypeSystem ts;
    protected Set<Equation> staticFailedConstraints;
    protected static final boolean THROW_STATIC_FAILED_CONSTRAINTS = false;
    protected final Compiler compiler;
    protected Map<VarLabel, List<Pair<Equation, Label>>> traces;
    public List<InformationFlowTrace> fullTrace;
    protected static Collection<String> topics = CollectionUtil.list((Object)Topics.jif, (Object)Topics.solver);
    protected final boolean useSCC;
    private final String solverName;
    protected static int solverCounter;
    protected static int constraint_counter;

    protected AbstractSolver(JifTypeSystem ts, Compiler compiler, String solverName) {
        this(ts, compiler, solverName, false);
    }

    protected AbstractSolver(JifTypeSystem ts, Compiler compiler, String solverName, boolean useSCC) {
        this.ts = ts;
        this.compiler = compiler;
        this.useSCC = useSCC;
        this.Q = new EquationQueue();
        this.equations = new LinkedHashSet<Equation>();
        this.varEqnDependencies = new LinkedHashMap<Variable, Set<Equation>>();
        this.eqnVarDependencies = new LinkedHashMap<Equation, Set<Variable>>();
        this.varEqnReverseDependencies = new LinkedHashMap<Variable, Set<Equation>>();
        this.eqnVarReverseDependencies = new LinkedHashMap<Equation, Set<Variable>>();
        this.traces = new LinkedHashMap<VarLabel, List<Pair<Equation, Label>>>();
        this.setStatus(0);
        this.bounds = new VarMap(ts, this.getDefaultLabelBound(), this.getDefaultPrincipalBound());
        this.scc = null;
        this.currentSCC = null;
        this.solverName = solverName + " (#" + ++solverCounter + ")";
        this.fixedValueVars = new HashSet<Variable>();
        this.failedEquations = new ArrayList<FailedConstraintSnapshot>();
        this.fullTrace = new ArrayList<InformationFlowTrace>();
    }

    protected AbstractSolver(AbstractSolver js) {
        this.ts = js.ts;
        this.compiler = js.compiler;
        this.useSCC = js.useSCC;
        this.Q = new EquationQueue(js.Q);
        this.equations = new LinkedHashSet<Equation>(js.equations);
        this.varEqnDependencies = js.varEqnDependencies;
        this.eqnVarDependencies = js.eqnVarDependencies;
        this.traces = new LinkedHashMap<VarLabel, List<Pair<Equation, Label>>>(js.traces);
        this.status = js.status;
        this.bounds = js.bounds.copy();
        this.equations = new LinkedHashSet<Equation>(js.equations);
        this.scc = new LinkedList<Set<Equation>>(js.scc);
        this.solverName = js.solverName;
        this.fixedValueVars = js.fixedValueVars;
        this.failedEquations = new ArrayList<FailedConstraintSnapshot>();
        this.fullTrace = new ArrayList<InformationFlowTrace>();
    }

    public static final void report(int level, String s) {
        Report.report((int)level, (String)s);
    }

    public static final boolean shouldReport(int obscurity) {
        return Report.should_report(topics, (int)obscurity);
    }

    @Override
    public Label applyBoundsTo(Label L) {
        return this.bounds.applyTo(L);
    }

    protected Label triggerTransforms(Label label, LabelEnv env) {
        return env.triggerTransforms(label);
    }

    protected List<Equation> getQueue() {
        return Collections.unmodifiableList(this.Q.list);
    }

    protected void addEquationToQueue(Equation eqn) {
        this.Q.add(eqn);
    }

    protected void addEquationToQueueHead(Equation eqn) {
        this.Q.addFirst(eqn);
    }

    public VarMap bounds() {
        return this.bounds;
    }

    public void setBounds(VarMap bnds) {
        this.bounds = bnds;
    }

    public void setBound(VarLabel v, Label newBound, LabelConstraint responsible) throws SemanticException {
        this.bounds.setBound((Variable)v, newBound);
    }

    public void setBound(VarPrincipal v, Principal newBound, PrincipalConstraint responsible) {
        this.bounds.setBound((Variable)v, newBound);
    }

    @Override
    public VarMap solve() throws SemanticException {
        if (this.status == 2 || this.status == 3) {
            return this.bounds;
        }
        if (this.status == 1) {
            throw new InternalCompilerError("solve called on solver while in the process of solving.");
        }
        this.setStatus(1);
        if (AbstractSolver.shouldReport(1)) {
            AbstractSolver.report(1, "===== Starting solver " + this.solverName + " =====");
            AbstractSolver.report(1, "   " + this.equations.size() + " equations");
        }
        if (this.staticFailedConstraints != null && !this.staticFailedConstraints.isEmpty()) {
            if (AbstractSolver.shouldReport(1)) {
                AbstractSolver.report(1, "   " + this.staticFailedConstraints.size() + " statically failed constraint");
            }
            this.setStatus(3);
            Iterator<Equation> iter = this.staticFailedConstraints.iterator();
            while (iter.hasNext()) {
                UnsatisfiableConstraintException ex = this.reportError(iter.next());
                this.genFlowMessage(ex);
                if (!iter.hasNext()) {
                    throw ex;
                }
                this.compiler.errorQueue().enqueue(5, ex.getMessage(), ex.position());
            }
        }
        if (this.useSCC) {
            Pair<Equation[], int[]> pair = this.findSCCs();
            Equation[] by_scc = (Equation[])pair.part1();
            int[] scc_head = (int[])pair.part2();
            this.scc = new LinkedList();
            LinkedHashSet<Equation> currentScc = null;
            for (int i = 0; i < scc_head.length; ++i) {
                if (scc_head[i] == -1 && currentScc != null) {
                    this.scc.add(currentScc);
                    currentScc = null;
                }
                if (currentScc == null) {
                    currentScc = new LinkedHashSet<Equation>();
                }
                currentScc.add(by_scc[i]);
            }
            if (currentScc != null) {
                this.scc.add(currentScc);
                currentScc = null;
            }
        } else {
            this.scc = new LinkedList();
            this.scc.add(new LinkedHashSet<Equation>(this.equations));
        }
        if (this.scc.isEmpty()) {
            this.currentSCC = Collections.emptySet();
            this.Q = new EquationQueue();
        } else {
            this.currentSCC = this.scc.removeFirst();
            this.Q = new EquationQueue(this.currentSCC);
        }
        try {
            VarMap soln = this.solve_bounds();
            this.setStatus(2);
            if (AbstractSolver.shouldReport(1)) {
                AbstractSolver.report(1, "   finished " + this.solverName);
            }
            return soln;
        }
        catch (SemanticException e) {
            this.setStatus(3);
            this.genFlowMessage((UnsatisfiableConstraintException)e);
            throw e;
        }
    }

    public void genFlowMessage(UnsatisfiableConstraintException ex) {
        if (LabelFlowGraph.shouldReport(1)) {
            LabelFlowGraph g = new LabelFlowGraph(this.fullTrace, ex.getSnapshot());
            g.showErrorPath();
            if (LabelFlowGraph.shouldReport(3)) {
                g.writeToDotFile();
            }
        }
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    protected abstract Label getDefaultLabelBound();

    protected abstract Principal getDefaultPrincipalBound();

    protected VarMap solve_bounds() throws SemanticException {
        if (AbstractSolver.shouldReport(3)) {
            AbstractSolver.report(3, "======EQUATIONS======");
            for (Equation eqn : this.equations) {
                AbstractSolver.report(3, eqn.toString());
            }
        }
        int counter = 0;
        if (this.Q.isEmpty()) {
            this.checkCandidateSolution();
        }
        while (!this.Q.isEmpty()) {
            while (!this.Q.isEmpty()) {
                Equation eqn;
                ++counter;
                eqn = this.Q.removeFirst();
                this.considerEquation(eqn);
                if (!this.Q.isEmpty() || this.scc.isEmpty()) continue;
                this.currentSCC = this.scc.removeFirst();
                this.Q.addAll(this.currentSCC);
            }
            this.checkCandidateSolution();
        }
        if (AbstractSolver.shouldReport(2)) {
            AbstractSolver.report(2, "Number of relaxation steps: " + counter);
        }
        if (AbstractSolver.shouldReport(2)) {
            AbstractSolver.report(2, this.bounds.toString());
        }
        return this.bounds;
    }

    protected void considerEquation(Equation eqn) throws SemanticException {
        if (eqn instanceof LabelEquation) {
            this.considerEquation((LabelEquation)eqn);
        } else if (eqn instanceof PrincipalEquation) {
            this.considerEquation((PrincipalEquation)eqn);
        } else {
            throw new InternalCompilerError("Unexpected eqn " + eqn);
        }
    }

    protected void considerEquation(LabelEquation eqn) throws SemanticException {
        Label lhsbound = this.triggerTransforms(this.bounds.applyTo(eqn.lhs()), eqn.env());
        Label rhsbound = this.triggerTransforms(this.bounds.applyTo(eqn.rhs()), eqn.env());
        if (eqn.env().leq(lhsbound, rhsbound)) {
            if (AbstractSolver.shouldReport(5)) {
                AbstractSolver.report(5, "constraint: " + eqn + " already satisfied: " + lhsbound + "<=" + rhsbound);
            }
        } else {
            if (AbstractSolver.shouldReport(4)) {
                AbstractSolver.report(4, "Considering constraint: " + eqn + " (" + (eqn.position() == null ? "null" : "line " + eqn.position().line()) + ")");
            }
            this.solve_eqn(eqn);
        }
    }

    protected abstract void solve_eqn(LabelEquation var1) throws SemanticException;

    protected void considerEquation(PrincipalEquation eqn) throws SemanticException {
        Principal lhsbound = this.bounds.applyTo(eqn.lhs());
        Principal rhsbound = this.bounds.applyTo(eqn.rhs());
        if (eqn.env().actsFor(lhsbound, rhsbound)) {
            if (AbstractSolver.shouldReport(5)) {
                AbstractSolver.report(5, "constraint: " + eqn + " already satisfied: " + lhsbound + " actsfor " + rhsbound);
            }
        } else {
            if (AbstractSolver.shouldReport(4)) {
                AbstractSolver.report(4, "Considering constraint: " + eqn + " (" + (eqn.position() == null ? "null" : "line " + eqn.position().line()) + ")");
            }
            this.solve_eqn(eqn);
        }
    }

    protected abstract void solve_eqn(PrincipalEquation var1) throws SemanticException;

    protected final void checkCandidateSolution() throws SemanticException {
        if (AbstractSolver.shouldReport(4)) {
            AbstractSolver.report(4, "===== Checking candidate solution =====");
        }
        for (Equation eqn : this.equations) {
            if (!(eqn instanceof LabelEquation)) continue;
            this.checkEquationSatisfied((LabelEquation)eqn);
        }
    }

    protected void checkEquationSatisfied(LabelEquation eqn) throws SemanticException {
        for (Variable v : eqn.variables()) {
            if (!v.mustRuntimeRepresentable()) continue;
            boolean isRuntimeRepresentable = false;
            if (v instanceof VarLabel) {
                isRuntimeRepresentable = this.bounds.boundOf((VarLabel)v).isRuntimeRepresentable();
            } else if (v instanceof VarPrincipal) {
                isRuntimeRepresentable = this.bounds.boundOf((VarPrincipal)v).isRuntimeRepresentable();
            } else {
                throw new InternalCompilerError("Unexpected variable " + v);
            }
            if (isRuntimeRepresentable) continue;
            this.reportTrace(v);
            throw new SemanticException(v + " must be runtime representable in equation " + eqn, eqn.position());
        }
        Label lhsBound = this.triggerTransforms(this.bounds.applyTo(eqn.lhs()), eqn.env());
        Label rhsBound = this.triggerTransforms(this.bounds.applyTo(eqn.rhs()), eqn.env());
        if (AbstractSolver.shouldReport(4)) {
            AbstractSolver.report(4, "Checking equation: " + eqn);
        }
        if (AbstractSolver.shouldReport(6)) {
            AbstractSolver.report(6, "LHS = " + eqn.lhs());
            AbstractSolver.report(6, "LHS APP = " + lhsBound);
            AbstractSolver.report(6, "RHS APP = " + rhsBound);
        }
        if (!eqn.env().leq(lhsBound, rhsBound)) {
            throw this.reportError(eqn);
        }
    }

    protected final void wakeUp(Variable v) {
        Set<Equation> eqns = this.varEqnDependencies.get(v);
        if (eqns != null) {
            for (Equation eqn : eqns) {
                if (this.Q.contains(eqn) || this.useSCC && !this.currentSCC.contains(eqn)) continue;
                this.Q.add(eqn);
            }
        }
    }

    public String solverName() {
        return this.solverName;
    }

    protected final void inc_counter() {
        ++constraint_counter;
    }

    protected boolean isFixedValueVar(Variable v) {
        return this.fixedValueVars.contains(v);
    }

    @Override
    public void addConstraint(Constraint c) throws SemanticException {
        if (this.status != 0) {
            throw new InternalCompilerError("Computed solution already. Cannot add more constraints");
        }
        if (AbstractSolver.shouldReport(3)) {
            StackTraceElement[] stack = new Exception().getStackTrace();
            String source = stack[4].getFileName() + ":" + stack[4].getLineNumber();
            AbstractSolver.report(3, constraint_counter + 1 + ": " + c + " << " + source);
        }
        if (AbstractSolver.shouldReport(6)) {
            AbstractSolver.report(6, ">>> " + c.msg());
        }
        this.inc_counter();
        if (!c.isCanonical()) {
            throw new InternalCompilerError(c.position(), "Constraint is not canonical.");
        }
        if (c instanceof LabelConstraint) {
            LabelConstraint lc = (LabelConstraint)c;
            if (lc.lhsLabel() instanceof NotTaken && lc.kind() == LabelConstraint.LEQ) {
                return;
            }
            if (lc.rhsLabel() instanceof NotTaken && lc.kind() == LabelConstraint.LEQ) {
                LabelEquation eqn = new LabelEquation(lc.lhsLabel(), lc.rhsLabel(), lc);
                this.reportError(eqn);
            }
        }
        this.processConstraint(c);
        this.addConstraintEquations(c);
    }

    protected void processConstraint(Constraint c) throws SemanticException {
        PrincipalConstraint pc;
        if (c instanceof LabelConstraint) {
            LabelConstraint lc = (LabelConstraint)c;
            if (lc.lhsLabel() instanceof VarLabel && lc.kind() == LabelConstraint.EQUAL) {
                VarLabel v = (VarLabel)lc.lhsLabel();
                Label initialBound = this.bounds.applyTo(lc.rhsLabel());
                this.addTrace(v, lc.rhsLabel(), lc.getEquations().iterator().next(), initialBound, InformationFlowTrace.Direction.BOTH);
                this.setBound(v, initialBound, lc);
                if (!lc.rhsLabel().hasVariableComponents()) {
                    this.fixedValueVars.add(v);
                }
            }
        } else if (c instanceof PrincipalConstraint && ((pc = (PrincipalConstraint)c).lhsPrincipal() instanceof VarPrincipal || pc.rhsPrincipal() instanceof VarPrincipal) && pc.kind() == PrincipalConstraint.EQUIV) {
            VarPrincipal v = null;
            Principal other = null;
            if (pc.lhsPrincipal() instanceof VarPrincipal) {
                v = (VarPrincipal)pc.lhsPrincipal();
                other = pc.rhsPrincipal();
            } else {
                v = (VarPrincipal)pc.rhsPrincipal();
                other = pc.lhsPrincipal();
            }
            Principal initialBound = this.bounds.applyTo(other);
            this.setBound(v, initialBound, pc);
            if (!other.hasVariables()) {
                this.fixedValueVars.add(v);
            }
        }
    }

    protected void addConstraintEquations(Constraint c) throws SemanticException {
        Collection<Equation> eqns = c.getEquations();
        for (Equation eqn : eqns) {
            LabelEnv eqnEnv = eqn.env();
            if (!eqnEnv.hasVariables() && !eqn.constraint().hasVariables()) {
                boolean eqnSatisfied = false;
                if (eqn instanceof LabelEquation) {
                    LabelEquation leqn = (LabelEquation)eqn;
                    eqnSatisfied = eqnEnv.leq(this.triggerTransforms(leqn.lhs(), eqnEnv), this.triggerTransforms(leqn.rhs(), eqnEnv));
                } else if (eqn instanceof PrincipalEquation) {
                    PrincipalEquation peqn = (PrincipalEquation)eqn;
                    eqnSatisfied = eqnEnv.actsFor(peqn.lhs(), peqn.rhs());
                } else {
                    throw new InternalCompilerError("Unexpected kind of equation: " + eqn);
                }
                if (eqnSatisfied) continue;
                if (AbstractSolver.shouldReport(2)) {
                    AbstractSolver.report(2, "Statically failed " + eqn);
                }
                if (AbstractSolver.shouldReport(3) && eqn instanceof LabelEquation) {
                    AbstractSolver.report(3, "Statically failed " + this.triggerTransforms(((LabelEquation)eqn).lhs(), eqnEnv) + " <= " + this.triggerTransforms(((LabelEquation)eqn).rhs(), eqnEnv));
                }
                if (this.staticFailedConstraints == null) {
                    this.staticFailedConstraints = new LinkedHashSet<Equation>();
                }
                this.staticFailedConstraints.add(eqn);
                continue;
            }
            if (AbstractSolver.shouldReport(5)) {
                AbstractSolver.report(5, "Adding equation: " + eqn);
            }
            eqnEnv.setSolver(this);
            this.equations.add(eqn);
            this.addDependencies(eqn);
        }
    }

    protected abstract void addDependencies(Equation var1);

    protected void addDependency(Variable var, Equation eqn) {
        Set<Equation> eqns = this.varEqnDependencies.get(var);
        if (eqns == null) {
            eqns = new LinkedHashSet<Equation>();
            this.varEqnDependencies.put(var, eqns);
        }
        eqns.add(eqn);
        Set<Variable> vars = this.eqnVarReverseDependencies.get(eqn);
        if (vars == null) {
            vars = new LinkedHashSet<Variable>();
            this.eqnVarReverseDependencies.put(eqn, vars);
        }
        vars.add(var);
    }

    protected void addDependency(Equation eqn, Variable var) {
        Set<Variable> vars = this.eqnVarDependencies.get(eqn);
        if (vars == null) {
            vars = new LinkedHashSet<Variable>();
            this.eqnVarDependencies.put(eqn, vars);
        }
        vars.add(var);
        Set<Equation> eqns = this.varEqnReverseDependencies.get(var);
        if (eqns == null) {
            eqns = new LinkedHashSet<Equation>();
            this.varEqnReverseDependencies.put(var, eqns);
        }
        eqns.add(eqn);
    }

    protected Set<Equation> eqnEqnDependencies(Equation eqn) {
        Set<Variable> vars = this.eqnVarDependencies.get(eqn);
        if (vars == null || vars.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Equation> eqns = new LinkedHashSet<Equation>();
        for (Variable v : vars) {
            Set<Equation> s = this.varEqnDependencies.get(v);
            if (s == null) continue;
            eqns.addAll(s);
        }
        return eqns;
    }

    protected Set<Equation> eqnEqnReverseDependencies(Equation eqn) {
        Set<Variable> vars = this.eqnVarReverseDependencies.get(eqn);
        if (vars == null || vars.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Equation> eqns = new LinkedHashSet<Equation>();
        for (Variable v : vars) {
            Set<Equation> s = this.varEqnReverseDependencies.get(v);
            if (s == null) continue;
            eqns.addAll(s);
        }
        return eqns;
    }

    protected final void addTrace(VarLabel v, Label sourcelabel, Equation eqn, Label lb, InformationFlowTrace.Direction dir) {
        this.fullTrace.add(new InformationFlowTrace(v, sourcelabel, dir, (LabelEquation)eqn));
        List<Pair<Equation, Label>> trace = this.traces.get(v);
        if (trace == null) {
            trace = new LinkedList<Pair<Equation, Label>>();
            this.traces.put(v, trace);
        }
        trace.add((Pair<Equation, Label>)new Pair((Object)eqn, (Object)lb.copy()));
    }

    protected final Equation findTrace(VarLabel var, Label threshold, boolean lowerThreshold) {
        List<Pair<Equation, Label>> history = this.traces.get(var);
        if (history != null) {
            for (Pair<Equation, Label> eqn_label : history) {
                Label label = (Label)eqn_label.part2();
                Equation eqn = (Equation)eqn_label.part1();
                boolean test = lowerThreshold ? eqn.env().leq(threshold, label) : eqn.env().leq(label, threshold);
                if (test) continue;
                return eqn;
            }
        }
        return null;
    }

    protected Equation findContradictiveEqn(Constraint c) {
        if (c instanceof LabelConstraint) {
            return this.findContradictiveEqn((LabelConstraint)c);
        }
        throw new InternalCompilerError("Unexpected constraint type: " + c.getClass());
    }

    protected abstract Equation findContradictiveEqn(LabelConstraint var1);

    protected Pair<Equation[], int[]> findSCCs() {
        Equation[] sorted = new Equation[this.equations.size()];
        int n = 0;
        LinkedList<Frame> stack = new LinkedList<Frame>();
        HashSet<Equation> reachable = new HashSet<Equation>();
        for (Equation eq : this.equations) {
            if (reachable.contains(eq)) continue;
            reachable.add(eq);
            stack.addFirst(new Frame(eq, true));
            while (!stack.isEmpty()) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    Equation eqTo = top.edges.next();
                    if (reachable.contains(eqTo)) continue;
                    reachable.add(eqTo);
                    stack.addFirst(new Frame(eqTo, true));
                    continue;
                }
                stack.removeFirst();
                sorted[n++] = top.eqn;
            }
        }
        Equation[] by_scc = new Equation[n];
        int[] scc_head = new int[n];
        HashSet<Equation> visited = new HashSet<Equation>();
        int head = 0;
        for (int i = n - 1; i >= 0; --i) {
            if (visited.contains(sorted[i])) continue;
            HashSet<Equation> SCC = new HashSet<Equation>();
            visited.add(sorted[i]);
            stack.add(new Frame(sorted[i], false));
            while (!stack.isEmpty()) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    Equation eqTo = top.edges.next();
                    if (!reachable.contains(eqTo) || visited.contains(eqTo)) continue;
                    visited.add(eqTo);
                    Frame f = new Frame(eqTo, false);
                    stack.addFirst(f);
                    continue;
                }
                stack.removeFirst();
                SCC.add(top.eqn);
            }
            stack.add(new Frame(sorted[i], true));
            HashSet<Equation> revisited = new HashSet<Equation>();
            revisited.add(sorted[i]);
            int scc_size = SCC.size();
            int nsorted = 0;
            while (stack.size() != 0) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    Equation eqTo = top.edges.next();
                    if (!SCC.contains(eqTo) || revisited.contains(eqTo)) continue;
                    revisited.add(eqTo);
                    Frame f = new Frame(eqTo, true);
                    stack.addFirst(f);
                    continue;
                }
                stack.removeFirst();
                int n3 = head + scc_size - nsorted - 1;
                scc_head[n3] = -2;
                by_scc[n3] = top.eqn;
                ++nsorted;
            }
            scc_head[head + scc_size - 1] = head;
            scc_head[head] = -1;
            head += scc_size;
        }
        return new Pair((Object)by_scc, (Object)scc_head);
    }

    protected UnsatisfiableConstraintException reportError(Equation eqn) {
        for (Variable v : eqn.variables()) {
            this.reportTrace(v);
        }
        Equation reporteqn = (Equation)eqn.copy();
        this.bounds.applyTo(reporteqn);
        return new UnsatisfiableConstraintException(this, reporteqn, new FailedConstraintSnapshot(eqn, this.bounds.copy()));
    }

    protected void reportTrace(Variable v) {
    }

    static {
        constraint_counter = 0;
    }

    protected static class EquationQueue {
        final LinkedList<Equation> list;
        final Set<Equation> elements;

        public EquationQueue() {
            this.list = new LinkedList();
            this.elements = new HashSet<Equation>();
        }

        public EquationQueue(Collection<Equation> c) {
            this.list = new LinkedList<Equation>(c);
            this.elements = new HashSet<Equation>(c);
        }

        public EquationQueue(EquationQueue q) {
            this.list = new LinkedList<Equation>(q.list);
            this.elements = new HashSet<Equation>(q.elements);
        }

        public boolean contains(Equation eqn) {
            return this.elements.contains(eqn);
        }

        public void addAll(Collection<Equation> c) {
            if (c != null) {
                for (Equation e : c) {
                    this.add(e);
                }
            }
        }

        public Equation removeFirst() {
            Equation e = this.list.removeFirst();
            this.elements.remove(e);
            return e;
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public void add(Equation eqn) {
            if (!this.elements.contains(eqn)) {
                this.list.add(eqn);
                this.elements.add(eqn);
            }
        }

        public void addFirst(Equation eqn) {
            if (this.elements.contains(eqn)) {
                this.list.remove(eqn);
            }
            this.list.addFirst(eqn);
            this.elements.add(eqn);
        }
    }

    protected class Frame {
        Equation eqn;
        Iterator<Equation> edges;

        Frame(Equation e, boolean forward) {
            this.eqn = e;
            this.edges = forward ? AbstractSolver.this.eqnEqnDependencies(e).iterator() : AbstractSolver.this.eqnEqnReverseDependencies(e).iterator();
        }
    }
}

