/*
 * Decompiled with CFR 0.152.
 */
package jif.translate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jif.ast.JifMethodDecl;
import jif.translate.ClassDeclToJavaExt_c;
import jif.translate.JifToJavaRewriter;
import jif.translate.ToJavaExt_c;
import jif.types.ActsForConstraint;
import jif.types.Assertion;
import jif.types.JifMethodInstance;
import jif.types.JifParsedPolyType;
import jif.types.JifPolyType;
import jif.types.JifTypeSystem;
import jif.types.LabelLeAssertion;
import polyglot.ast.Binary;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.LocalDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.StringLit;
import polyglot.ast.Throw;
import polyglot.ast.TypeNode;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;

public class MethodDeclToJavaExt_c
extends ToJavaExt_c {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected JifMethodInstance mi;
    protected List<Formal> formals;

    @Override
    public NodeVisitor toJavaEnter(JifToJavaRewriter rw) throws SemanticException {
        JifMethodDecl n = (JifMethodDecl)this.node();
        this.mi = (JifMethodInstance)n.methodInstance();
        this.formals = new ArrayList<Formal>(n.formals());
        return rw.bypass(n.startLabel()).bypass((Node)n.returnLabel()).bypass(n.constraints());
    }

    @Override
    public Node toJava(JifToJavaRewriter rw) throws SemanticException {
        boolean isMainMethod;
        MethodDecl n = (MethodDecl)this.node();
        boolean bl = isMainMethod = "main".equals(n.name()) && n.flags().isStatic();
        if (isMainMethod && n.formals().size() == 2) {
            return this.staticMainToJava(rw, n);
        }
        MethodInstance mi = n.methodInstance();
        ArrayList<Formal> formals = new ArrayList<Formal>(n.formals().size() + 2);
        if (mi.flags().isStatic() && mi.container() instanceof JifPolyType) {
            JifPolyType jpt = (JifPolyType)mi.container();
            formals.addAll(ClassDeclToJavaExt_c.produceParamFormals(jpt, rw));
        }
        formals.addAll(n.formals());
        n = rw.java_nf().MethodDecl(n.position(), n.flags(), n.returnType(), n.id(), formals, n.throwTypes(), n.body(), n.javadoc());
        n = n.methodInstance(null);
        if (isMainMethod) {
            n = (MethodDecl)n.body(this.guardWithConstraints(rw, n.body()));
        }
        return n;
    }

    public Node staticMainToJava(JifToJavaRewriter rw, MethodDecl n) throws SemanticException {
        Formal formal0 = (Formal)n.formals().get(0);
        Formal formal1 = (Formal)n.formals().get(1);
        List<Formal> formalList = Collections.singletonList(formal1);
        Block origBody = n.body();
        JifTypeSystem jifTs = rw.jif_ts();
        TypeNode type = rw.qq().parseType(jifTs.PrincipalClassName(), new Object[0]);
        Expr init = rw.qq().parseExpr(jifTs.RuntimePackageName() + ".Runtime.user(null)", new Object[0]);
        LocalDecl declPrincipal = rw.java_nf().LocalDecl(origBody.position(), Flags.FINAL, type, formal0.id(), init);
        Block newBody = this.guardWithConstraints(rw, origBody);
        newBody = rw.java_nf().Block(origBody.position(), new Stmt[]{declPrincipal, newBody});
        n = rw.java_nf().MethodDecl(n.position(), n.flags(), n.returnType(), n.id(), formalList, n.throwTypes(), newBody);
        n = n.methodInstance(null);
        return n;
    }

    protected Block guardWithConstraints(JifToJavaRewriter rw, Block b) throws SemanticException {
        NodeFactory nf = rw.java_nf();
        ArrayList constraints = new ArrayList(this.mi.constraints());
        JifParsedPolyType pct = (JifParsedPolyType)rw.currentClass();
        constraints.addAll(pct.constraints());
        Position pos = b.position();
        Expr guard = null;
        for (Assertion constraint : constraints) {
            Expr conjunct;
            if (constraint instanceof ActsForConstraint) {
                conjunct = ((ActsForConstraint)constraint).toJava(rw);
            } else {
                if (!(constraint instanceof LabelLeAssertion)) continue;
                conjunct = ((LabelLeAssertion)constraint).toJava(rw);
            }
            if (guard == null) {
                guard = conjunct;
                continue;
            }
            guard = nf.Binary(pos, guard, Binary.COND_AND, conjunct);
        }
        if (guard == null) {
            return b;
        }
        StringLit errorMessage = nf.StringLit(pos, "The method " + this.mi.debugString() + " has constraints that are unsatisfied.");
        Throw error = nf.Throw(pos, (Expr)nf.New(pos, (TypeNode)nf.CanonicalTypeNode(pos, (Type)rw.java_ts().Error()), Collections.singletonList(errorMessage)));
        return nf.Block(pos, new Stmt[]{nf.If(pos, guard, (Stmt)b, (Stmt)error)});
    }
}

