/*
 * Decompiled with CFR 0.152.
 */
package jif.translate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import jif.ast.JifExt;
import jif.ast.JifNodeFactory;
import jif.ast.JifUtil;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.label.Label;
import jif.types.principal.Principal;
import polyglot.ast.Block;
import polyglot.ast.ClassDecl;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceCollection;
import polyglot.ast.SourceFile;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.Job;
import polyglot.frontend.Source;
import polyglot.qq.QQ;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class JifToJavaRewriter
extends ContextVisitor {
    protected ExtensionInfo java_ext;
    protected JifTypeSystem jif_ts;
    protected JifNodeFactory jif_nf;
    protected QQ qq;
    protected Collection<ClassDecl> additionalClassDecls;
    protected Collection<SourceFile> newSourceFiles;
    protected List<Stmt> initializations;
    protected List<Block> staticInitializations;
    private ClassType currentClass;
    private boolean inConstructor;
    private Cell<Boolean> haveThisCall;

    public JifToJavaRewriter(Job job, JifTypeSystem jif_ts, JifNodeFactory jif_nf, ExtensionInfo java_ext) {
        super(job, (TypeSystem)jif_ts, java_ext.nodeFactory());
        this.job = job;
        this.jif_ts = jif_ts;
        this.jif_nf = jif_nf;
        this.java_ext = java_ext;
        this.qq = new QQ(java_ext);
        this.additionalClassDecls = new LinkedList<ClassDecl>();
        this.newSourceFiles = new LinkedList<SourceFile>();
        this.initializations = new ArrayList<Stmt>();
        this.staticInitializations = new ArrayList<Block>();
        this.haveThisCall = new Cell();
    }

    public JifToJavaRewriter copy() {
        JifToJavaRewriter rw = (JifToJavaRewriter)super.copy();
        if (!this.inConstructor) {
            rw.haveThisCall = new Cell(this.haveThisCall.value);
        }
        return rw;
    }

    public void finish(Node ast) {
        if (ast instanceof SourceCollection) {
            SourceCollection c = (SourceCollection)ast;
            List sources = c.sources();
            for (SourceFile sf : sources) {
                this.java_ext.scheduler().addJob(sf.source(), (Node)sf);
            }
        } else {
            this.java_ext.scheduler().addJob(this.job.source(), ast);
        }
        for (SourceFile sf : this.newSourceFiles) {
            this.java_ext.scheduler().addJob(sf.source(), (Node)sf);
        }
        this.newSourceFiles.clear();
    }

    public JifTypeSystem jif_ts() {
        return this.jif_ts;
    }

    public JifNodeFactory jif_nf() {
        return this.jif_nf;
    }

    public TypeSystem java_ts() {
        return this.java_ext.typeSystem();
    }

    public NodeFactory java_nf() {
        return this.java_ext.nodeFactory();
    }

    public ErrorQueue errorQueue() {
        return this.job.compiler().errorQueue();
    }

    public NodeVisitor enterCall(Node n) {
        try {
            JifExt ext = JifUtil.jifExt(n);
            return ext.toJava().toJavaEnter(this);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.errorQueue().enqueue(5, e.getMessage(), position);
            return this;
        }
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) {
        try {
            JifExt ext = JifUtil.jifExt(n);
            Node m = ext.toJava().toJava(this, v);
            if (m.del() instanceof JifExt) {
                throw new InternalCompilerError(m + " is still a Jif node.");
            }
            return m;
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            this.errorQueue().enqueue(5, e.getMessage(), position);
            return n;
        }
    }

    public Expr paramToJava(Param param) throws SemanticException {
        return this.paramToJava(param, this.qq().parseExpr("this", new Object[0]));
    }

    public Expr paramToJava(Param param, Expr thisQualifier) throws SemanticException {
        if (param instanceof Label) {
            return this.labelToJava((Label)param, thisQualifier);
        }
        if (param instanceof Principal) {
            return this.principalToJava((Principal)param, thisQualifier);
        }
        throw new InternalCompilerError("Unexpected param " + param);
    }

    public Expr labelToJava(Label label) throws SemanticException {
        return this.labelToJava(label, this.qq().parseExpr("this", new Object[0]));
    }

    public Expr labelToJava(Label label, boolean simplify) throws SemanticException {
        return this.labelToJava(label, this.qq().parseExpr("this", new Object[0]), simplify);
    }

    public Expr labelToJava(Label label, Expr thisQualifier) throws SemanticException {
        return this.labelToJava(label, thisQualifier, true);
    }

    public Expr labelToJava(Label label, Expr thisQualifier, boolean simplify) throws SemanticException {
        return label.toJava(this, thisQualifier, simplify);
    }

    public Expr principalToJava(Principal principal) throws SemanticException {
        return this.principalToJava(principal, this.qq().parseExpr("this", new Object[0]));
    }

    public Expr principalToJava(Principal principal, Expr thisQualifier) throws SemanticException {
        return principal.toJava(this, thisQualifier);
    }

    public TypeNode typeToJava(Type t, Position pos) throws SemanticException {
        NodeFactory nf = this.java_nf();
        TypeSystem ts = this.java_ts();
        JifTypeSystem jifts = this.jif_ts();
        if (t.isNull()) {
            return this.canonical(nf, (Type)ts.Null(), pos);
        }
        if (t.isVoid()) {
            return this.canonical(nf, (Type)ts.Void(), pos);
        }
        if (t.isBoolean()) {
            return this.canonical(nf, (Type)ts.Boolean(), pos);
        }
        if (t.isByte()) {
            return this.canonical(nf, (Type)ts.Byte(), pos);
        }
        if (t.isChar()) {
            return this.canonical(nf, (Type)ts.Char(), pos);
        }
        if (t.isShort()) {
            return this.canonical(nf, (Type)ts.Short(), pos);
        }
        if (t.isInt()) {
            return this.canonical(nf, (Type)ts.Int(), pos);
        }
        if (t.isLong()) {
            return this.canonical(nf, (Type)ts.Long(), pos);
        }
        if (t.isFloat()) {
            return this.canonical(nf, (Type)ts.Float(), pos);
        }
        if (t.isDouble()) {
            return this.canonical(nf, (Type)ts.Double(), pos);
        }
        if (jifts.isLabel(t)) {
            return nf.TypeNodeFromQualifiedName(pos, jifts.LabelClassName());
        }
        if (jifts.isPrincipal(t)) {
            return nf.TypeNodeFromQualifiedName(pos, jifts.PrincipalClassName());
        }
        if (t.isArray()) {
            return nf.ArrayTypeNode(pos, this.typeToJava(t.toArray().base(), pos));
        }
        if (t.isClass()) {
            return nf.TypeNodeFromQualifiedName(pos, t.toClass().fullName());
        }
        throw new InternalCompilerError("Cannot translate type " + t + ".");
    }

    protected TypeNode canonical(NodeFactory nf, Type t, Position pos) {
        return nf.CanonicalTypeNode(pos, t);
    }

    public QQ qq() {
        return this.qq;
    }

    public ClassType currentClass() {
        return this.currentClass;
    }

    public void enteringClass(ClassType t) {
        this.currentClass = t;
    }

    public void leavingClass() {
        this.currentClass = null;
    }

    public void addInitializer(Block s) {
        this.initializations.add((Stmt)s);
    }

    public void addInitializer(FieldInstance fi, Expr init) throws SemanticException {
        Stmt s = this.qq().parseStmt(fi.name() + " = %E;", new Object[]{init});
        this.initializations.add(s);
    }

    public List<Stmt> getInitializations() {
        return this.initializations;
    }

    public void addStaticInitializer(Block s) {
        this.staticInitializations.add(s);
    }

    public List<Block> getStaticInitializations() {
        return this.staticInitializations;
    }

    public void addAdditionalClassDecl(ClassDecl cd) {
        this.additionalClassDecls.add(cd);
    }

    public Node leavingSourceFile(SourceFile n) {
        ArrayList<ClassDecl> l = new ArrayList<ClassDecl>(n.decls().size() + this.additionalClassDecls.size());
        l.addAll(n.decls());
        for (ClassDecl cd : this.additionalClassDecls) {
            if (cd.flags().isPublic()) {
                try {
                    SourceFile sf = this.java_nf().SourceFile(Position.compilerGenerated(), n.package_(), Collections.emptyList(), Collections.singletonList(cd));
                    JavaFileManager.Location location = this.java_ext.getOptions().source_output;
                    String pkgName = "";
                    if (sf.package_() != null) {
                        pkgName = sf.package_().package_().fullName() + ".";
                    }
                    JavaFileObject jfo = this.java_ext.extFileManager().getJavaFileForOutput(location, pkgName + cd.name(), JavaFileObject.Kind.SOURCE, null);
                    FileSource s = this.java_ext.createFileSource((FileObject)jfo, Source.Kind.COMPILER_GENERATED);
                    sf = sf.source((Source)s);
                    this.newSourceFiles.add(sf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            l.add(cd);
        }
        this.additionalClassDecls.clear();
        return n.decls(l);
    }

    public boolean inConstructor() {
        return this.inConstructor;
    }

    public void inConstructor(boolean flag) {
        this.inConstructor = flag;
        this.haveThisCall.value = flag ? Boolean.valueOf(false) : null;
    }

    public Boolean haveThisCall() {
        return (Boolean)this.haveThisCall.value;
    }

    public void haveThisCall(boolean value) {
        this.haveThisCall.value = value;
    }

    public String runtimeLabelUtil() {
        return this.jif_ts().LabelUtilClassName() + ".singleton()";
    }

    private static class Cell<T> {
        T value;

        Cell() {
            this(null);
        }

        Cell(T value) {
            this.value = value;
        }
    }
}

