/*
 * Decompiled with CFR 0.152.
 */
package jif.translate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jif.ast.JifConstructorDecl;
import jif.translate.ClassDeclToJavaExt_c;
import jif.translate.JifToJavaRewriter;
import jif.translate.ToJavaExt_c;
import jif.types.JifConstructorInstance;
import jif.types.JifPolyType;
import jif.types.JifSubstType;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Empty;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;

public class ConstructorDeclToJavaExt_c
extends ToJavaExt_c {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected JifConstructorInstance ci;
    protected List<Formal> formals;

    @Override
    public NodeVisitor toJavaEnter(JifToJavaRewriter rw) throws SemanticException {
        JifConstructorDecl n = (JifConstructorDecl)this.node();
        rw.inConstructor(true);
        this.ci = (JifConstructorInstance)n.constructorInstance();
        this.formals = new ArrayList<Formal>(n.formals());
        return rw.bypass(n.startLabel()).bypass((Node)n.returnLabel()).bypass(n.constraints());
    }

    @Override
    public final Node toJava(JifToJavaRewriter rw) throws SemanticException {
        throw new InternalCompilerError("Shouldn't be called.");
    }

    @Override
    public Node toJava(JifToJavaRewriter rw, NodeVisitor childVisitor) throws SemanticException {
        Node retVal;
        ConstructorDecl n = (ConstructorDecl)this.node();
        ClassType ct = this.ci.container().toClass();
        if (rw.jif_ts().isSignature((Type)ct)) {
            if (rw.jif_ts().isParamsRuntimeRep((Type)ct)) {
                ArrayList<Formal> formals = new ArrayList<Formal>(n.formals().size() + 2);
                if (this.ci.container() instanceof JifPolyType) {
                    JifPolyType jpt = (JifPolyType)this.ci.container();
                    formals.addAll(ClassDeclToJavaExt_c.produceParamFormals(jpt, rw));
                }
                formals.addAll(n.formals());
                n = rw.java_nf().ConstructorDecl(n.position(), n.flags(), n.id(), formals, n.throwTypes(), n.body(), n.javadoc());
                n = n.constructorInstance(null);
                retVal = n;
            } else {
                NodeFactory nf = rw.java_nf();
                retVal = nf.ConstructorDecl(n.position(), n.flags(), n.id(), n.formals(), n.throwTypes(), n.body(), n.javadoc());
            }
        } else {
            retVal = this.jifClassConstructorDecl(rw, (JifToJavaRewriter)childVisitor, n);
        }
        rw.inConstructor(false);
        return retVal;
    }

    private Node jifClassConstructorDecl(JifToJavaRewriter rw, JifToJavaRewriter childRw, ConstructorDecl n) {
        NodeFactory nf = rw.java_nf();
        ConstructorInstance ci = n.constructorInstance();
        ClassType ct = ci.container().toClass();
        Block body = n.body();
        ArrayList<Stmt> inits = new ArrayList<Stmt>(3);
        if (!childRw.haveThisCall().booleanValue()) {
            inits.add(rw.qq().parseStmt("this.jif$init();", new Object[0]));
        }
        if (!(body.statements().isEmpty() || body.statements().size() == 1 && body.statements().get(0) instanceof Empty)) {
            if (!rw.jif_ts().isSignature((Type)ct) && rw.jif_ts().isSignature(ct.superType())) {
                ConstructorCall cc;
                Stmt s;
                Type superType;
                int numSuperParams = 0;
                if (rw.jif_ts().isParamsRuntimeRep(ct.superType()) && (superType = ct.superType()) instanceof JifSubstType) {
                    numSuperParams = ((JifPolyType)((JifSubstType)superType).base()).params().size();
                }
                if ((s = (Stmt)body.statements().get(0)) instanceof ConstructorCall && (cc = (ConstructorCall)s).kind() == ConstructorCall.SUPER) {
                    if (cc.arguments().size() != numSuperParams) {
                        throw new InternalCompilerError(body.position(), "Expected super constructor call to be the default constructor as we have a Jif class with a non-Jif superclass: " + cc);
                    }
                    LinkedList stmtList = new LinkedList(body.statements());
                    stmtList.remove(0);
                    body = body.statements(stmtList);
                }
            }
            inits.add((Stmt)body);
        }
        inits.addAll(this.additionalInits(rw));
        this.addConstructorReturn(rw, (JifConstructorInstance)ci, inits, n.position());
        body = nf.Block(n.position(), inits);
        body = this.jifConstructorBody(rw, body);
        Id name = nf.Id(n.position(), ClassDeclToJavaExt_c.constructorTranslatedName(ct));
        CanonicalTypeNode tn = rw.jif_nf().CanonicalTypeNode(n.position(), (Type)ct);
        tn = (TypeNode)tn.visit((NodeVisitor)rw);
        MethodDecl m = nf.MethodDecl(n.position(), n.flags(), (TypeNode)tn, name, n.formals(), n.throwTypes(), body, n.javadoc());
        m = m.methodInstance(null);
        return m;
    }

    protected void addConstructorReturn(JifToJavaRewriter rw, JifConstructorInstance ci, List<Stmt> inits, Position pos) {
        NodeFactory nf = rw.java_nf();
        inits.add((Stmt)nf.Return(pos, (Expr)nf.This(pos)));
    }

    protected Block jifConstructorBody(JifToJavaRewriter rw, Block body) {
        return body;
    }

    protected List<Stmt> additionalInits(JifToJavaRewriter rw) {
        return Collections.emptyList();
    }
}

