/*
 * Decompiled with CFR 0.152.
 */
package jif.translate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jif.ast.JifClassDecl;
import jif.translate.JifToJavaRewriter;
import jif.translate.ParamToJavaExpr_c;
import jif.translate.ToJavaExt_c;
import jif.types.JifContext;
import jif.types.JifPolyType;
import jif.types.JifSubst;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.label.Label;
import jif.types.principal.Principal;
import polyglot.ast.AmbTypeNode;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;

public class ClassDeclToJavaExt_c
extends ToJavaExt_c {
    private static final long serialVersionUID = SerialVersionUID.generate();
    public static final String INSTANCEOF_METHOD_NAME = "jif$Instanceof";
    protected static final String INITIALIZATIONS_METHOD_NAME = "jif$init";
    protected static final String DEFAULT_CONSTRUCTOR_INVOKER_METHOD_NAME = "jif$invokeDefConstructor";
    private boolean hasDefaultConstructor = false;
    private List<? extends Type> defaultConstructorExceptions = null;

    public static final String castMethodName(ClassType ct) {
        return "jif$cast$" + ct.fullName().replace('.', '_');
    }

    public static final String interfaceClassImplName(String jifInterfaceName) {
        return jifInterfaceName + "_JIF_IMPL";
    }

    public static final String constructorTranslatedName(ClassType ct) {
        return (ct.fullName() + ".").replace('.', '$');
    }

    @Override
    public NodeVisitor toJavaEnter(JifToJavaRewriter rw) throws SemanticException {
        JifClassDecl n = (JifClassDecl)this.node();
        rw.enteringClass((ClassType)n.type());
        ParsedClassType ct = n.type();
        for (ConstructorInstance ci : ct.constructors()) {
            if (!ci.formalTypes().isEmpty()) continue;
            this.hasDefaultConstructor = true;
            this.defaultConstructorExceptions = ci.throwTypes();
            break;
        }
        return rw.bypass(n.params()).bypass(n.authority()).bypass(n.constraints());
    }

    @Override
    public Node toJava(JifToJavaRewriter rw) throws SemanticException {
        Node result = this.toJavaImpl(rw);
        rw.leavingClass();
        return result;
    }

    protected Node toJavaImpl(JifToJavaRewriter rw) throws SemanticException {
        JifClassDecl n = (JifClassDecl)this.node();
        JifPolyType jpt = (JifPolyType)n.type();
        ClassBody cb = n.body();
        if (!jpt.flags().isInterface()) {
            if (!rw.jif_ts().isSignature((Type)jpt)) {
                cb = cb.addMember(this.produceConstructor(jpt, rw));
                if (this.hasDefaultConstructor) {
                    cb = cb.addMember(this.produceDefaultConstructorInvoker(jpt, rw, this.defaultConstructorExceptions));
                }
                cb = this.addInitializer(cb, rw);
                cb = this.addStaticInitializers(cb, rw);
            }
            if (rw.jif_ts().needsDynamicTypeMethods((Type)jpt)) {
                cb = cb.addMember(this.produceInstanceOfMethod(jpt, rw, false));
                cb = cb.addMember(this.produceCastMethod(jpt, rw));
            }
            if (rw.jif_ts().isParamsRuntimeRep((Type)jpt)) {
                if (!jpt.params().isEmpty() && !rw.jif_ts().isSignature((Type)jpt)) {
                    for (ParamInstance pi : jpt.params()) {
                        String paramFieldName = ParamToJavaExpr_c.paramFieldName(pi);
                        TypeNode tn = ClassDeclToJavaExt_c.typeNodeForParam(pi, rw);
                        cb = cb.addMember(rw.qq().parseMember("private final %T %s;", new Object[]{tn, paramFieldName}));
                    }
                }
                cb = this.addInterfaceParamGetters(cb, jpt, jpt, rw);
            }
        } else if (rw.jif_ts().needsImplClass((Type)jpt)) {
            ClassBody implBody = rw.java_nf().ClassBody(Position.compilerGenerated(), new ArrayList(2));
            implBody = implBody.addMember(this.produceInstanceOfMethod(jpt, rw, true));
            implBody = implBody.addMember(this.produceCastMethod(jpt, rw));
            Id name = rw.java_nf().Id(Position.compilerGenerated(), ClassDeclToJavaExt_c.interfaceClassImplName(n.name()));
            ClassDecl implDecl = rw.java_nf().ClassDecl(Position.compilerGenerated(), n.flags().clearInterface().Abstract(), name, null, Collections.emptyList(), implBody);
            rw.addAdditionalClassDecl(implDecl);
            for (ParamInstance pi : jpt.params()) {
                String paramFieldNameGetter = ParamToJavaExpr_c.paramFieldNameGetter(pi);
                TypeNode tn = ClassDeclToJavaExt_c.typeNodeForParam(pi, rw);
                cb = cb.addMember(rw.qq().parseMember("%T %s();", new Object[]{tn, paramFieldNameGetter}));
            }
        }
        return rw.java_nf().ClassDecl(n.position(), n.flags(), n.id(), n.superClass(), n.interfaces(), cb, n.javadoc());
    }

    protected ClassBody addInitializer(ClassBody cb, JifToJavaRewriter rw) {
        ArrayList<Stmt> inits = new ArrayList<Stmt>(rw.getInitializations());
        rw.getInitializations().clear();
        return cb.addMember(rw.qq().parseMember("private void %s() { %LS }", new Object[]{INITIALIZATIONS_METHOD_NAME, inits}));
    }

    protected ClassBody addStaticInitializers(ClassBody cb, JifToJavaRewriter rw) {
        if (rw.getStaticInitializations().isEmpty()) {
            return cb;
        }
        ArrayList<Block> inits = new ArrayList<Block>(rw.getStaticInitializations());
        rw.getStaticInitializations().clear();
        Block b = inits.size() == 1 ? (Block)inits.get(0) : rw.java_nf().Block(Position.compilerGenerated(), inits);
        return cb.addMember((ClassMember)rw.java_nf().Initializer(Position.compilerGenerated(), Flags.STATIC, b));
    }

    protected ClassBody addInterfaceParamGetters(ClassBody cb, JifPolyType baseClass, JifPolyType jpt, JifToJavaRewriter rw) throws SemanticException {
        if (!rw.jif_ts().isParamsRuntimeRep((Type)jpt)) {
            return cb;
        }
        for (Type interf : jpt.interfaces()) {
            if (!rw.jif_ts().isParamsRuntimeRep(interf) || rw.jif_ts().isSubtype(baseClass.superType(), interf)) continue;
            JifPolyType interfPT = null;
            if (interf instanceof JifSubstType) {
                JifSubstType interfST = (JifSubstType)interf;
                JifSubst subst = (JifSubst)interfST.subst();
                interfPT = (JifPolyType)interfST.base();
                for (ParamInstance pi : interfPT.params()) {
                    String paramFieldName = ParamToJavaExpr_c.paramFieldName(pi);
                    String paramFieldNameGetter = ParamToJavaExpr_c.paramFieldNameGetter(pi);
                    TypeNode tn = ClassDeclToJavaExt_c.typeNodeForParam(pi, rw);
                    Expr lblExpr = rw.paramToJava(subst.get(pi));
                    if (!rw.jif_ts().isSignature((Type)jpt)) {
                        cb = cb.addMember(rw.qq().parseMember("private %T %s;", new Object[]{tn, paramFieldName}));
                        cb = cb.addMember(rw.qq().parseMember("public final %T %s() {  if (this.%s==null) this.%s = %E; return this.%s; }", new Object[]{tn, paramFieldNameGetter, paramFieldName, paramFieldName, lblExpr, paramFieldName}));
                        continue;
                    }
                    cb = cb.addMember(rw.qq().parseMember("public final native %T %s();", new Object[]{tn, paramFieldNameGetter}));
                }
            } else if (interf instanceof JifPolyType) {
                interfPT = (JifPolyType)interf;
            }
            if (interfPT == null) continue;
            cb = this.addInterfaceParamGetters(cb, baseClass, interfPT, rw);
        }
        return cb;
    }

    protected ClassMember produceInstanceOfMethod(JifPolyType jpt, JifToJavaRewriter rw, boolean useGetters) throws SemanticException {
        Context A = rw.context();
        rw = (JifToJavaRewriter)rw.context(A.pushStatic());
        JifTypeSystem jifts = rw.jif_ts();
        List<Formal> formals = this.produceFormals(jpt, rw);
        String name = jpt.name();
        if (jifts.isSignature((Type)jpt)) {
            return rw.qq().parseMember("static public native boolean %s(%LF);", new Object[]{INSTANCEOF_METHOD_NAME, formals});
        }
        StringBuffer sb = new StringBuffer();
        sb.append("static public boolean %s(%LF) {");
        if (jpt.params().isEmpty()) {
            sb.append("return (o instanceof %s);");
        } else {
            sb.append("if (o instanceof %s) { ");
            sb.append("%s c = (%s)o; ");
            boolean moreThanOneParam = jpt.params().size() > 1;
            sb.append(moreThanOneParam ? "boolean ok = true;" : "");
            for (ParamInstance pi : jpt.params()) {
                String paramFieldName = ParamToJavaExpr_c.paramFieldName(pi);
                String paramArgName = ParamToJavaExpr_c.paramArgName(pi);
                String comparison = "equivalentTo";
                if (pi.isCovariantLabel()) {
                    comparison = "relabelsTo";
                }
                sb.append(moreThanOneParam ? "ok = ok && " : "return ");
                String paramExpr = paramFieldName;
                if (useGetters) {
                    paramExpr = ParamToJavaExpr_c.paramFieldNameGetter(pi) + "()";
                }
                if (pi.isPrincipal()) {
                    sb.append(jifts.PrincipalUtilClassName() + "." + comparison + "(c." + paramExpr + "," + paramArgName + ");");
                    continue;
                }
                sb.append(rw.runtimeLabelUtil() + "." + comparison + "(c." + paramExpr + "," + paramArgName + ");");
            }
            if (moreThanOneParam) {
                sb.append("return ok;");
            }
            sb.append("}");
            sb.append("return false;");
        }
        sb.append("}");
        return rw.qq().parseMember(sb.toString(), new Object[]{INSTANCEOF_METHOD_NAME, formals, name, name, name});
    }

    private static TypeNode typeNodeForParam(ParamInstance pi, JifToJavaRewriter rw) throws SemanticException {
        PrimitiveType paramType = pi.isPrincipal() ? rw.jif_ts().Principal() : rw.jif_ts().Label();
        return rw.typeToJava((Type)paramType, Position.compilerGenerated());
    }

    protected ClassMember produceCastMethod(JifPolyType jpt, JifToJavaRewriter rw) throws SemanticException {
        Context A = rw.context();
        rw = (JifToJavaRewriter)rw.context(A.pushStatic());
        TypeNode tn = rw.typeToJava((Type)jpt, Position.compilerGenerated());
        List<Formal> formals = this.produceFormals(jpt, rw);
        if (rw.jif_ts().isSignature((Type)jpt)) {
            return rw.qq().parseMember("static public native %T %s(%LF);", new Object[]{tn, ClassDeclToJavaExt_c.castMethodName(jpt), formals});
        }
        StringBuffer sb = new StringBuffer();
        sb.append("static public %T %s(%LF) {");
        sb.append("if (o == null) return null;");
        sb.append("if (%s(%LE)) return (%T)o;");
        sb.append("throw new ClassCastException();");
        sb.append("}");
        List<Expr> args = this.produceParamArgs(jpt, rw);
        return rw.qq().parseMember(sb.toString(), new Object[]{tn, ClassDeclToJavaExt_c.castMethodName(jpt), formals, INSTANCEOF_METHOD_NAME, args, tn});
    }

    protected List<Formal> produceFormals(JifPolyType jpt, JifToJavaRewriter rw) throws SemanticException {
        ArrayList<Formal> formals = new ArrayList<Formal>(jpt.params().size() + 1);
        Position pos = Position.compilerGenerated();
        for (ParamInstance pi : jpt.params()) {
            Id paramArgName = rw.java_nf().Id(pos, ParamToJavaExpr_c.paramArgName(pi));
            TypeNode tn = ClassDeclToJavaExt_c.typeNodeForParam(pi, rw);
            Formal f = rw.java_nf().Formal(pos, Flags.FINAL, tn, paramArgName);
            formals.add(f);
        }
        formals.add(this.produceObjectFormal(jpt, rw));
        return formals;
    }

    protected Formal produceObjectFormal(JifPolyType jpt, JifToJavaRewriter rw) {
        Position pos = Position.compilerGenerated();
        TypeNode tn = rw.qq().parseType("java.lang.Object", new Object[0]);
        Id id = rw.java_nf().Id(pos, "o");
        return rw.java_nf().Formal(pos, Flags.FINAL, tn, id);
    }

    protected static List<Formal> produceParamFormals(JifPolyType jpt, JifToJavaRewriter rw) throws SemanticException {
        ArrayList<Formal> formals = new ArrayList<Formal>(jpt.params().size() + 1);
        Position pos = Position.compilerGenerated();
        for (ParamInstance pi : jpt.params()) {
            Id paramArgName = rw.java_nf().Id(pos, ParamToJavaExpr_c.paramArgName(pi));
            TypeNode tn = ClassDeclToJavaExt_c.typeNodeForParam(pi, rw);
            Formal f = rw.java_nf().Formal(pos, Flags.FINAL, tn, paramArgName);
            formals.add(f);
        }
        return formals;
    }

    protected List<Expr> produceParamArgs(JifPolyType jpt, JifToJavaRewriter rw) {
        ArrayList<Expr> args = new ArrayList<Expr>(jpt.params().size() + 1);
        for (ParamInstance pi : jpt.params()) {
            String paramArgName = ParamToJavaExpr_c.paramArgName(pi);
            args.add(rw.qq().parseExpr(paramArgName, new Object[0]));
        }
        args.add(rw.qq().parseExpr("o", new Object[0]));
        return args;
    }

    protected ClassMember produceConstructor(JifPolyType jpt, JifToJavaRewriter rw) throws SemanticException {
        List<Formal> formals = ClassDeclToJavaExt_c.produceParamFormals(jpt, rw);
        ArrayList<Stmt> inits = new ArrayList<Stmt>();
        ArrayList<Expr> superArgs = new ArrayList<Expr>();
        Type superType = jpt.superType();
        if (superType instanceof JifSubstType && rw.jif_ts().isParamsRuntimeRep(((JifSubstType)superType).base())) {
            JifSubstType superjst = (JifSubstType)jpt.superType();
            JifPolyType superjpt = (JifPolyType)superjst.base();
            JifContext A = (JifContext)rw.context();
            JifToJavaRewriter rwCons = (JifToJavaRewriter)rw.context(A.pushConstructorCall());
            Expr thisQualifier = rw.qq().parseExpr("this", new Object[0]);
            for (ParamInstance pi : superjpt.params()) {
                Param param = ((JifSubst)superjst.subst()).get(pi);
                if (pi.isLabel()) {
                    superArgs.add(((Label)param).toJava(rwCons, thisQualifier));
                    continue;
                }
                superArgs.add(((Principal)param).toJava(rwCons, thisQualifier));
            }
        }
        inits.add(rw.qq().parseStmt("super(%LE);", new Object[]{superArgs}));
        for (ParamInstance pi : jpt.params()) {
            String paramFieldName = ParamToJavaExpr_c.paramFieldName(pi);
            String paramArgName = ParamToJavaExpr_c.paramArgName(pi);
            inits.add(rw.qq().parseStmt("this." + paramFieldName + " = " + paramArgName + ";", new Object[0]));
        }
        inits.addAll(this.additionalConstructorCode(rw));
        Id name = rw.java_nf().Id(Position.compilerGenerated(), jpt.name());
        return rw.java_nf().ConstructorDecl(Position.compilerGenerated(), Flags.PUBLIC, name, formals, Collections.emptyList(), rw.java_nf().Block(Position.compilerGenerated(), inits));
    }

    protected List<Stmt> additionalConstructorCode(JifToJavaRewriter rw) {
        return Collections.emptyList();
    }

    protected ClassMember produceDefaultConstructorInvoker(ClassType ct, JifToJavaRewriter rw, List<? extends Type> throwTypes) {
        if (throwTypes == null || throwTypes.isEmpty()) {
            return rw.qq().parseMember("public void jif$invokeDefConstructor() {this." + ClassDeclToJavaExt_c.constructorTranslatedName(ct) + "();" + "}", new Object[0]);
        }
        ArrayList<AmbTypeNode> typeNodes = new ArrayList<AmbTypeNode>(throwTypes.size());
        for (Type type : throwTypes) {
            Id name = rw.java_nf().Id(Position.compilerGenerated(), type.toClass().name());
            AmbTypeNode tn = rw.java_nf().AmbTypeNode(Position.compilerGenerated(), name);
            typeNodes.add(tn);
        }
        return rw.qq().parseMember("public void jif$invokeDefConstructor() throws %LT {this." + ClassDeclToJavaExt_c.constructorTranslatedName(ct) + "();" + "}", new Object[]{typeNodes});
    }
}

