/*
 * Decompiled with CFR 0.152.
 */
package jif.translate;

import jif.extension.JifBinaryDel;
import jif.translate.ExprToJavaExt_c;
import jif.translate.JifToJavaRewriter;
import jif.types.JifTypeSystem;
import polyglot.ast.Binary;
import polyglot.ast.Expr;
import polyglot.ast.Precedence;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;

public class BinaryToJavaExt_c
extends ExprToJavaExt_c {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private Type lhsType;

    @Override
    public NodeVisitor toJavaEnter(JifToJavaRewriter rw) throws SemanticException {
        Binary b = (Binary)this.node();
        this.lhsType = b.left().type();
        return super.toJavaEnter(rw);
    }

    @Override
    public Expr exprToJava(JifToJavaRewriter rw) throws SemanticException {
        Binary b = (Binary)this.node();
        JifTypeSystem ts = (JifTypeSystem)rw.typeSystem();
        if (b.operator() == JifBinaryDel.ACTSFOR) {
            return this.actsforToJava(rw, false);
        }
        if (b.operator() == JifBinaryDel.EQUIV) {
            if (ts.isImplicitCastValid(this.lhsType, (Type)ts.Principal())) {
                return this.actsforToJava(rw, true);
            }
            if (ts.isLabel(this.lhsType)) {
                return this.labelTestToJava(rw, true);
            }
        }
        if (b.operator() == Binary.LE && ts.isLabel(this.lhsType)) {
            return this.labelTestToJava(rw, false);
        }
        Precedence precedence = b.precedence();
        b = rw.java_nf().Binary(b.position(), b.left(), b.operator(), b.right());
        b = b.precedence(precedence);
        return b;
    }

    public Expr actsforToJava(JifToJavaRewriter rw, boolean isEquiv) throws SemanticException {
        JifTypeSystem ts = rw.jif_ts();
        Binary b = (Binary)this.node();
        String className = ts.isLabel(this.lhsType) ? rw.runtimeLabelUtil() : ts.PrincipalUtilClassName();
        String meth = isEquiv ? "equivalentTo" : "actsFor";
        String comparison = className + "." + meth + "((%E), (%E))";
        return rw.qq().parseExpr(comparison, new Object[]{b.left(), b.right()});
    }

    public Expr labelTestToJava(JifToJavaRewriter rw, boolean isEquiv) throws SemanticException {
        Binary b = (Binary)this.node();
        String meth = isEquiv ? "equivalentTo" : "relabelsTo";
        String comparison = rw.runtimeLabelUtil() + "." + meth + "((%E), (%E))";
        return rw.qq().parseExpr(comparison, new Object[]{b.left(), b.right()});
    }
}

