/*
 * Decompiled with CFR 0.152.
 */
package jif.parse;

import java.util.Collections;
import java.util.LinkedList;
import jif.ast.AmbNewArray;
import jif.ast.ParamNode;
import jif.parse.Access;
import jif.parse.Amb;
import jif.parse.Array;
import jif.parse.Grm;
import jif.parse.Inst;
import jif.parse.Name;
import jif.parse.UnwrapVisitor;
import polyglot.ast.Expr;
import polyglot.ast.Labeled;
import polyglot.ast.NewArray;
import polyglot.ast.Prefix;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class InstOrAccess
extends Amb {
    Amb prefix;
    Object param;

    public InstOrAccess(Grm parser, Position pos, Amb prefix, Object param) throws Exception {
        super(parser, pos);
        this.prefix = prefix;
        this.param = param;
        if (!(param instanceof Name) && !(param instanceof Expr)) {
            parser.die(pos);
        }
        if (prefix instanceof Labeled) {
            parser.die(pos);
        }
        if (prefix instanceof Array) {
            parser.die(pos);
        }
    }

    public Amb prefix() {
        return this.prefix;
    }

    public Object param() {
        return this.param;
    }

    @Override
    public TypeNode toType() throws Exception {
        LinkedList<ParamNode> l = new LinkedList<ParamNode>();
        if (this.param instanceof Name) {
            l.add(this.parser.nf.AmbParam(((Name)this.param).pos, ((Name)this.param).toIdentifier()));
        } else {
            l.add(this.parser.nf.AmbParam(((Expr)this.param).position(), (Expr)this.param, null));
        }
        return this.parser.nf.InstTypeNode(this.pos, this.prefix.toUnlabeledType(), l);
    }

    @Override
    public TypeNode toUnlabeledType() throws Exception {
        return this.toType();
    }

    @Override
    public Prefix toPrefix() throws Exception {
        return this.toReceiver();
    }

    @Override
    public Receiver toReceiver() throws Exception {
        return this.parser.nf.AmbParamTypeOrAccess(this.pos, this.prefix.toReceiver(), this.paramToExprOrString());
    }

    private Expr paramToExpr() throws Exception {
        if (this.param instanceof Expr) {
            this.param = ((Expr)this.param).visit((NodeVisitor)new UnwrapVisitor());
            return (Expr)this.param;
        }
        return this.parser.nf.AmbExpr(((Name)this.param).pos, ((Name)this.param).toIdentifier());
    }

    @Override
    public Expr toExpr() throws Exception {
        return this.parser.nf.ArrayAccess(this.pos, this.prefix.toExpr(), this.paramToExpr());
    }

    @Override
    public Expr toNewArray(Position p, Integer extraDims) throws Exception {
        Access a = new Access(this.parser, this.pos, this.prefix, this.paramToExpr());
        return a.toNewArray(p, extraDims);
    }

    private Object paramToExprOrString() throws Exception {
        if (this.param instanceof Name) {
            return ((Name)this.param).toIdentifier();
        }
        this.param = ((Expr)this.param).visit((NodeVisitor)new UnwrapVisitor());
        return this.param;
    }

    @Override
    public Expr toNewArrayPrefix(Position p, Integer extraDims) throws Exception {
        if (this.prefix instanceof Name) {
            return this.parser.nf.AmbNewArray(p, this.prefix.toType(), this.paramToExprOrString(), Collections.emptyList(), extraDims);
        }
        if (this.prefix instanceof Inst) {
            LinkedList<Expr> dims = new LinkedList<Expr>();
            dims.add(this.paramToExpr());
            return this.parser.nf.NewArray(p, this.prefix.toType(), dims);
        }
        if (this.prefix instanceof Access || this.prefix instanceof InstOrAccess) {
            Expr e = this.prefix.toNewArrayPrefix(p, extraDims);
            if (e instanceof NewArray) {
                NewArray a = (NewArray)e;
                LinkedList<Expr> dims = new LinkedList<Expr>(a.dims());
                dims.add(this.paramToExpr());
                return a.dims(dims);
            }
            if (e instanceof AmbNewArray) {
                AmbNewArray a = (AmbNewArray)e;
                LinkedList<? extends Expr> dims = new LinkedList<Expr>(a.dims());
                dims.add((Expr)this.paramToExpr());
                return a.dims(dims);
            }
        }
        this.parser.die(this.pos);
        return null;
    }
}

