/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.Param;
import jif.types.PathMap;
import jif.types.SemanticDetailedException;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathField;
import jif.types.label.AccessPathLocal;
import jif.types.label.ConfProjectionPolicy_c;
import jif.types.label.DynamicLabel;
import jif.types.label.IntegProjectionPolicy_c;
import jif.types.label.JoinLabel;
import jif.types.label.JoinPolicy_c;
import jif.types.label.Label;
import jif.types.label.MeetLabel;
import jif.types.label.MeetPolicy_c;
import jif.types.label.PairLabel;
import jif.types.label.Policy;
import jif.types.label.ReaderPolicy;
import jif.types.label.VarLabel;
import jif.types.label.WriterPolicy;
import jif.types.principal.ConjunctivePrincipal;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import jif.types.principal.VarPrincipal;
import jif.visit.LabelChecker;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.TypeChecker;

public class LabelTypeCheckUtil {
    protected final JifTypeSystem ts;

    public LabelTypeCheckUtil(JifTypeSystem ts) {
        this.ts = ts;
    }

    public void typeCheckPrincipal(TypeChecker tc, Principal principal) throws SemanticException {
        Principal p;
        if (principal instanceof DynamicPrincipal) {
            DynamicPrincipal dp = (DynamicPrincipal)principal;
            AccessPath path = dp.path();
            try {
                path.verify((JifContext)tc.context());
            }
            catch (SemanticException e) {
                throw new SemanticException(e.getMessage(), principal.position());
            }
            if (!this.ts.isImplicitCastValid(dp.path().type(), (Type)this.ts.Principal())) {
                throw new SemanticDetailedException("The type of a dynamic principal must be \"principal\".", "The type of a dynamic principal must be \"principal\". The type of the expression " + dp.path().exprString() + " is " + dp.path().type() + ".", principal.position());
            }
        }
        if (principal instanceof ConjunctivePrincipal) {
            p = (ConjunctivePrincipal)principal;
            for (Principal q : p.conjuncts()) {
                this.typeCheckPrincipal(tc, q);
            }
        }
        if (principal instanceof DisjunctivePrincipal) {
            p = (DisjunctivePrincipal)principal;
            for (Principal q : p.disjuncts()) {
                this.typeCheckPrincipal(tc, q);
            }
        }
    }

    public void typeCheckLabel(final TypeChecker tc, Label Lbl) throws SemanticException {
        Lbl.subst(new LabelSubstitution(){

            @Override
            public Label substLabel(Label l) throws SemanticException {
                if (l instanceof DynamicLabel) {
                    DynamicLabel dl = (DynamicLabel)l;
                    AccessPath path = dl.path();
                    try {
                        path.verify((JifContext)tc.context());
                    }
                    catch (SemanticException e) {
                        throw new SemanticException(e.getMessage(), dl.position());
                    }
                    if (!LabelTypeCheckUtil.this.ts.isLabel(dl.path().type())) {
                        throw new SemanticDetailedException("The type of a dynamic label must be \"label\".", "The type of a dynamic label must be \"label\". The type of the expression " + dl.path().exprString() + " is " + dl.path().type() + ".", dl.position());
                    }
                } else if (l instanceof PairLabel) {
                    PairLabel pl = (PairLabel)l;
                    LabelTypeCheckUtil.this.typeCheckPolicy(tc, pl.confPolicy());
                    LabelTypeCheckUtil.this.typeCheckPolicy(tc, pl.integPolicy());
                }
                return l;
            }
        });
    }

    public Collection<Label> labelComponents(Label L) {
        if (L instanceof JoinLabel) {
            return ((JoinLabel)L).joinComponents();
        }
        if (L instanceof MeetLabel) {
            return ((MeetLabel)L).meetComponents();
        }
        return Collections.singleton(L);
    }

    public void typeCheckPolicy(TypeChecker tc, Policy p) throws SemanticException {
        if (p instanceof ConfProjectionPolicy_c) {
            ConfProjectionPolicy_c cpp = (ConfProjectionPolicy_c)p;
            this.typeCheckLabel(tc, cpp.label());
        } else if (p instanceof IntegProjectionPolicy_c) {
            IntegProjectionPolicy_c ipp = (IntegProjectionPolicy_c)p;
            this.typeCheckLabel(tc, ipp.label());
        } else if (p instanceof JoinPolicy_c) {
            JoinPolicy_c jp = (JoinPolicy_c)p;
            Collection joinComponents = jp.joinComponents();
            for (Policy pol : joinComponents) {
                this.typeCheckPolicy(tc, pol);
            }
        } else if (p instanceof MeetPolicy_c) {
            MeetPolicy_c mp = (MeetPolicy_c)p;
            Collection meetComponents = mp.meetComponents();
            for (Policy pol : meetComponents) {
                this.typeCheckPolicy(tc, pol);
            }
        } else if (p instanceof ReaderPolicy) {
            ReaderPolicy pol = (ReaderPolicy)p;
            this.typeCheckPrincipal(tc, pol.owner());
            this.typeCheckPrincipal(tc, pol.reader());
        } else if (p instanceof WriterPolicy) {
            WriterPolicy pol = (WriterPolicy)p;
            this.typeCheckPrincipal(tc, pol.owner());
            this.typeCheckPrincipal(tc, pol.writer());
        } else {
            throw new InternalCompilerError("Unexpected policy " + p);
        }
    }

    public void typeCheckType(TypeChecker tc, Type t) throws SemanticException {
        if ((t = this.ts.unlabel(t)) instanceof JifSubstType) {
            JifSubstType jct = (JifSubstType)t;
            for (Param arg : jct.actuals()) {
                if (arg instanceof Label) {
                    Label L = (Label)arg;
                    this.typeCheckLabel(tc, L);
                    continue;
                }
                if (arg instanceof Principal) {
                    Principal p = (Principal)arg;
                    this.typeCheckPrincipal(tc, p);
                    continue;
                }
                throw new InternalCompilerError("Unexpected type for entry: " + arg.getClass().getName());
            }
        }
    }

    public PathMap labelCheckType(Type t, LabelChecker lc, List<Type> throwTypes, Position pos) throws SemanticException {
        JifContext A = lc.context();
        PathMap X = this.ts.pathMap().N(A.pc());
        List<PathMap> Xparams = this.labelCheckTypeParams(t, lc, throwTypes, pos);
        for (PathMap Xj : Xparams) {
            X = X.join(Xj);
        }
        return X;
    }

    public List<PathMap> labelCheckTypeParams(Type t, LabelChecker lc, List<Type> throwTypes, Position pos) throws SemanticException {
        List<PathMap> Xparams;
        if ((t = this.ts.unlabel(t)) instanceof JifSubstType) {
            JifContext A = lc.context();
            PathMap X = this.ts.pathMap().N(A.pc());
            JifSubstType jst = (JifSubstType)t;
            Xparams = new ArrayList<PathMap>(jst.subst().substitutions().size());
            JifSubstType jct = jst;
            for (Param arg : jct.actuals()) {
                PathMap Xj;
                if (arg instanceof Label) {
                    Label L = (Label)arg;
                    A = (JifContext)A.pushBlock();
                    if (!(!this.ts.isParamsRuntimeRep(t) || L.isRuntimeRepresentable() || L instanceof VarLabel && ((VarLabel)L).mustRuntimeRepresentable())) {
                        throw new SemanticDetailedException("A label used in a type examined at runtime must be representable at runtime.", "If a type is used in an instanceof, cast, constructor call, or static method call, all parameters of the type must be runtime representable. Arg labels are not represented at runtime.", pos);
                    }
                    this.updateContextForParam(lc, A, X);
                    Xj = L.labelCheck(A, lc);
                    throwTypes.removeAll(L.throwTypes((TypeSystem)this.ts));
                    Xparams.add(Xj);
                    X = X.join(Xj);
                    A = (JifContext)A.pop();
                    continue;
                }
                if (arg instanceof Principal) {
                    Principal p = (Principal)arg;
                    A = (JifContext)A.pushBlock();
                    if (!(!this.ts.isParamsRuntimeRep(t) || p.isRuntimeRepresentable() || p instanceof VarPrincipal && ((VarPrincipal)p).mustRuntimeRepresentable())) {
                        throw new SemanticDetailedException("A principal used in a type examined at runtime must be representable at runtime.", "If a type is used in an instanceof, cast, constructor call, or static method call, all parameters of the type must be runtime representable. The principal " + p + " is not " + "represented at runtime.", pos);
                    }
                    this.updateContextForParam(lc, A, X);
                    Xj = p.labelCheck(A, lc);
                    throwTypes.removeAll(p.throwTypes((TypeSystem)this.ts));
                    Xparams.add(Xj);
                    X = X.join(Xj);
                    A = (JifContext)A.pop();
                    continue;
                }
                throw new InternalCompilerError("Unexpected type for entry: " + arg.getClass().getName());
            }
        } else {
            Xparams = Collections.emptyList();
        }
        return Xparams;
    }

    protected void updateContextForParam(LabelChecker lc, JifContext A, PathMap Xprev) {
        A.setPc(Xprev.N(), lc);
    }

    public List<Type> throwTypes(JifClassType type) {
        Type t = this.ts.unlabel((Type)type);
        if (t instanceof JifSubstType && this.ts.isParamsRuntimeRep(t)) {
            JifSubstType jct = (JifSubstType)t;
            ArrayList<Type> exc = new ArrayList<Type>();
            for (Param arg : jct.actuals()) {
                if (arg instanceof Label) {
                    exc.addAll(((Label)arg).throwTypes((TypeSystem)this.ts));
                    continue;
                }
                if (arg instanceof Principal) {
                    exc.addAll(((Principal)arg).throwTypes((TypeSystem)this.ts));
                    continue;
                }
                throw new InternalCompilerError("Unexpected type for entry: " + arg.getClass().getName());
            }
            return exc;
        }
        return Collections.emptyList();
    }

    public Set<LocalInstance> localInstancesUsed(JifClassType type) {
        Type t = this.ts.unlabel((Type)type);
        if (t instanceof JifSubstType) {
            LinkedHashSet<LocalInstance> lis = new LinkedHashSet<LocalInstance>();
            for (Param arg : type.actuals()) {
                AccessPath p = null;
                if (arg instanceof DynamicLabel) {
                    p = ((DynamicLabel)arg).path();
                } else if (arg instanceof DynamicPrincipal) {
                    p = ((DynamicPrincipal)arg).path();
                }
                while (p != null && p instanceof AccessPathField) {
                    p = ((AccessPathField)p).path();
                }
                if (!(p instanceof AccessPathLocal)) continue;
                lis.add(((AccessPathLocal)p).localInstance());
            }
            return lis;
        }
        return Collections.emptySet();
    }
}

