/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.List;
import jif.ast.JifNew_c;
import jif.extension.CallHelper;
import jif.extension.ConstructorChecker;
import jif.extension.JifExprExt;
import jif.extension.JifNewDel;
import jif.extension.LabelTypeCheckUtil;
import jif.translate.ToJavaExt;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifFieldInstance;
import jif.types.JifProcedureInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.Param;
import jif.types.PathMap;
import jif.types.label.AccessPathField;
import jif.types.label.DynamicLabel;
import jif.types.label.Label;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import jif.visit.JifTypeChecker;
import jif.visit.LabelChecker;
import polyglot.ast.Expr;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class JifNewExt
extends JifExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected ConstructorChecker constructorChecker = new ConstructorChecker();
    protected CallHelper helper;

    public JifNewExt(ToJavaExt toJava) {
        super(toJava);
    }

    public New node() {
        return (New)super.node();
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        JifTypeChecker jtc = (JifTypeChecker)this.superLang().typeCheckEnter((Node)this.node(), tc);
        return jtc.inferClassParameters(true);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JifNew_c n = (JifNew_c)this.superLang().typeCheck((Node)this.node(), tc);
        Type t = n.objectType().type();
        LabelTypeCheckUtil ltcu = ((JifTypeSystem)tc.typeSystem()).labelTypeCheckUtil();
        ltcu.typeCheckType(tc, t);
        n = (JifNew_c)n.type(t);
        return n;
    }

    public List<Type> throwTypes(TypeSystem ts) {
        New node = this.node();
        ArrayList<Type> ex = new ArrayList<Type>(this.superLang().throwTypes((Node)this.node(), ts));
        LabelTypeCheckUtil ltcu = ((JifTypeSystem)ts).labelTypeCheckUtil();
        if (node.objectType().type() instanceof JifClassType) {
            ex.addAll(ltcu.throwTypes((JifClassType)node.objectType().type()));
        }
        return ex;
    }

    @Override
    public Node labelCheck(LabelChecker lc) throws SemanticException {
        New noe = this.node();
        JifTypeSystem ts = lc.typeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)noe.del().enterScope((Context)A);
        ArrayList<Type> throwTypes = new ArrayList<Type>(noe.del().throwTypes((TypeSystem)ts));
        ClassType ct = (ClassType)ts.unlabel(noe.type());
        if (ct != null && ct.fields() != null) {
            for (FieldInstance fi : ct.fields()) {
                JifFieldInstance jfi = (JifFieldInstance)fi;
                if (!jfi.flags().isFinal() || !jfi.flags().isStatic() || !jfi.hasInitializer()) continue;
                AccessPathField path = (AccessPathField)ts.varInstanceToAccessPath(jfi, jfi.position());
                Param init = jfi.initializer();
                if (ts.isLabel(jfi.type())) {
                    DynamicLabel dl = ts.dynamicLabel(jfi.position(), path);
                    Label rhs_label = (Label)init;
                    if (rhs_label == null) {
                        throw new InternalCompilerError("FinalParams has not run yet");
                    }
                    A.addDefinitionalAssertionEquiv(dl, rhs_label, true);
                    continue;
                }
                if (!ts.isImplicitCastValid(jfi.type(), (Type)ts.Principal())) continue;
                DynamicPrincipal dp = ts.dynamicPrincipal(jfi.position(), path);
                Principal rhs_principal = (Principal)init;
                if (rhs_principal == null) {
                    throw new InternalCompilerError("FinalParams has not run yet");
                }
                A.addDefinitionalEquiv(dp, rhs_principal);
            }
        }
        this.constructorChecker.checkConstructorAuthority(ct, A, lc, noe.position());
        Label newLabel = null;
        boolean npExc = false;
        if (noe.qualifier() == null) {
            newLabel = ts.freshLabelVariable(noe.position(), "new" + ct.name(), "label of the reference to the newly created " + ct.name() + " object, at " + noe.position());
        } else {
            Expr e = (Expr)lc.labelCheck((Node)noe.qualifier());
            if (e.type() == null) {
                throw new InternalCompilerError("Type of " + e + " is null", e.position());
            }
            PathMap Xs = JifNewExt.getPathMap((Node)e);
            if (Xs == null) {
                throw new InternalCompilerError("No entry for " + e);
            }
            this.updateContextPostTarget(lc, A, Xs);
            if (!(e instanceof Special)) {
                npExc = !((JifNewDel)this.node().del()).qualIsNeverNull();
                newLabel = Xs.NV();
                this.updateContextPostTargetExpr(lc, A, Xs);
            } else {
                newLabel = ((JifClassType)lc.context().currentClass()).thisLabel();
            }
        }
        if (ts.isLabeled(noe.type())) {
            lc.constrain(new NamedLabel("new_label", "label of the reference to the newly created " + ct.name(), newLabel), LabelConstraint.EQUAL, new NamedLabel("declared_label", "declared label of the newly created " + ct.name(), ts.labelOfType(noe.type())), A.labelEnv(), noe.position());
        }
        this.helper = lc.createCallHelper(newLabel, (Receiver)noe, (ReferenceType)ct, (JifProcedureInstance)noe.constructorInstance(), noe.arguments(), this.node().position());
        LabelChecker callLC = lc.context(A);
        noe = this.helper.checkCall(callLC, throwTypes, noe, npExc);
        PathMap retX = this.helper.X();
        PathMap X = retX.NV(lc.upperBound(retX.NV(), newLabel));
        JifNewExt.checkThrowTypes(throwTypes);
        return JifNewExt.updatePathMap((Node)noe.arguments(this.helper.labelCheckedArgs()), X);
    }

    protected void updateContextPostTarget(LabelChecker lc, JifContext A, PathMap Xtarg) {
        A.setPc(Xtarg.N(), lc);
    }

    protected void updateContextPostTargetExpr(LabelChecker lc, JifContext A, PathMap Xtarg) {
        A.setPc(Xtarg.NV(), lc);
    }
}

