/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jif.ast.JifUtil;
import jif.extension.JifArrayInitExt;
import jif.extension.JifExprExt;
import jif.extension.JifNewArrayDel;
import jif.translate.ToJavaExt;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.visit.IntegerBoundsChecker;
import jif.visit.LabelChecker;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.SerialVersionUID;

public class JifNewArrayExt
extends JifExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifNewArrayExt(ToJavaExt toJava) {
        super(toJava);
    }

    @Override
    public Node labelCheck(LabelChecker lc) throws SemanticException {
        JifTypeSystem ts = lc.jifTypeSystem();
        NewArray nae = (NewArray)this.node();
        ArrayList<Type> throwTypes = new ArrayList<Type>(nae.del().throwTypes((TypeSystem)ts));
        JifContext A = lc.jifContext();
        A = (JifContext)nae.del().enterScope((Context)A);
        A = (JifContext)A.pushBlock();
        PathMap Xs = ts.pathMap();
        Xs = Xs.N(A.pc());
        LinkedList<Expr> dims = new LinkedList<Expr>();
        Label dimsNV = ts.bottomLabel();
        for (Expr e : nae.dims()) {
            e = (Expr)lc.context(A).labelCheck((Node)e);
            dims.add(e);
            PathMap Xe = JifNewArrayExt.getPathMap((Node)e);
            Xs = Xs.N(ts.notTaken()).join(Xe);
            this.updateContextForDims(lc, A, Xs);
            dimsNV = ts.join(dimsNV, Xe.NV());
        }
        ArrayInit init = null;
        if (nae.init() != null) {
            init = (ArrayInit)lc.context(A).labelCheck((Node)nae.init());
            ((JifArrayInitExt)JifUtil.jifExt((Node)init)).labelCheckElements(lc, nae.type());
            PathMap Xinit = JifNewArrayExt.getPathMap((Node)init);
            Xs = Xs.N(ts.notTaken()).join(Xinit);
        }
        if (!((JifNewArrayDel)this.node().del()).noNegArraySizeExcThrown()) {
            Type nase = ts.typeForName("java.lang.NegativeArraySizeException");
            JifNewArrayExt.checkAndRemoveThrowType(throwTypes, nase);
            Xs = Xs.exc(dimsNV, nase);
        }
        A = (JifContext)A.pop();
        JifNewArrayExt.checkThrowTypes(throwTypes);
        return JifNewArrayExt.updatePathMap((Node)nae.dims(dims).init(init), Xs);
    }

    @Override
    public void integerBoundsCalculated() {
        super.integerBoundsCalculated();
        boolean noNegArraySizeExcThrown = this.noNegArraySizeExcThrown();
        if (noNegArraySizeExcThrown) {
            JifNewArrayDel del = (JifNewArrayDel)this.node().del();
            del.setNoNegArraySizeExcThrown();
        }
    }

    private boolean noNegArraySizeExcThrown() {
        NewArray na = (NewArray)this.node();
        List dims = na.dims();
        if (dims == null) {
            return true;
        }
        for (Expr d : dims) {
            JifExprExt ext = (JifExprExt)JifUtil.jifExt((Node)d);
            IntegerBoundsChecker.Interval bounds = ext.getNumericBounds();
            if (bounds != null && bounds.getLower() >= 0L) continue;
            return false;
        }
        return true;
    }

    protected void updateContextForDims(LabelChecker lc, JifContext A, PathMap Xprev) {
        A.setPc(Xprev.N(), lc);
    }
}

