/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.List;
import jif.extension.JifAssignDel;
import jif.extension.JifAssignExt;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.SerialVersionUID;

public class JifLocalAssignExt
extends JifAssignExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifLocalAssignExt(ToJavaExt toJava) {
        super(toJava);
    }

    @Override
    public Node labelCheckLHS(LabelChecker lc) throws SemanticException {
        PathMap X;
        Assign assign = (Assign)this.node();
        Local lve = (Local)assign.left();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)lve.del().enterScope((Context)A);
        ArrayList<Type> throwTypes = new ArrayList<Type>(assign.del().throwTypes((TypeSystem)ts));
        final LocalInstance li = lve.localInstance();
        Label L = ts.labelOfLocal(li, A.pc());
        Expr rhs = (Expr)lc.context(A).labelCheck((Node)assign.right());
        PathMap Xr = this.rhsPathMap(lc.context(A), rhs, throwTypes);
        if (assign.operator() != Assign.ASSIGN) {
            PathMap Xv = ts.pathMap();
            Xv = Xv.N(A.pc());
            Xv = Xv.NV(lc.upperBound(L, A.pc()));
            if (((JifAssignDel)assign.del()).throwsArithmeticException()) {
                ClassType arithExc = ts.ArithmeticException();
                JifLocalAssignExt.checkAndRemoveThrowType(throwTypes, (Type)arithExc);
                X = Xv.join(Xr).exc(Xr.NV(), (Type)arithExc);
            } else {
                X = Xv.join(Xr);
            }
        } else {
            X = Xr;
        }
        lc.constrain(new NamedLabel("rhs.nv", "label of successful evaluation of right hand of assignment", X.NV()), LabelConstraint.LEQ, new NamedLabel("label of var " + li.name(), L), A.labelEnv(), lve.position(), new ConstraintMessage(){

            @Override
            public String msg() {
                return "Label of right hand side not less restrictive than the label for local variable " + li.name();
            }

            @Override
            public String detailMsg() {
                return "More information is revealed by the successful evaluation of the right hand side of the assignment than is allowed to flow to the local variable " + li.name() + ".";
            }

            @Override
            public String technicalMsg() {
                return "Invalid assignment: path NV of rhs is not less restrictive than the declared label of the local variable <" + li.name() + ">.";
            }
        });
        Expr lhs = (Expr)JifLocalAssignExt.updatePathMap((Node)lve, X);
        JifLocalAssignExt.checkThrowTypes(throwTypes);
        return JifLocalAssignExt.updatePathMap((Node)assign.right(rhs).left(lhs), X);
    }

    protected PathMap rhsPathMap(LabelChecker lc, Expr rhs, List<Type> throwTypes) {
        return JifLocalAssignExt.getPathMap((Node)rhs);
    }
}

