/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.ast.LabelNode;
import jif.ast.LabeledTypeNode;
import jif.extension.JifDel_c;
import jif.extension.JifLocalDeclDel;
import jif.types.JifLocalInstance;
import jif.types.JifTypeSystem;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.types.ArrayType;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class JifFormalDel
extends JifDel_c {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private boolean isCatchFormal = false;
    private boolean explicitFinalFlag = false;

    public void setIsCatchFormal(boolean isCatchFormal) {
        this.isCatchFormal = isCatchFormal;
    }

    public boolean isCatchFormal() {
        return this.isCatchFormal;
    }

    public boolean hasExplicitFinalFlag() {
        return this.explicitFinalFlag;
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Formal n = (Formal)this.node();
        this.explicitFinalFlag = n.flags().isFinal();
        n = (Formal)super.buildTypes(tb);
        n = n.flags(n.flags().Final());
        JifLocalInstance li = (JifLocalInstance)n.localInstance();
        li.setFlags(li.flags().Final());
        JifTypeSystem jts = (JifTypeSystem)tb.typeSystem();
        if (this.isCatchFormal) {
            li.setLabel(jts.freshLabelVariable(li.position(), li.name(), "label of the formal " + li.name()));
        } else {
            LabelNode ln;
            Position pos = n.type().position();
            if (n.type() instanceof LabeledTypeNode && (ln = ((LabeledTypeNode)n.type()).labelPart()) != null) {
                pos = ln.position();
            }
            ArgLabel al = jts.argLabel(pos, li, null);
            li.setLabel(al);
        }
        n = n.localInstance((LocalInstance)li);
        return n;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        Formal n = (Formal)super.disambiguate(ar);
        JifTypeSystem jts = (JifTypeSystem)ar.typeSystem();
        JifLocalInstance li = (JifLocalInstance)n.localInstance();
        li.setFlags(n.flags());
        li.setName(n.name());
        if (this.isCatchFormal || ((ArgLabel)li.label()).upperBound() == null) {
            li.setType(n.declType());
        }
        if (!n.type().isDisambiguated()) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return n;
        }
        if (!this.isCatchFormal) {
            ArgLabel al = (ArgLabel)li.label();
            al.setCodeInstance(ar.context().currentCode());
            if (al.upperBound() == null) {
                Type lblType;
                if (!jts.isLabeled(n.declType())) {
                    lblType = n.declType();
                    Label defaultBound = jts.defaultSignature().defaultArgBound(n);
                    lblType = jts.labeledType(lblType.position(), lblType, defaultBound);
                    n = n.type(n.type().type(lblType));
                }
                al.setUpperBound(jts.labelOfType(n.declType()));
                lblType = n.declType();
                Position pos = n.type().position();
                lblType = jts.labeledType(pos, jts.unlabel(lblType), al);
                n = n.type(n.type().type(lblType));
            }
        }
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Formal f = (Formal)this.node();
        if (f.localInstance().type().isArray()) {
            JifTypeSystem jts = (JifTypeSystem)tc.typeSystem();
            ArrayType at = jts.unlabel(f.localInstance().type()).toArray();
            JifLocalDeclDel.checkArrayTypeConsistency(at);
        }
        return super.typeCheck(tc);
    }
}

