/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.extension.JifDel_c;
import jif.extension.JifLocalDeclDel;
import jif.types.JifFieldInstance;
import jif.types.JifTypeSystem;
import jif.types.SemanticDetailedException;
import jif.types.label.Label;
import jif.visit.ConstChecker;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.Node;
import polyglot.types.ArrayType;
import polyglot.types.FieldInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class JifFieldDeclDel
extends JifDel_c {
    private static final long serialVersionUID = SerialVersionUID.generate();

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        FieldDecl fd = (FieldDecl)super.buildTypes(tb);
        JifFieldInstance jfi = (JifFieldInstance)fd.fieldInstance();
        JifTypeSystem ts = (JifTypeSystem)tb.typeSystem();
        if (jfi == null) {
            return fd;
        }
        Expr init = fd.init();
        jfi.setHasInitializer(init != null);
        jfi.setLabel(ts.freshLabelVariable(fd.position(), fd.name(), "label of the field " + tb.currentClass().name() + "." + fd.name()));
        return fd;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        JifTypeSystem jts = (JifTypeSystem)ar.typeSystem();
        FieldDecl n = (FieldDecl)this.node();
        FieldInstance fi = n.fieldInstance();
        if (n.declType().isCanonical()) {
            if (!jts.isLabeled(n.declType())) {
                Type lblType = n.declType();
                Position pos = lblType.position();
                Label defaultLbl = jts.defaultSignature().defaultFieldLabel(n);
                lblType = jts.labeledType(pos, lblType, defaultLbl);
                n = n.type(n.type().type(lblType));
            }
            fi.setType(n.declType());
        }
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Expr init;
        FieldDecl fd = (FieldDecl)this.node();
        if (fd.name().indexOf(36) >= 0 && !((JifTypeSystem)tc.typeSystem()).isMarkerFieldName(fd.name())) {
            throw new SemanticException("Field names can not contain the character '$'.");
        }
        if (fd.fieldInstance().flags().isStatic() && (init = fd.init()) != null) {
            ConstChecker cc = new ConstChecker(tc.context().currentClass());
            init.visit((NodeVisitor)cc);
            if (!cc.isConst()) {
                throw new SemanticDetailedException("Jif does not support static fields without constant initializers.", "The initializer of a static field of a class is executed when the class is loaded. Information may be leaked if the time of class loading is observable. To prevent this covert channel, Jif requires static field initializers to be constant.", fd.position());
            }
        }
        if (fd.fieldInstance().type().isArray()) {
            JifTypeSystem jts = (JifTypeSystem)tc.typeSystem();
            ArrayType at = jts.unlabel(fd.fieldInstance().type()).toArray();
            JifLocalDeclDel.checkArrayTypeConsistency(at);
        }
        return super.typeCheck(tc);
    }
}

