/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.JifOptions;
import jif.ast.DowngradeStmt;
import jif.extension.JifStmtExt_c;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifProcedureInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.types.label.NotTaken;
import jif.visit.LabelChecker;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.main.Options;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public abstract class JifDowngradeStmtExt
extends JifStmtExt_c {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifDowngradeStmtExt(ToJavaExt toJava) {
        super(toJava);
    }

    protected JifContext declassifyConstraintContext(JifContext A) throws SemanticException {
        return A;
    }

    @Override
    public final Node labelCheckStmt(LabelChecker lc) throws SemanticException {
        boolean boundSpecified;
        DowngradeStmt ds = (DowngradeStmt)this.node();
        JifContext A = lc.jifContext();
        A = (JifContext)ds.del().enterScope((Context)A);
        Label downgradeTo = ds.label().label();
        Label downgradeFrom = null;
        if (ds.bound() != null) {
            boundSpecified = true;
            downgradeFrom = ds.bound().label();
        } else {
            boundSpecified = false;
            downgradeFrom = lc.typeSystem().freshLabelVariable(ds.position(), "downgrade_from", "The label the downgrade statement is downgrading from");
        }
        PathMap initMap = this.initPathMap(lc);
        Label pc = lc.upperBound(A.pc(), initMap.N());
        this.checkPCconstraint(lc, A, pc, downgradeFrom, boundSpecified);
        JifContext dA = this.declassifyConstraintContext(A);
        this.checkOneDimenOnly(lc, dA, downgradeFrom, downgradeTo, ds.position());
        this.checkAuthority(lc, dA, downgradeFrom, downgradeTo, ds.position());
        this.checkAdditionalConstraints(lc, dA, downgradeFrom, downgradeTo, ds.position());
        if (!((JifOptions)Options.global).nonRobustness) {
            this.checkRobustness(lc, dA, downgradeFrom, downgradeTo, ds.position());
        }
        Stmt body = this.checkBody(lc, A, downgradeFrom, downgradeTo);
        PathMap Xs = JifDowngradeStmtExt.getPathMap((Node)body);
        PathMap X = null;
        X = Xs.N() instanceof NotTaken ? Xs : Xs.N(lc.upperBound(Xs.N(), A.pc()));
        return JifDowngradeStmtExt.updatePathMap((Node)ds.body(body), X);
    }

    protected void checkPCconstraint(LabelChecker lc, JifContext A, Label pc, Label downgradeFrom, boolean boundSpecified) throws SemanticException {
        final DowngradeStmt ds = (DowngradeStmt)this.node();
        lc.constrain(new NamedLabel("pc", pc), boundSpecified ? LabelConstraint.LEQ : LabelConstraint.EQUAL, new NamedLabel("downgrade_bound", downgradeFrom), A.labelEnv(), ds.position(), boundSpecified, new ConstraintMessage(){

            @Override
            public String msg() {
                return "The label of the program counter at this program point is more restrictive than the upper bound that this " + ds.downgradeKind() + " statement is allowed " + "to " + ds.downgradeKind() + ".";
            }

            @Override
            public String detailMsg() {
                return "This " + ds.downgradeKind() + " statement is allowed to " + ds.downgradeKind() + " a program counter labeled up to " + this.namedRhs() + ". However, the label of the " + "program counter at this point is " + this.namedLhs() + ", which is more restrictive than " + "allowed.";
            }

            @Override
            public String technicalMsg() {
                return "Invalid " + ds.downgradeKind() + ": PC is out of bound.";
            }
        });
    }

    protected Stmt checkBody(LabelChecker lc, JifContext A, Label downgradeFrom, Label downgradeTo) throws SemanticException {
        JifContext bA = this.bodyContext(lc, A, downgradeFrom, downgradeTo);
        DowngradeStmt ds = (DowngradeStmt)this.node();
        return (Stmt)lc.context(bA).labelCheck((Node)ds.body());
    }

    protected JifContext bodyContext(LabelChecker lc, JifContext A, Label downgradeFrom, Label downgradeTo) {
        A = (JifContext)A.pushBlock();
        A.setPc(downgradeTo, lc);
        A.setCurrentCodePCBound(downgradeTo);
        if (A.currentCode() instanceof JifProcedureInstance) {
            JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
            Label callPC = ts.callSitePCLabel((JifProcedureInstance)A.currentCode());
            A.addAssertionLE(callPC, downgradeTo);
        } else if (!A.currentCode().flags().isStatic()) {
            JifClassType jct = (JifClassType)A.currentClass();
            A.addAssertionLE(jct.thisLabel(), downgradeTo);
        }
        return A;
    }

    protected PathMap initPathMap(LabelChecker lc) throws SemanticException {
        return lc.typeSystem().pathMap();
    }

    protected abstract void checkOneDimenOnly(LabelChecker var1, JifContext var2, Label var3, Label var4, Position var5) throws SemanticException;

    protected abstract void checkAuthority(LabelChecker var1, JifContext var2, Label var3, Label var4, Position var5) throws SemanticException;

    protected abstract void checkRobustness(LabelChecker var1, JifContext var2, Label var3, Label var4, Position var5) throws SemanticException;

    protected void checkAdditionalConstraints(LabelChecker lc, JifContext A, Label labelFrom, Label labelTo, Position pos) throws SemanticException {
    }
}

