/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.JifOptions;
import jif.ast.DowngradeExpr;
import jif.extension.JifExprExt;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.types.label.VarLabel;
import jif.visit.LabelChecker;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.main.Options;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public abstract class JifDowngradeExprExt
extends JifExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifDowngradeExprExt(ToJavaExt toJava) {
        super(toJava);
    }

    protected JifContext declassifyConstraintContext(LabelChecker lc, JifContext A, Label downgradeFrom, Label downgradeTo) throws SemanticException {
        return A;
    }

    @Override
    public Node labelCheck(LabelChecker lc) throws SemanticException {
        boolean boundSpecified;
        DowngradeExpr d = (DowngradeExpr)this.node();
        JifContext A = lc.jifContext();
        A = (JifContext)d.del().enterScope((Context)A);
        Expr e = (Expr)lc.context(A).labelCheck((Node)d.expr());
        PathMap Xe = JifDowngradeExprExt.getPathMap((Node)e);
        Xe = this.downgradeExprPathMap(lc.context(A), Xe);
        Label downgradeTo = d.label().label();
        Label downgradeFrom = null;
        if (d.bound() != null) {
            boundSpecified = true;
            downgradeFrom = d.bound().label();
        } else {
            boundSpecified = false;
            downgradeFrom = lc.typeSystem().freshLabelVariable(d.position(), "downgrade_from", "The label the downgrade expression is downgrading from");
        }
        VarLabel inferedFrom = lc.typeSystem().freshLabelVariable(d.position(), "infered_downgrade_from", "The label of the target label of downgraded expression");
        this.inferLabelFrom(lc, d.position(), A, d, inferedFrom, Xe.NV(), downgradeFrom);
        A = (JifContext)A.pushBlock();
        this.updateContextAfterExpr(lc, A, Xe);
        lc = lc.context(A);
        VarLabel inferedTo = lc.typeSystem().freshLabelVariable(d.position(), "infered_downgrade_to", "The label of the target label of downgraded expression");
        this.inferLabelTo(lc, d.position(), A, inferedTo, Xe.NV(), downgradeTo);
        this.checkDowngradeFromBound(lc, A, Xe, d, inferedFrom, inferedTo, boundSpecified);
        JifContext dA = this.declassifyConstraintContext(lc, A, inferedFrom, inferedTo);
        this.checkOneDimenOnly(lc, dA, inferedFrom, inferedTo, d.position());
        this.checkAuthority(lc, dA, inferedFrom, inferedTo, d.position());
        if (!((JifOptions)Options.global).nonRobustness) {
            this.checkRobustness(lc, dA, inferedFrom, inferedTo, d.position());
        }
        PathMap X = Xe.NV(lc.upperBound(dA.pc(), inferedTo));
        return JifDowngradeExprExt.updatePathMap((Node)d.expr(e), X);
    }

    public void updateContextAfterExpr(LabelChecker lc, JifContext A, PathMap Xe) {
        A.setPc(Xe.N(), lc);
    }

    abstract void inferLabelFrom(LabelChecker var1, Position var2, JifContext var3, DowngradeExpr var4, Label var5, Label var6, Label var7) throws SemanticException;

    abstract void inferLabelTo(LabelChecker var1, Position var2, JifContext var3, Label var4, Label var5, Label var6) throws SemanticException;

    protected void checkDowngradeFromBound(LabelChecker lc, JifContext A, PathMap Xe, final DowngradeExpr d, Label downgradeFrom, Label downgradeTo, boolean boundSpecified) throws SemanticException {
        Label from = downgradeFrom;
        lc.constrain(new NamedLabel("expr.nv", Xe.NV()), boundSpecified ? LabelConstraint.LEQ : LabelConstraint.EQUAL, new NamedLabel("downgrade_bound", from), A.labelEnv(), d.position(), boundSpecified, new ConstraintMessage(){

            @Override
            public String msg() {
                return "The label of the expression to " + d.downgradeKind() + " is " + "more restrictive than the label of data that " + "the " + d.downgradeKind() + " expression is allowed to " + d.downgradeKind() + ".";
            }

            @Override
            public String detailMsg() {
                return "This " + d.downgradeKind() + " expression is allowed to " + "" + d.downgradeKind() + " information labeled up to " + this.namedRhs() + ". However, the label of the " + "expression to " + d.downgradeKind() + " is " + this.namedLhs() + ", which is more restrictive than is " + "allowed.";
            }

            @Override
            public String technicalMsg() {
                return "Invalid " + d.downgradeKind() + ": NV of the " + "expression is out of bound.";
            }
        });
    }

    protected PathMap downgradeExprPathMap(LabelChecker lc, PathMap Xe) throws SemanticException {
        return Xe;
    }

    protected abstract void checkOneDimenOnly(LabelChecker var1, JifContext var2, Label var3, Label var4, Position var5) throws SemanticException;

    protected abstract void checkAuthority(LabelChecker var1, JifContext var2, Label var3, Label var4, Position var5) throws SemanticException;

    protected abstract void checkRobustness(LabelChecker var1, JifContext var2, Label var3, Label var4, Position var5) throws SemanticException;
}

