/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jif.ast.JifConstructorDecl;
import jif.ast.JifUtil;
import jif.extension.JifProcedureDeclExt_c;
import jif.translate.ToJavaExt;
import jif.types.JifClassType;
import jif.types.JifConstructorInstance;
import jif.types.JifContext;
import jif.types.JifFieldInstance;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.SemanticDetailedException;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.Unary;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.SerialVersionUID;
import polyglot.visit.NodeVisitor;

public class JifConstructorDeclExt
extends JifProcedureDeclExt_c {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifConstructorDeclExt(ToJavaExt toJava) {
        super(toJava);
    }

    @Override
    public Node labelCheck(LabelChecker lc) throws SemanticException {
        JifConstructorDecl mn = (JifConstructorDecl)this.node();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)mn.del().enterScope((Context)A);
        JifConstructorInstance ci = (JifConstructorInstance)mn.constructorInstance();
        lc = lc.context(A);
        List<Formal> formals = this.checkFormals(mn.formals(), ci, lc);
        Label Li = this.checkEnforceSignature(ci, lc);
        Block body = null;
        body = this.checkInitsAndBody(Li, ci, mn.body(), lc);
        PathMap X = JifConstructorDeclExt.getPathMap((Node)body);
        if (Report.should_report((String)jif_verbose, (int)3)) {
            Report.report((int)3, (String)("Body path labels = " + X));
        }
        this.addReturnConstraints(Li, X, ci, lc, (Type)ts.Void());
        mn = (JifConstructorDecl)JifConstructorDeclExt.updatePathMap((Node)mn.formals(formals).body(body), X);
        return mn;
    }

    protected static Set<JifFieldInstance> uninitFinalFields(ReferenceType type) {
        LinkedHashSet<JifFieldInstance> s = new LinkedHashSet<JifFieldInstance>();
        List fields = type.fields();
        for (JifFieldInstance fi : fields) {
            if (!fi.flags().isFinal() || fi.hasInitializer()) continue;
            s.add(fi);
        }
        return s;
    }

    protected Block checkInitsAndBody(Label Li, JifConstructorInstance ci, Block body, LabelChecker lc) throws SemanticException {
        JifContext A = lc.jifContext();
        JifTypeSystem ts = lc.jifTypeSystem();
        A = (JifContext)A.pushBlock();
        lc = lc.context(A);
        PathMap X = ts.pathMap();
        X = X.N(A.pc());
        Set<JifFieldInstance> uninitFinalVars = Collections.emptySet();
        A.setCheckingInits(true);
        Label Lr = ci.returnLabel();
        if (Lr == null) {
            Lr = ts.bottomLabel(ci.position());
        }
        A.setPc(ts.providerLabel((JifClassType)lc.context().currentClass()), lc);
        A.setConstructorReturnLabel(Lr);
        LinkedList<Stmt> stmts = new LinkedList<Stmt>();
        boolean preDangerousSuperCall = true;
        boolean seenSuperCall = false;
        List statements = body.statements();
        for (Stmt s : statements) {
            if (seenSuperCall && uninitFinalVars.isEmpty() && A.checkingInits() && (this.isEscapingThis(s) || this.hasStaticFieldAssign(s))) {
                this.setEndOfInitChecking(lc, ci);
            }
            if ((A = (JifContext)A.pushBlock()).checkingInits()) {
                A.addAssertionLE(ts.callSitePCLabel(ci), A.pc());
            }
            s = (Stmt)lc.context(A).labelCheck((Node)s);
            stmts.add(s);
            A = (JifContext)A.pop();
            PathMap Xs = JifConstructorDeclExt.getPathMap((Node)s);
            if (preDangerousSuperCall && s instanceof ConstructorCall) {
                ConstructorCall ccs = (ConstructorCall)s;
                boolean wasDangerousSuperCall = this.processConstructorCall(ccs, lc, ci, uninitFinalVars);
                if (wasDangerousSuperCall) {
                    preDangerousSuperCall = false;
                }
                if (ccs.kind() == ConstructorCall.SUPER) {
                    seenSuperCall = true;
                }
            }
            this.updateContextForNextStmt(lc, A, Xs);
            X = X.N(ts.notTaken()).join(Xs);
        }
        this.setEndOfInitChecking(lc, ci);
        A = (JifContext)A.pop();
        return (Block)JifConstructorDeclExt.updatePathMap((Node)body.statements(stmts), X);
    }

    protected void updateContextForNextStmt(LabelChecker lc, JifContext A, PathMap Xprev) {
        A.setPc(Xprev.N(), lc);
    }

    private boolean hasStaticFieldAssign(Stmt s) {
        final boolean[] result = new boolean[]{false};
        s.visit(new NodeVisitor(){

            public Node override(Node n) {
                return result[0] ? n : null;
            }

            public Node leave(Node old, Node n, NodeVisitor v) {
                if (result[0]) {
                    return n;
                }
                if (n instanceof FieldAssign) {
                    FieldInstance fi = ((FieldAssign)n).left().fieldInstance();
                    result[0] = fi.flags().isStatic();
                    return n;
                }
                if (n instanceof Unary) {
                    Unary unary = (Unary)n;
                    if (!(unary.expr() instanceof Field)) {
                        return n;
                    }
                    Unary.Operator op = unary.operator();
                    if (op == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_DEC) {
                        FieldInstance fi = ((Field)unary.expr()).fieldInstance();
                        result[0] = fi.flags().isStatic();
                    }
                    return n;
                }
                return n;
            }
        });
        return result[0];
    }

    private boolean isEscapingThis(Stmt s) {
        final boolean[] result = new boolean[]{false};
        s.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                if (n instanceof Call) {
                    Call c = (Call)n;
                    if (c.target() instanceof Expr && JifUtil.effectiveExpr((Expr)c.target()) instanceof Special) {
                        result[0] = true;
                    }
                    List args = c.arguments();
                    for (Expr arg : args) {
                        if (!(JifUtil.effectiveExpr(arg) instanceof Special)) continue;
                        result[0] = true;
                    }
                } else if (n instanceof Assign && JifUtil.effectiveExpr(((Assign)n).right()) instanceof Special) {
                    result[0] = true;
                }
                return n;
            }
        });
        return result[0];
    }

    private boolean processConstructorCall(ConstructorCall ccs, LabelChecker lc, JifConstructorInstance ci, Set<JifFieldInstance> uninitFinalVars) throws SemanticException {
        JifTypeSystem ts = lc.jifTypeSystem();
        boolean wasDangerousSuperCall = false;
        if (ccs.kind() == ConstructorCall.THIS) {
            this.setEndOfInitChecking(lc, ci);
        } else if (!(ccs.kind() != ConstructorCall.SUPER || ts.isSignature((Type)ci.container()) || !ts.isSignature((Type)ci.container()) && ts.isSignature(ci.container().superType()) && ts.hasUntrustedAncestor((Type)ci.container()) == null)) {
            wasDangerousSuperCall = true;
            this.setEndOfInitChecking(lc, ci);
            Iterator<JifFieldInstance> iterator = uninitFinalVars.iterator();
            if (iterator.hasNext()) {
                JifFieldInstance fi = iterator.next();
                throw new SemanticDetailedException("Final field \"" + fi.name() + "\" must be initialized before " + "calling the superclass constructor.", "All final fields of a class must be initialized before the superclass constructor is called, to prevent ancestor classes from reading uninitialized final fields. The final field \"" + fi.name() + "\" needs to " + "be initialized before the superclass " + "constructor call.", ccs.position());
            }
        }
        return wasDangerousSuperCall;
    }

    protected void setEndOfInitChecking(LabelChecker lc, JifConstructorInstance ci) {
        JifContext A = lc.context();
        A.setCheckingInits(false);
        A.setConstructorReturnLabel(null);
        A.setPc(lc.upperBound(A.pc(), lc.typeSystem().callSitePCLabel(ci)), lc);
        Label providerAndPc = lc.typeSystem().join(A.currentCodePCBound(), A.provider());
        A.setCurrentCodePCBound(providerAndPc);
    }

    protected void checkFinalFieldAssignment(Stmt s_, Set<JifFieldInstance> uninitFinalVars, JifContext A) throws SemanticException {
        ArrayList<Stmt> initializers = new ArrayList<Stmt>();
        if (s_ instanceof Block) {
            Block b = (Block)s_;
            List stmts = b.statements();
            initializers.addAll(stmts);
        } else {
            initializers.add(s_);
        }
        for (Stmt s : initializers) {
            if (!(s instanceof Eval) || !(((Eval)s).expr() instanceof FieldAssign)) continue;
            FieldAssign ass = (FieldAssign)((Eval)s).expr();
            Field f = ass.left();
            JifFieldInstance assFi = (JifFieldInstance)f.fieldInstance();
            if (ass.operator() != Assign.ASSIGN || !(f.target() instanceof Special) || ((Special)f.target()).kind() != Special.THIS || !assFi.flags().isFinal()) continue;
            uninitFinalVars.remove(assFi);
        }
    }
}

