/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.List;
import jif.ast.JifClassDecl;
import jif.ast.JifExt_c;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifMethodInstance;
import jif.types.JifParsedPolyType;
import jif.types.JifTypeSystem;
import jif.types.NamedLabel;
import jif.types.PrincipalConstraint;
import jif.types.label.ProviderLabel;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.ast.ClassBody;
import polyglot.ast.Node;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.util.SerialVersionUID;

public class JifClassDeclExt
extends JifExt_c {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifClassDeclExt(ToJavaExt toJava) {
        super(toJava);
    }

    @Override
    public Node labelCheck(LabelChecker lc) throws SemanticException {
        JifClassDecl n = (JifClassDecl)this.node();
        JifTypeSystem jts = lc.typeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)A.pushClass(n.type(), (ClassType)n.type());
        A = n.addParamsToContext(A);
        A = n.addAuthorityToContext(A);
        A.setCurrentCodePCBound(jts.notTaken());
        final JifParsedPolyType ct = (JifParsedPolyType)n.type();
        lc.enteringClassDecl(ct);
        final Principal authPrincipal = lc.jifTypeSystem().conjunctivePrincipal(ct.position(), ct.authority());
        if (ct.superType() instanceof JifClassType) {
            final JifClassType superType = (JifClassType)ct.superType();
            for (final Principal pl : superType.authority()) {
                lc.constrain(authPrincipal, PrincipalConstraint.ACTSFOR, pl, A.labelEnv(), n.position(), new ConstraintMessage(){

                    @Override
                    public String msg() {
                        return "Superclass " + superType + " requires " + ct + " to " + "have the authority of principal " + pl;
                    }

                    @Override
                    public String detailMsg() {
                        return "The class " + superType + " has the authority of the " + "principal " + pl + ". To extend this class, " + ct + " must also have the authority of " + pl + ".";
                    }
                });
            }
        }
        A = (JifContext)n.del().enterScope((Context)A);
        lc = lc.context(A);
        final ProviderLabel provider = ct.provider();
        NamedLabel namedProvider = new NamedLabel(provider.toString(), "provider of " + provider.classType().fullName(), provider);
        lc.constrain(namedProvider, authPrincipal, A.labelEnv(), n.position(), new ConstraintMessage(){

            @Override
            public String msg() {
                return provider + " must act for " + authPrincipal;
            }

            @Override
            public String detailMsg() {
                return provider + " is the provider of " + ct + " but does not have authority to act for " + authPrincipal;
            }
        });
        this.labelCheckClassConformance(ct, lc);
        ClassBody body = (ClassBody)lc.labelCheck((Node)n.body());
        n = lc.leavingClassDecl((JifClassDecl)n.body(body));
        return n;
    }

    protected void labelCheckClassConformance(JifParsedPolyType ct, LabelChecker lc) throws SemanticException {
        if (ct.flags().isInterface()) {
            return;
        }
        JifTypeSystem ts = lc.typeSystem();
        List<ReferenceType> superInterfaces = ts.abstractSuperInterfaces((ReferenceType)ct);
        for (ReferenceType rt : superInterfaces) {
            List methods = rt.methods();
            for (JifMethodInstance mi : methods) {
                JifMethodInstance mj;
                if (!mi.flags().isAbstract() || (mj = (JifMethodInstance)ts.findImplementingMethod(ct, mi)) == null || ct.equals(mj.container()) || ct.equals(mi.container())) continue;
                try {
                    if (!mj.canOverrideImpl(mi, true)) continue;
                    lc.createOverrideHelper(mi, mj).checkOverride(lc);
                }
                catch (SemanticException e) {
                    throw new SemanticException(e.getMessage(), ct.position());
                }
            }
        }
    }
}

