/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jif.JifOptions;
import jif.extension.JifDel_c;
import jif.extension.JifPreciseClassDel;
import jif.extension.LabelTypeCheckUtil;
import jif.extension.SubtypeChecker;
import jif.types.JifClassType;
import jif.types.JifPolyType;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.visit.JifTypeChecker;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.SerialVersionUID;
import polyglot.util.SubtypeSet;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class JifCastDel
extends JifDel_c
implements JifPreciseClassDel {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private Set<Type> exprPreciseClasses = null;
    private boolean isToSubstJifClass = false;
    private boolean isClassCastExceptionFatal = false;

    public boolean isToSubstJifClass() {
        return this.isToSubstJifClass;
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        JifTypeChecker jtc = (JifTypeChecker)super.typeCheckEnter(tc);
        return jtc.inferClassParameters(true);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Type castType;
        Cast c = (Cast)this.node();
        JifTypeSystem ts = (JifTypeSystem)tc.typeSystem();
        if (ts.isLabeled(castType = c.castType().type())) {
            throw new SemanticException("Cannot cast to a labeled type.", c.position());
        }
        if (!ts.isParamsRuntimeRep(castType) && (castType instanceof JifSubstType && !((JifSubstType)castType).actuals().isEmpty() || castType instanceof JifPolyType && !((JifPolyType)castType).params().isEmpty())) {
            throw new SemanticException("Cannot cast to " + castType + ", since it does " + "not represent the parameters at runtime.", c.position());
        }
        if (castType.isArray()) {
            JifOptions opt = (JifOptions)ts.extensionInfo().getOptions();
            if (!opt.skipLabelChecking) {
                throw new SemanticException("Jif does not currently support casts to arrays.", c.position());
            }
        }
        this.isToSubstJifClass = castType instanceof JifSubstType && !((JifSubstType)castType).actuals().isEmpty();
        ts.labelTypeCheckUtil().typeCheckType(tc, castType);
        return super.typeCheck(tc);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        Cast c = (Cast)this.node();
        ArrayList<Type> ex = new ArrayList<Type>(super.throwTypes(ts));
        if (!this.throwsClassCastException()) {
            ex.remove(ts.ClassCastException());
            return ex;
        }
        if (c.castType().type() instanceof JifClassType) {
            LabelTypeCheckUtil ltcu = ((JifTypeSystem)ts).labelTypeCheckUtil();
            ex.addAll(ltcu.throwTypes((JifClassType)c.castType().type()));
        }
        return ex;
    }

    @Override
    public void setFatalExceptions(TypeSystem ts, SubtypeSet fatalExceptions) {
        super.setFatalExceptions(ts, fatalExceptions);
        if (fatalExceptions.contains((Object)ts.ClassCastException())) {
            this.isClassCastExceptionFatal = true;
        }
    }

    public boolean throwsClassCastException() {
        if (this.isClassCastExceptionFatal) {
            return false;
        }
        Cast c = (Cast)this.node();
        Type castType = c.castType().type();
        JifTypeSystem ts = (JifTypeSystem)castType.typeSystem();
        if (this.exprPreciseClasses != null) {
            for (Type t : this.exprPreciseClasses) {
                if (!JifCastDel.typeCastGuaranteed(ts, castType, t)) continue;
                return false;
            }
        }
        if (JifCastDel.typeCastGuaranteed(ts, castType, c.expr().type())) {
            return false;
        }
        return c.castType().type() instanceof JifClassType;
    }

    private static boolean typeCastGuaranteed(JifTypeSystem ts, Type castType, Type exprType) {
        if (ts.equalsNoStrip((TypeObject)castType, (TypeObject)exprType)) {
            return true;
        }
        return castType instanceof JifClassType && SubtypeChecker.polyTypeForClass((JifClassType)castType).params().isEmpty() && (!(exprType instanceof JifClassType) || SubtypeChecker.polyTypeForClass((JifClassType)exprType).params().isEmpty()) && castType.typeSystem().isSubtype(exprType, castType);
    }

    @Override
    public Expr getPreciseClassExpr() {
        return ((Cast)this.node()).expr();
    }

    @Override
    public void setPreciseClass(Set<Type> preciseClasses) {
        this.exprPreciseClasses = preciseClasses;
    }
}

