/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.List;
import jif.JifScheduler;
import jif.ast.JifUtil;
import jif.extension.CallHelper;
import jif.extension.ConstructorChecker;
import jif.extension.JifCallDel;
import jif.extension.JifExprExt;
import jif.translate.ToJavaExt;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifFieldInstance;
import jif.types.JifMethodInstance;
import jif.types.JifParsedPolyType;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.PathMap;
import jif.types.SemanticDetailedException;
import jif.types.label.AccessPathField;
import jif.types.label.DynamicLabel;
import jif.types.label.Label;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.ast.Call;
import polyglot.ast.CallOps;
import polyglot.ast.Expr;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ext.param.types.PClass;
import polyglot.frontend.FileSource;
import polyglot.frontend.Job;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.goals.Goal;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JifCallExt
extends JifExprExt
implements CallOps {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifCallExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Type findContainer(TypeSystem ts, MethodInstance mi) {
        JifParsedPolyType jppt;
        ReferenceType container = mi.container();
        if (container instanceof JifParsedPolyType && (jppt = (JifParsedPolyType)container).params().size() > 0) {
            return ((JifTypeSystem)ts).nullInstantiate(this.node().position(), (PClass<ParamInstance, Param>)jppt.instantiatedFrom());
        }
        return this.superLang().findContainer(this.node(), ts, mi);
    }

    @Override
    public Node labelCheck(LabelChecker lc) throws SemanticException {
        Call me = this.node();
        JifContext A = lc.jifContext();
        A = (JifContext)me.del().enterScope((Context)A);
        JifTypeSystem ts = lc.jifTypeSystem();
        if (A.checkingInits()) {
            if (me.target() instanceof Expr && JifUtil.effectiveExpr((Expr)me.target()) instanceof Special) {
                throw new SemanticDetailedException("No methods may be called on \"this\" object in a constructor prologue.", "In a constructor body before the call to the super class, no reference to the \"this\" object is allowed to escape. This means that no methods of the current object may be called.", me.position());
            }
            for (Expr arg : me.arguments()) {
                if (!(JifUtil.effectiveExpr(arg) instanceof Special)) continue;
                throw new SemanticDetailedException("The \"this\" object cannot be used as a method argument in a constructor prologue.", "In a constructor body before the call to the super class, no reference to the \"this\" object is allowed to escape. This means that the \"this\" object cannot be used as a method argument.", arg.position());
            }
        }
        ArrayList<Type> throwTypes = new ArrayList<Type>(me.del().throwTypes((TypeSystem)ts));
        Receiver target = (Receiver)lc.context(A).labelCheck((Node)me.target());
        ReferenceType rt = target.type().toReference();
        if (rt != null && rt.fields() != null) {
            for (FieldInstance fi : rt.fields()) {
                Job job;
                ParsedClassType pct;
                JifScheduler sched;
                JifFieldInstance jfi = (JifFieldInstance)fi;
                if (!jfi.flags().isFinal() || !jfi.flags().isStatic() || !jfi.hasInitializer()) continue;
                AccessPathField path = (AccessPathField)ts.varInstanceToAccessPath(jfi, jfi.position());
                Param init = jfi.initializer();
                if (ts.isLabel(jfi.type())) {
                    DynamicLabel dl = ts.dynamicLabel(jfi.position(), path);
                    Label rhs_label = (Label)init;
                    if (rhs_label == null) {
                        sched = (JifScheduler)lc.job().extensionInfo().scheduler();
                        if (!sched.sourceHasJob((pct = (ParsedClassType)rt).fromSource()) || (job = sched.loadSource((FileSource)pct.fromSource(), true)) == null) continue;
                        Goal g = sched.LabelsDoubleChecked(job);
                        throw new MissingDependencyException(g);
                    }
                    A.addDefinitionalAssertionEquiv(dl, rhs_label, true);
                    continue;
                }
                if (!ts.isImplicitCastValid(jfi.type(), (Type)ts.Principal())) continue;
                DynamicPrincipal dp = ts.dynamicPrincipal(jfi.position(), path);
                Principal rhs_principal = (Principal)init;
                if (rhs_principal == null) {
                    sched = (JifScheduler)lc.job().extensionInfo().scheduler();
                    if (sched.sourceHasJob((pct = (ParsedClassType)rt).fromSource()) && (job = sched.loadSource((FileSource)pct.fromSource(), true)) != null) {
                        Goal g = sched.LabelsDoubleChecked(job);
                        throw new MissingDependencyException(g);
                    }
                    rhs_principal = ts.bottomPrincipal(Position.compilerGenerated());
                }
                A.addDefinitionalEquiv(dp, rhs_principal);
            }
        }
        JifMethodInstance mi = (JifMethodInstance)ts.findMethod(rt, me.name(), me.methodInstance().formalTypes(), A.currentClass());
        me = me.methodInstance((MethodInstance)mi);
        if (mi.flags().isStatic()) {
            new ConstructorChecker().checkStaticMethodAuthority(mi, A, lc, me.position());
        }
        A = (JifContext)A.pushBlock();
        boolean npExc = false;
        Label objLabel = null;
        if (target instanceof Expr) {
            Expr e = (Expr)target;
            if (e.type() == null) {
                throw new InternalCompilerError("Type of " + e + " is null", e.position());
            }
            PathMap Xs = JifCallExt.getPathMap((Node)target);
            this.updateContextPostTarget(lc, A, Xs);
            if (!(target instanceof Special)) {
                npExc = !((JifCallDel)this.node().del()).targetIsNeverNull();
                objLabel = Xs.NV();
                this.updateContextPostTargetExpr(lc, A, Xs);
            } else {
                objLabel = ((JifClassType)lc.context().currentClass()).thisLabel();
            }
        }
        CallHelper helper = lc.createCallHelper(objLabel, target, mi.container(), mi, me.arguments(), this.node().position());
        LabelChecker callLC = lc.context(A);
        me = helper.checkCall(callLC, throwTypes, me, npExc);
        JifCallDel del = (JifCallDel)me.del();
        helper.bindVarLabels(callLC, del.receiverVarLabel, del.argVarLabels, del.paramVarLabels);
        A = (JifContext)A.pop();
        if (helper.returnType() != me.type()) {
            me = (Call)me.type(helper.returnType());
        }
        JifCallExt.checkThrowTypes(throwTypes);
        return JifCallExt.updatePathMap((Node)me.target(target).arguments(helper.labelCheckedArgs()), helper.X());
    }

    protected void updateContextPostTarget(LabelChecker lc, JifContext A, PathMap Xtarg) {
        A.setPc(Xtarg.N(), lc);
    }

    protected void updateContextPostTargetExpr(LabelChecker lc, JifContext A, PathMap Xtarg) {
        A.setPc(Xtarg.NV(), lc);
    }

    public Call node() {
        return (Call)super.node();
    }

    public void printArgs(CodeWriter w, PrettyPrinter tr) {
        this.superLang().printArgs((ProcedureCall)this.node(), w, tr);
    }

    public boolean constantValueSet(Lang lang) {
        return this.superLang().constantValueSet((Expr)this.node(), lang);
    }

    public boolean isConstant(Lang lang) {
        return this.superLang().isConstant((Expr)this.node(), lang);
    }

    public Object constantValue(Lang lang) {
        return this.superLang().constantValue((Expr)this.node(), lang);
    }

    public ReferenceType findTargetType() throws SemanticException {
        return this.superLang().findTargetType(this.node());
    }

    public Node typeCheckNullTarget(TypeChecker tc, List<Type> argTypes) throws SemanticException {
        return this.superLang().typeCheckNullTarget(this.node(), tc, argTypes);
    }
}

