/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jif.ast.JifInstantiator;
import jif.extension.CallHelper;
import jif.extension.JifDel_c;
import jif.extension.LabelTypeCheckUtil;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifMethodInstance;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.label.Label;
import jif.types.label.VarLabel;
import jif.visit.JifTypeChecker;
import polyglot.ast.Call;
import polyglot.ast.CallOps;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Expr;
import polyglot.ast.ExprOps;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;
import polyglot.util.SubtypeSet;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class JifCallDel
extends JifDel_c
implements CallOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private boolean isTargetNeverNull = false;
    private boolean targetNeverNullAlreadySet = false;
    private boolean isNPEfatal = false;
    protected VarLabel receiverVarLabel;
    protected List<VarLabel> argVarLabels;
    protected List<VarLabel> paramVarLabels;

    public void setTargetIsNeverNull(boolean neverNull) {
        this.isTargetNeverNull = !this.targetNeverNullAlreadySet ? neverNull : this.isTargetNeverNull && neverNull;
        this.targetNeverNullAlreadySet = true;
    }

    public boolean targetIsNeverNull() {
        Receiver r = ((Call)this.node()).target();
        return r instanceof Special || this.isNPEfatal || this.isTargetNeverNull || r instanceof CanonicalTypeNode;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        MethodInstance mi = ((Call)this.node()).methodInstance();
        if (mi == null) {
            throw new InternalCompilerError(this.node().position(), "Null method instance after type check.");
        }
        LinkedList<Type> l = new LinkedList<Type>();
        l.addAll(mi.throwTypes());
        if (!this.targetIsNeverNull() && !this.fatalExceptions.contains(ts.NullPointerException())) {
            l.add((Type)ts.NullPointerException());
        }
        LabelTypeCheckUtil ltcu = ((JifTypeSystem)ts).labelTypeCheckUtil();
        if (mi.flags().isStatic() && mi.container() instanceof JifClassType) {
            l.addAll(ltcu.throwTypes((JifClassType)mi.container()));
        }
        return l;
    }

    @Override
    public void setFatalExceptions(TypeSystem ts, SubtypeSet fatalExceptions) {
        super.setFatalExceptions(ts, fatalExceptions);
        if (fatalExceptions.contains((Object)ts.NullPointerException())) {
            this.isNPEfatal = true;
        }
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        JifTypeChecker jtc = (JifTypeChecker)super.typeCheckEnter(tc);
        return jtc.inferClassParameters(true);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Call c = (Call)super.typeCheck(tc);
        JifMethodInstance mi = (JifMethodInstance)c.methodInstance();
        JifContext A = (JifContext)tc.context();
        JifTypeSystem ts = (JifTypeSystem)tc.typeSystem();
        JifCallDel del = (JifCallDel)c.del();
        del.receiverVarLabel = null;
        Expr receiverExpr = null;
        if (c.target() instanceof Expr) {
            receiverExpr = (Expr)c.target();
            del.receiverVarLabel = ts.freshLabelVariable(c.position(), "receiver", "label of receiver of call " + c.toString());
        }
        del.argVarLabels = new ArrayList<VarLabel>(c.arguments().size());
        for (int i = 0; i < c.arguments().size(); ++i) {
            Expr arg = (Expr)c.arguments().get(i);
            VarLabel argLbl = ts.freshLabelVariable(arg.position(), "arg" + (i + 1) + "label", "label of arg " + (i + 1) + " of call " + c.toString());
            del.argVarLabels.add(argLbl);
        }
        if (ts.unlabel((Type)mi.container()) instanceof JifSubstType) {
            JifSubstType jst = (JifSubstType)ts.unlabel((Type)mi.container());
            del.paramVarLabels = new ArrayList<VarLabel>(jst.instantiatedFrom().formals().size());
            for (Param param : jst.actuals()) {
                VarLabel paramLbl = ts.freshLabelVariable(param.position(), "param_" + param + "_label", "label of param " + param + " of call " + c.toString());
                del.paramVarLabels.add(paramLbl);
            }
        } else {
            del.paramVarLabels = Collections.emptyList();
        }
        Type t = mi.returnType();
        Type retType = JifInstantiator.instantiate(t, A, receiverExpr, mi.container(), (Label)del.receiverVarLabel, CallHelper.getArgLabelsFromFormalTypes(mi.formalTypes(), ts, mi.position()), (List<? extends Type>)mi.formalTypes(), del.argVarLabels, (List<Expr>)c.arguments(), del.paramVarLabels);
        c = (Call)c.type(retType);
        return c;
    }

    public Type findContainer(TypeSystem ts, MethodInstance mi) {
        return ((CallOps)this.jl()).findContainer(ts, mi);
    }

    public ReferenceType findTargetType() throws SemanticException {
        return ((CallOps)this.jl()).findTargetType();
    }

    public Node typeCheckNullTarget(TypeChecker tc, List<Type> argTypes) throws SemanticException {
        return ((CallOps)this.jl()).typeCheckNullTarget(tc, argTypes);
    }

    public void printArgs(CodeWriter w, PrettyPrinter tr) {
        ((CallOps)this.jl()).printArgs(w, tr);
    }

    public boolean constantValueSet(Lang lang) {
        return ((ExprOps)this.jl()).constantValueSet(lang);
    }

    public boolean isConstant(Lang lang) {
        return ((ExprOps)this.jl()).isConstant(lang);
    }

    public Object constantValue(Lang lang) {
        return ((ExprOps)this.jl()).constantValue(lang);
    }
}

