/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import jif.ast.JifUtil;
import jif.extension.JifExprExt;
import jif.extension.SubtypeChecker;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.SerialVersionUID;

public class JifArrayInitExt
extends JifExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifArrayInitExt(ToJavaExt toJava) {
        super(toJava);
    }

    @Override
    public Node labelCheck(LabelChecker lc) throws SemanticException {
        ArrayInit init = (ArrayInit)this.node();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)init.del().enterScope((Context)A);
        A = (JifContext)A.pushBlock();
        PathMap X = ts.pathMap();
        X = X.N(A.pc());
        ArrayList<Expr> l = new ArrayList<Expr>(init.elements().size());
        for (Expr e : init.elements()) {
            e = (Expr)lc.context(A).labelCheck((Node)e);
            l.add(e);
            PathMap Xe = JifArrayInitExt.getPathMap((Node)e);
            X = X.N(ts.notTaken()).join(Xe);
            this.updateContextForNextElem(lc, A, X);
        }
        A = (JifContext)A.pop();
        return JifArrayInitExt.updatePathMap((Node)init.elements(l), X);
    }

    protected void updateContextForNextElem(LabelChecker lc, JifContext A, PathMap Xelem) {
        A.setPc(Xelem.N(), lc);
    }

    public void labelCheckElements(LabelChecker lc, Type lhsType) throws SemanticException {
        ArrayInit init = (ArrayInit)this.node();
        Type t = lhsType.toArray().base();
        Label L = null;
        if (lc.typeSystem().isLabeled(t)) {
            L = lc.typeSystem().labelOfType(t);
        }
        for (Expr e : init.elements()) {
            Type s = e.type();
            if (e instanceof ArrayInit) {
                ((JifArrayInitExt)JifUtil.jifExt((Node)e)).labelCheckElements(lc, t);
            }
            SubtypeChecker subtypeChecker = new SubtypeChecker(t, s);
            subtypeChecker.addSubtypeConstraints(lc, e.position());
            if (L == null) continue;
            PathMap Xe = JifArrayInitExt.getPathMap((Node)e);
            lc.constrain(new NamedLabel("array_init_elem.nv", "label of successful evaluation of array element " + e, Xe.NV()), LabelConstraint.LEQ, new NamedLabel("label of array base type", L), lc.context().labelEnv(), e.position(), new ConstraintMessage(){

                @Override
                public String msg() {
                    return "Label of the array element not less restrictive than the label of the array base type.";
                }

                @Override
                public String detailMsg() {
                    return "More information is revealed by the successful evaluation of the intializing expression than is allowed to flow to the array base type.";
                }
            });
        }
    }
}

