/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import jif.ast.JifNodeFactory;
import jif.extension.JifArrayAccessDel;
import jif.extension.JifExprExt;
import jif.translate.ToJavaExt;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.IntLit;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class JifArrayAccessExt
extends JifExprExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifArrayAccessExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheckIncrement(LabelChecker lc) throws SemanticException {
        JifNodeFactory nf = (JifNodeFactory)lc.nodeFactory();
        ArrayAccess ae = (ArrayAccess)this.node();
        Position pos = ae.position();
        ArrayAccessAssign aae = nf.ArrayAccessAssign(pos, ae, Assign.ADD_ASSIGN, (Expr)nf.IntLit(pos, IntLit.INT, 1L));
        aae = (ArrayAccessAssign)lc.labelCheck((Node)aae);
        return aae.left();
    }

    @Override
    public Node labelCheck(LabelChecker lc) throws SemanticException {
        JifContext A = lc.jifContext();
        JifTypeSystem ts = lc.jifTypeSystem();
        ArrayAccess aie = (ArrayAccess)this.node();
        ArrayList<Type> throwTypes = new ArrayList<Type>(aie.del().throwTypes((TypeSystem)ts));
        Expr array = (Expr)lc.context(A).labelCheck((Node)aie.array());
        PathMap Xa = JifArrayAccessExt.getPathMap((Node)array);
        A = (JifContext)A.pushBlock();
        this.updateContextForIndex(lc, A, Xa);
        Expr index = (Expr)lc.context(A).labelCheck((Node)aie.index());
        PathMap Xb = JifArrayAccessExt.getPathMap((Node)index);
        A = (JifContext)A.pop();
        Label La = this.arrayBaseLabel(array, ts);
        ClassType npe = ts.NullPointerException();
        ClassType oob = ts.OutOfBoundsException();
        PathMap X2 = Xa.join(Xb);
        if (!((JifArrayAccessDel)this.node().del()).arrayIsNeverNull()) {
            JifArrayAccessExt.checkAndRemoveThrowType(throwTypes, (Type)npe);
            X2 = X2.exc(Xa.NV(), (Type)npe);
        }
        if (((JifArrayAccessDel)this.node().del()).outOfBoundsExcThrown()) {
            JifArrayAccessExt.checkAndRemoveThrowType(throwTypes, (Type)oob);
            X2 = X2.exc(lc.upperBound(Xa.NV(), Xb.NV()), (Type)oob);
        }
        PathMap X = X2.NV(lc.upperBound(La, X2.NV()));
        JifArrayAccessExt.checkThrowTypes(throwTypes);
        return JifArrayAccessExt.updatePathMap((Node)aie.index(index).array(array), X);
    }

    protected void updateContextForIndex(LabelChecker lc, JifContext A, PathMap Xarr) {
        A.setPc(Xarr.N(), lc);
    }

    private Type arrayType(Expr array, JifTypeSystem ts) {
        Type arrayType = array.type();
        if (array instanceof Local) {
            arrayType = ((Local)array).localInstance().type();
        }
        return ts.unlabel(arrayType);
    }

    private Label arrayBaseLabel(Expr array, JifTypeSystem ts) {
        Type arrayType = this.arrayType(array, ts);
        return ts.labelOfType(((ArrayType)arrayType).base());
    }
}

