/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.List;
import jif.extension.JifArrayAccessDel;
import jif.extension.JifAssignDel;
import jif.extension.JifAssignExt;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.SerialVersionUID;

public class JifArrayAccessAssignExt
extends JifAssignExt {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public JifArrayAccessAssignExt(ToJavaExt toJava) {
        super(toJava);
    }

    @Override
    public Node labelCheckLHS(LabelChecker lc) throws SemanticException {
        ArrayAccessAssign assign = (ArrayAccessAssign)this.node();
        final ArrayAccess aie = assign.left();
        JifContext A = lc.jifContext();
        A = (JifContext)aie.del().enterScope((Context)A);
        JifTypeSystem ts = lc.jifTypeSystem();
        ArrayList<Type> throwTypes = new ArrayList<Type>(assign.del().throwTypes((TypeSystem)ts));
        if (assign.left() != aie) {
            throw new InternalCompilerError(aie + " is not the left hand side of " + assign);
        }
        ClassType npe = ts.NullPointerException();
        ClassType oob = ts.OutOfBoundsException();
        ClassType are = ts.ArithmeticException();
        final Expr array = (Expr)lc.context(A).labelCheck((Node)aie.array());
        PathMap Xarr = JifArrayAccessAssignExt.getPathMap((Node)array);
        A = (JifContext)A.pushBlock();
        this.updateContextForIndex(lc, A, Xarr);
        Expr index = (Expr)lc.context(A).labelCheck((Node)aie.index());
        PathMap Xind = JifArrayAccessAssignExt.getPathMap((Node)index);
        PathMap Xlhs = Xarr.join(Xind);
        A = (JifContext)A.pushBlock();
        if (assign.operator() != Assign.ASSIGN) {
            if (!((JifArrayAccessDel)assign.left().del()).arrayIsNeverNull()) {
                JifArrayAccessAssignExt.checkAndRemoveThrowType(throwTypes, (Type)npe);
                Xlhs = Xlhs.exc(lc.upperBound(Xarr.NV(), Xind.N()), (Type)npe);
            }
            if (((JifArrayAccessDel)assign.left().del()).outOfBoundsExcThrown()) {
                JifArrayAccessAssignExt.checkAndRemoveThrowType(throwTypes, (Type)oob);
                Xlhs = Xlhs.exc(lc.upperBound(Xarr.NV(), Xind.NV()), (Type)oob);
            }
        }
        this.updateContextForRHS(lc, A, Xlhs);
        Expr rhs = (Expr)lc.context(A).labelCheck((Node)assign.right());
        PathMap Xrhs = this.rhsPathMap(lc.context(A), rhs, throwTypes);
        A = (JifContext)A.pop();
        A = (JifContext)A.pop();
        Label La = this.arrayBaseLabel(array, ts);
        PathMap X = Xlhs.join(Xrhs);
        if (assign.operator() != Assign.ASSIGN) {
            X = X.NV(lc.upperBound(La, X.NV()));
            if (((JifAssignDel)assign.del()).throwsArithmeticException()) {
                JifArrayAccessAssignExt.checkAndRemoveThrowType(throwTypes, (Type)are);
                X = X.exc(Xrhs.NV(), (Type)are);
            }
            Xrhs = X;
        } else {
            if (!((JifArrayAccessDel)assign.left().del()).arrayIsNeverNull()) {
                JifArrayAccessAssignExt.checkAndRemoveThrowType(throwTypes, (Type)npe);
                X = X.exc(lc.upperBound(Xarr.NV(), X.N()), (Type)npe);
            }
            if (((JifArrayAccessDel)assign.left().del()).outOfBoundsExcThrown()) {
                JifArrayAccessAssignExt.checkAndRemoveThrowType(throwTypes, (Type)oob);
                X = X.exc(lc.upperBound(Xarr.NV(), Xind.NV(), X.N()), (Type)oob);
            }
        }
        NamedLabel namedLa = new NamedLabel("La", "Label of the array base type", La);
        lc.constrain(new NamedLabel("rhs.nv", "label of successful evaluation of right hand of assignment", Xrhs.NV()).join(lc, "lhs.n", "label of successful evaluation of array access " + aie, X.N()), LabelConstraint.LEQ, namedLa, A.labelEnv(), aie.position(), new ConstraintMessage(){

            @Override
            public String msg() {
                return "Label of succesful evaluation of array access and right hand side of the assignment is not less restrictive than the label for the array base type.";
            }

            @Override
            public String detailMsg() {
                return "More information may be revealed by the successul evaluation of the array access " + aie + " and the right hand side of the assignment " + "than is allowed to flow to elements of the " + "array. Elements of the array can only " + "contain information up to the label of the " + "array base type, La.";
            }

            @Override
            public String technicalMsg() {
                return "Invalid assignment: " + this.namedLhs().toString() + " is not less restrictive than the label of " + "array element.";
            }
        });
        lc.constrain(new NamedLabel("Li", "Lower bound for side-effects", A.currentCodePCBound()), LabelConstraint.LEQ, namedLa, A.labelEnv(), aie.position(), new ConstraintMessage(){

            @Override
            public String msg() {
                return "Effect of assignment to array " + array + " is not bounded below by the PC bound.";
            }

            @Override
            public String detailMsg() {
                return "Assignment to the array " + array + " is a side effect which reveals more" + " information than this method is allowed" + " to; the side effects of this method must" + " be bounded below by the method's PC" + " bound, Li.";
            }

            @Override
            public String technicalMsg() {
                return "Invalid assignment: Li is more restrictive than array base label.";
            }
        });
        Expr lhs = (Expr)JifArrayAccessAssignExt.updatePathMap((Node)aie.index(index).array(array), X);
        JifArrayAccessAssignExt.checkThrowTypes(throwTypes);
        return JifArrayAccessAssignExt.updatePathMap((Node)assign.right(rhs).left(lhs), X);
    }

    protected void updateContextForIndex(LabelChecker lc, JifContext A, PathMap Xarr) {
        A.setPc(Xarr.N(), lc);
    }

    protected void updateContextForRHS(LabelChecker lc, JifContext A, PathMap Xlhs) {
        A.setPc(Xlhs.N(), lc);
    }

    protected PathMap rhsPathMap(LabelChecker checker, Expr rhs, List<Type> throwTypes) {
        return JifArrayAccessAssignExt.getPathMap((Node)rhs);
    }

    private Label arrayBaseLabel(Expr array, JifTypeSystem ts) {
        ArrayType arrayType = (ArrayType)ts.unlabel(array.type());
        return ts.labelOfType(arrayType.base());
    }
}

