/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import jif.ast.ParamDecl;
import jif.types.JifPolyType;
import jif.types.JifTypeSystem;
import jif.types.ParamInstance;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.types.Context;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;

public class ParamDecl_c
extends Node_c
implements ParamDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    ParamInstance pi;
    Id name;
    ParamInstance.Kind kind;

    public ParamDecl_c(Position pos, ParamInstance.Kind kind, Id name) {
        this(pos, kind, name, null);
    }

    public ParamDecl_c(Position pos, ParamInstance.Kind kind, Id name, Ext ext) {
        super(pos, ext);
        this.kind = kind;
        this.name = name;
    }

    public boolean isDisambiguated() {
        return this.pi != null && this.pi.isCanonical() && super.isDisambiguated();
    }

    @Override
    public ParamInstance.Kind kind() {
        return this.kind;
    }

    @Override
    public ParamDecl kind(ParamInstance.Kind kind) {
        ParamDecl_c n = (ParamDecl_c)this.copy();
        n.kind = kind;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public ParamDecl name(String name) {
        ParamDecl_c n = (ParamDecl_c)this.copy();
        n.name = n.name.id(name);
        return n;
    }

    @Override
    public ParamInstance paramInstance() {
        return this.pi;
    }

    @Override
    public ParamDecl paramInstance(ParamInstance pi) {
        ParamDecl_c n = (ParamDecl_c)this.copy();
        n.pi = pi;
        return n;
    }

    @Override
    public boolean isPrincipal() {
        return this.kind == ParamInstance.PRINCIPAL;
    }

    @Override
    public boolean isLabel() {
        return this.kind == ParamInstance.INVARIANT_LABEL || this.kind == ParamInstance.COVARIANT_LABEL;
    }

    @Override
    public boolean isInvariantLabel() {
        return this.kind == ParamInstance.INVARIANT_LABEL;
    }

    @Override
    public boolean isCovariantLabel() {
        return this.kind == ParamInstance.COVARIANT_LABEL;
    }

    public void leaveScope(Context c) {
        c.addVariable((VarInstance)this.pi);
    }

    public Node buildTypes(TypeBuilder tb) {
        JifTypeSystem ts = (JifTypeSystem)tb.typeSystem();
        JifPolyType ct = (JifPolyType)tb.currentClass();
        ParamInstance pi = ts.paramInstance(this.position(), ct, this.kind, this.name.id());
        return this.paramInstance(pi);
    }

    public String toString() {
        return this.kind.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.kind == ParamInstance.COVARIANT_LABEL) {
            w.write("covariant label ");
        } else if (this.kind == ParamInstance.INVARIANT_LABEL) {
            w.write("label ");
        } else if (this.kind == ParamInstance.PRINCIPAL) {
            w.write("principal ");
        }
        w.write(this.name.id());
    }

    public void translate(CodeWriter w, Translator tr) {
    }
}

