/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import jif.ast.LabelNode;
import jif.ast.LabeledTypeNode;
import jif.types.JifTypeSystem;
import jif.types.label.Label;
import polyglot.ast.Ambiguous;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class LabeledTypeNode_c
extends TypeNode_c
implements LabeledTypeNode,
Ambiguous {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode typePart;
    protected LabelNode labelPart;

    public LabeledTypeNode_c(Position pos, TypeNode typePart, LabelNode labelPart) {
        this(pos, typePart, labelPart, null);
    }

    public LabeledTypeNode_c(Position pos, TypeNode typePart, LabelNode labelPart, Ext ext) {
        super(pos, ext);
        this.typePart = typePart;
        this.labelPart = labelPart;
    }

    @Override
    public TypeNode typePart() {
        return this.typePart;
    }

    @Override
    public LabeledTypeNode typePart(TypeNode typePart) {
        LabeledTypeNode_c n = (LabeledTypeNode_c)this.copy();
        n.typePart = typePart;
        return n;
    }

    @Override
    public LabelNode labelPart() {
        return this.labelPart;
    }

    @Override
    public LabeledTypeNode labelPart(LabelNode labelPart) {
        LabeledTypeNode_c n = (LabeledTypeNode_c)this.copy();
        n.labelPart = labelPart;
        return n;
    }

    protected LabeledTypeNode_c reconstruct(TypeNode typePart, LabelNode labelPart) {
        if (typePart != this.typePart || labelPart != this.labelPart) {
            LabeledTypeNode_c n = (LabeledTypeNode_c)this.copy();
            n.typePart = typePart;
            n.labelPart = labelPart;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode typePart = (TypeNode)this.visitChild((Node)this.typePart, v);
        LabelNode labelPart = (LabelNode)this.visitChild(this.labelPart, v);
        return this.reconstruct(typePart, labelPart);
    }

    public Node buildTypes(TypeBuilder tb) {
        if (this.type == null) {
            return this.type(this.typePart.type());
        }
        return this;
    }

    public boolean isDisambiguated() {
        return false;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        LabeledTypeNode_c n = this;
        if (n.typePart.isDisambiguated()) {
            n = (LabeledTypeNode_c)n.type(n.typePart.type());
        }
        if (!n.typePart.isDisambiguated() || !n.labelPart.isDisambiguated()) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return n;
        }
        JifTypeSystem jts = (JifTypeSystem)ar.typeSystem();
        Type t = n.typePart.type();
        Label L = n.labelPart.label();
        if (t.isVoid()) {
            throw new SemanticException("The void type cannot be labeled.", this.position());
        }
        return ar.nodeFactory().CanonicalTypeNode(this.position(), (Type)jts.labeledType(n.position(), t, L));
    }

    public String toString() {
        return this.typePart.toString() + this.labelPart.toString();
    }

    public Node typeCheck(TypeChecker tc) {
        throw new InternalCompilerError(this.position(), "Cannot type check ambiguous node " + this + ".");
    }

    public Node exceptionCheck(ExceptionChecker ec) {
        throw new InternalCompilerError(this.position(), "Cannot exception check ambiguous node " + this + ".");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.print((Node)this.typePart, w, tr);
        w.write("{");
        this.print(this.labelPart, w, tr);
        w.write("}");
    }

    public void translate(CodeWriter w, Translator tr) {
        throw new InternalCompilerError(this.position(), "Cannot translate ambiguous node " + this + ".");
    }
}

