/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import jif.ast.AmbLabelNode_c;
import jif.ast.JifNodeFactory;
import jif.ast.JoinLabelNode;
import jif.ast.LabelComponentNode;
import jif.ast.LabelNode;
import jif.ast.PolicyNode;
import jif.types.JifTypeSystem;
import jif.types.label.ConfPolicy;
import jif.types.label.IntegPolicy;
import jif.types.label.Label;
import jif.types.label.PairLabel;
import jif.types.label.Policy;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class JoinLabelNode_c
extends AmbLabelNode_c
implements JoinLabelNode {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<LabelComponentNode> components;

    public JoinLabelNode_c(Position pos, List<LabelComponentNode> components) {
        this(pos, components, null);
    }

    public JoinLabelNode_c(Position pos, List<LabelComponentNode> components, Ext ext) {
        super(pos, ext);
        this.components = Collections.unmodifiableList(new ArrayList<LabelComponentNode>(components));
    }

    @Override
    public List<LabelComponentNode> components() {
        return this.components;
    }

    @Override
    public JoinLabelNode components(List<LabelComponentNode> components) {
        JoinLabelNode_c n = (JoinLabelNode_c)this.copy();
        n.components = Collections.unmodifiableList(new ArrayList<LabelComponentNode>(components));
        return n;
    }

    protected JoinLabelNode_c reconstruct(List<LabelComponentNode> components) {
        if (!CollectionUtil.equals(components, this.components)) {
            JoinLabelNode_c n = (JoinLabelNode_c)this.copy();
            n.components = Collections.unmodifiableList(new ArrayList<LabelComponentNode>(components));
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List components = this.visitList(this.components, v);
        return this.reconstruct(components);
    }

    @Override
    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)sc.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        LinkedHashSet<Label> s = new LinkedHashSet<Label>();
        LinkedHashSet<ConfPolicy> confPolicies = new LinkedHashSet<ConfPolicy>();
        LinkedHashSet<IntegPolicy> integPolicies = new LinkedHashSet<IntegPolicy>();
        for (LabelComponentNode n : this.components) {
            if (!n.isDisambiguated()) {
                sc.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            if (n instanceof PolicyNode) {
                Policy pol = ((PolicyNode)n).policy();
                if (pol instanceof ConfPolicy) {
                    confPolicies.add((ConfPolicy)pol);
                    continue;
                }
                integPolicies.add((IntegPolicy)pol);
                continue;
            }
            if (n instanceof LabelNode) {
                s.add(((LabelNode)n).label());
                continue;
            }
            throw new InternalCompilerError("Unexpected node: " + n);
        }
        if (!confPolicies.isEmpty() || !integPolicies.isEmpty()) {
            ConfPolicy cp = ts.bottomConfPolicy(this.position());
            IntegPolicy ip = ts.topIntegPolicy(this.position());
            if (!confPolicies.isEmpty()) {
                cp = ts.joinConfPolicy(this.position(), confPolicies);
            }
            if (!integPolicies.isEmpty()) {
                ip = ts.joinIntegPolicy(this.position(), integPolicies);
            }
            PairLabel pl = ts.pairLabel(this.position(), cp, ip);
            s.add(pl);
        }
        return nf.CanonicalLabelNode(this.position(), ts.joinLabel(this.position(), s));
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        Iterator<LabelComponentNode> i = this.components.iterator();
        while (i.hasNext()) {
            LabelComponentNode n = i.next();
            this.print(n, w, tr);
            if (!i.hasNext()) continue;
            w.write(";");
            w.allowBreak(0, " ");
        }
    }
}

