/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jif.ast.ConstraintNode;
import jif.ast.JifMethodDecl;
import jif.ast.LabelNode;
import jif.types.Assertion;
import jif.types.DefaultSignature;
import jif.types.JifMethodInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.TypeSubstitutor;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathLocal;
import jif.types.label.AccessPathRoot;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import polyglot.ast.Block;
import polyglot.ast.Ext;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Javadoc;
import polyglot.ast.MethodDecl_c;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;

@Deprecated
public class JifMethodDecl_c
extends MethodDecl_c
implements JifMethodDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected LabelNode startLabel;
    protected LabelNode returnLabel;
    protected List<ConstraintNode<Assertion>> constraints;

    public JifMethodDecl_c(Position pos, Flags flags, TypeNode returnType, Id name, LabelNode startLabel, List<Formal> formals, LabelNode returnLabel, List<TypeNode> throwTypes, List<ConstraintNode<Assertion>> constraints, Block body, Javadoc javadoc) {
        this(pos, flags, returnType, name, startLabel, formals, returnLabel, throwTypes, constraints, body, javadoc, null);
    }

    public JifMethodDecl_c(Position pos, Flags flags, TypeNode returnType, Id name, LabelNode startLabel, List<Formal> formals, LabelNode returnLabel, List<TypeNode> throwTypes, List<ConstraintNode<Assertion>> constraints, Block body, Javadoc javadoc, Ext ext) {
        super(pos, flags, returnType, name, formals, throwTypes, body, javadoc, ext);
        this.startLabel = startLabel;
        this.returnLabel = returnLabel;
        this.constraints = ListUtil.copy(constraints, (boolean)true);
    }

    @Override
    public LabelNode startLabel() {
        return this.startLabel;
    }

    @Override
    public JifMethodDecl startLabel(LabelNode startLabel) {
        return this.startLabel(this, startLabel);
    }

    protected <N extends JifMethodDecl_c> N startLabel(N n, LabelNode startLabel) {
        if (n.startLabel == startLabel) {
            return n;
        }
        n = (JifMethodDecl_c)this.copyIfNeeded((Node)n);
        n.startLabel = startLabel;
        return n;
    }

    @Override
    public LabelNode returnLabel() {
        return this.returnLabel;
    }

    @Override
    public JifMethodDecl returnLabel(LabelNode returnLabel) {
        return this.returnLabel(this, returnLabel);
    }

    protected <N extends JifMethodDecl_c> N returnLabel(N n, LabelNode returnLabel) {
        if (n.returnLabel == returnLabel) {
            return n;
        }
        n = (JifMethodDecl_c)this.copyIfNeeded((Node)n);
        n.returnLabel = returnLabel;
        return n;
    }

    @Override
    public List<ConstraintNode<Assertion>> constraints() {
        return this.constraints;
    }

    @Override
    public JifMethodDecl constraints(List<ConstraintNode<Assertion>> constraints) {
        return this.constraints(this, constraints);
    }

    protected <N extends JifMethodDecl_c> N constraints(N n, List<ConstraintNode<Assertion>> constraints) {
        if (CollectionUtil.equals(n.constraints, constraints)) {
            return n;
        }
        n = (JifMethodDecl_c)this.copyIfNeeded((Node)n);
        n.constraints = ListUtil.copy(constraints, (boolean)true);
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild((Node)this.name, v);
        TypeNode returnType = (TypeNode)this.visitChild((Node)this.returnType, v);
        LabelNode startLabel = (LabelNode)this.visitChild(this.startLabel, v);
        List formals = this.visitList(this.formals, v);
        LabelNode returnLabel = (LabelNode)this.visitChild(this.returnLabel, v);
        List throwTypes = this.visitList(this.throwTypes, v);
        List constraints = this.visitList(this.constraints, v);
        Block body = (Block)this.visitChild((Node)this.body, v);
        return this.reconstruct(this, name, returnType, startLabel, formals, returnLabel, throwTypes, constraints, body);
    }

    protected <N extends JifMethodDecl_c> N reconstruct(N n, Id name, TypeNode returnType, LabelNode startLabel, List<Formal> formals, LabelNode returnLabel, List<TypeNode> throwTypes, List<ConstraintNode<Assertion>> constraints, Block body) {
        n = (JifMethodDecl_c)super.reconstruct(n, returnType, name, formals, throwTypes, body);
        n = this.startLabel(n, startLabel);
        n = this.returnLabel(n, returnLabel);
        n = this.constraints(n, constraints);
        return n;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        Label Lr;
        Label Li;
        JifMethodDecl n = (JifMethodDecl)super.disambiguate(ar);
        JifMethodInstance jmi = (JifMethodInstance)n.methodInstance();
        JifTypeSystem jts = (JifTypeSystem)ar.typeSystem();
        ArrayList<Type> formalTypes = new ArrayList<Type>(n.formals().size());
        List formals = n.formals();
        for (Formal f : formals) {
            if (!f.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            formalTypes.add(f.declType());
        }
        jmi.setFormalTypes(formalTypes);
        if (!n.returnType().isDisambiguated()) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        DefaultSignature ds = jts.defaultSignature();
        if (n.startLabel() != null && !n.startLabel().isDisambiguated()) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        Type declrt = n.returnType().type();
        if (!declrt.isVoid() && !jts.isLabeled(declrt)) {
            declrt = jts.labeledType(declrt.position(), declrt, ds.defaultReturnValueLabel(n));
            n = (JifMethodDecl)n.returnType(n.returnType().type(declrt));
        }
        jmi.setReturnType(declrt);
        if (n.returnLabel() != null && !n.returnLabel().isDisambiguated()) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        boolean isDefaultPCBound = false;
        if (n.startLabel() == null) {
            Li = ds.defaultPCBound(n.position(), n.name());
            isDefaultPCBound = true;
        } else {
            Li = n.startLabel().label();
        }
        jmi.setPCBound(Li, isDefaultPCBound);
        boolean isDefaultReturnLabel = false;
        if (n.returnLabel() == null) {
            Lr = ds.defaultReturnLabel(n);
            isDefaultReturnLabel = true;
        } else {
            Lr = n.returnLabel().label();
        }
        jmi.setReturnLabel(Lr, isDefaultReturnLabel);
        LinkedList<Type> newThrowTypes = new LinkedList<Type>();
        List throwTypes = n.throwTypes();
        for (TypeNode tn : throwTypes) {
            if (!tn.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            Type xt = tn.type();
            if (!jts.isLabeled(xt)) {
                xt = jts.labeledType(xt.position(), xt, Lr);
            }
            newThrowTypes.add(xt);
        }
        jmi.setThrowTypes(newThrowTypes);
        ArrayList<Assertion> constraints = new ArrayList<Assertion>(n.constraints().size());
        for (ConstraintNode<Assertion> cn : n.constraints()) {
            if (!cn.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            constraints.addAll(cn.constraints());
        }
        jmi.setConstraints(constraints);
        JifMethodDecl_c.renameArgs(jmi, new TypeSubstitutor(new ArgRenamer(false)));
        return n.methodInstance(jmi);
    }

    public static JifMethodInstance unrenameArgs(JifMethodInstance jmi) {
        jmi = (JifMethodInstance)jmi.copy();
        try {
            JifMethodDecl_c.renameArgs(jmi, new TypeSubstitutor(new ArgRenamer(true)));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected semantic", (Throwable)e);
        }
        return jmi;
    }

    private static void renameArgs(JifMethodInstance jmi, TypeSubstitutor tsub) throws SemanticException {
        ArrayList<Type> newFormalTypes = new ArrayList<Type>(jmi.formalTypes().size());
        List formalTypes = jmi.formalTypes();
        for (Type t : formalTypes) {
            newFormalTypes.add(tsub.rewriteType(t));
        }
        jmi.setFormalTypes(newFormalTypes);
        jmi.setReturnType(tsub.rewriteType(jmi.returnType()));
        jmi.setPCBound(tsub.rewriteLabel(jmi.pcBound()), jmi.isDefaultPCBound());
        jmi.setReturnLabel(tsub.rewriteLabel(jmi.returnLabel()), jmi.isDefaultReturnLabel());
        ArrayList<Type> newThrowTypes = new ArrayList<Type>(jmi.throwTypes().size());
        List throwTypes = jmi.throwTypes();
        for (Type t : throwTypes) {
            newThrowTypes.add(tsub.rewriteType(t));
        }
        jmi.setThrowTypes(newThrowTypes);
        ArrayList<Assertion> constraints = new ArrayList<Assertion>(jmi.constraints().size());
        for (Assertion c : jmi.constraints()) {
            constraints.add(tsub.rewriteAssertion(c));
        }
        jmi.setConstraints(constraints);
    }

    private static class ArgRenamer
    extends LabelSubstitution {
        boolean revertToOriginal;

        ArgRenamer(boolean revertToOriginal) {
            this.revertToOriginal = revertToOriginal;
        }

        @Override
        public Label substLabel(Label L) {
            if (L instanceof ArgLabel) {
                ArgLabel al = (ArgLabel)L;
                if (!this.revertToOriginal && !al.name().endsWith("'")) {
                    al = (ArgLabel)al.copy();
                    al.setName(al.name() + "'");
                    return al;
                }
                if (this.revertToOriginal && al.name().endsWith("'")) {
                    al = (ArgLabel)al.copy();
                    al.setName(al.name().substring(0, al.name().length() - 1));
                    return al;
                }
            }
            return L;
        }

        @Override
        public AccessPath substAccessPath(AccessPath ap) {
            AccessPathRoot r = ap.root();
            if (r instanceof AccessPathLocal) {
                AccessPathLocal apl = (AccessPathLocal)r;
                if (!this.revertToOriginal && !apl.name().endsWith("'")) {
                    apl = apl.name(apl.name() + "'");
                    AccessPath newPath = ap.subst(r, apl);
                    return newPath;
                }
                if (this.revertToOriginal && apl.name().endsWith("'")) {
                    apl = apl.name(apl.name().substring(0, apl.name().length() - 1));
                    AccessPath newPath = ap.subst(r, apl);
                    return newPath;
                }
            }
            return ap;
        }
    }
}

