/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jif.ast.ConstraintNode;
import jif.ast.JifConstructorDecl;
import jif.ast.LabelNode;
import jif.types.Assertion;
import jif.types.DefaultSignature;
import jif.types.JifConstructorInstance;
import jif.types.JifTypeSystem;
import jif.types.label.Label;
import polyglot.ast.Block;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl_c;
import polyglot.ast.Ext;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Javadoc;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.util.CollectionUtil;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

@Deprecated
public class JifConstructorDecl_c
extends ConstructorDecl_c
implements JifConstructorDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected LabelNode startLabel;
    protected LabelNode returnLabel;
    protected List<ConstraintNode<Assertion>> constraints;

    public JifConstructorDecl_c(Position pos, Flags flags, Id name, LabelNode startLabel, LabelNode returnLabel, List<Formal> formals, List<TypeNode> throwTypes, List<ConstraintNode<Assertion>> constraints, Block body, Javadoc javadoc) {
        this(pos, flags, name, startLabel, returnLabel, formals, throwTypes, constraints, body, javadoc, null);
    }

    public JifConstructorDecl_c(Position pos, Flags flags, Id name, LabelNode startLabel, LabelNode returnLabel, List<Formal> formals, List<TypeNode> throwTypes, List<ConstraintNode<Assertion>> constraints, Block body, Javadoc javadoc, Ext ext) {
        super(pos, flags, name, formals, throwTypes, body, javadoc, ext);
        this.startLabel = startLabel;
        this.returnLabel = returnLabel;
        this.constraints = ListUtil.copy(constraints, (boolean)true);
    }

    @Override
    public LabelNode startLabel() {
        return this.startLabel;
    }

    @Override
    public JifConstructorDecl startLabel(LabelNode startLabel) {
        return this.startLabel(this, startLabel);
    }

    protected <N extends JifConstructorDecl_c> N startLabel(N n, LabelNode startLabel) {
        if (n.startLabel == startLabel) {
            return n;
        }
        n = (JifConstructorDecl_c)this.copyIfNeeded((Node)n);
        n.startLabel = startLabel;
        return n;
    }

    @Override
    public LabelNode returnLabel() {
        return this.returnLabel;
    }

    @Override
    public JifConstructorDecl returnLabel(LabelNode returnLabel) {
        return this.returnLabel(this, returnLabel);
    }

    protected <N extends JifConstructorDecl_c> N returnLabel(N n, LabelNode returnLabel) {
        if (n.returnLabel == returnLabel) {
            return n;
        }
        n = (JifConstructorDecl_c)this.copyIfNeeded((Node)n);
        n.returnLabel = returnLabel;
        return n;
    }

    @Override
    public List<ConstraintNode<Assertion>> constraints() {
        return this.constraints;
    }

    @Override
    public JifConstructorDecl constraints(List<ConstraintNode<Assertion>> constraints) {
        return this.constraints(this, constraints);
    }

    protected <N extends JifConstructorDecl_c> N constraints(N n, List<ConstraintNode<Assertion>> constraints) {
        if (CollectionUtil.equals(n.constraints, constraints)) {
            return n;
        }
        n = (JifConstructorDecl_c)this.copyIfNeeded((Node)n);
        n.constraints = ListUtil.copy(constraints, (boolean)true);
        return n;
    }

    protected <N extends JifConstructorDecl_c> N reconstruct(N n, Id name, LabelNode startLabel, LabelNode returnLabel, List<Formal> formals, List<TypeNode> throwTypes, List<ConstraintNode<Assertion>> constraints, Block body) {
        n = (JifConstructorDecl_c)super.reconstruct(n, name, formals, throwTypes, body);
        n = this.startLabel(n, startLabel);
        n = this.returnLabel(n, returnLabel);
        n = this.constraints(n, constraints);
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild((Node)this.name, v);
        LabelNode startLabel = (LabelNode)this.visitChild(this.startLabel, v);
        LabelNode returnLabel = (LabelNode)this.visitChild(this.returnLabel, v);
        List formals = this.visitList(this.formals, v);
        List throwTypes = this.visitList(this.throwTypes, v);
        List constraints = this.visitList(this.constraints, v);
        Block body = (Block)this.visitChild((Node)this.body, v);
        return this.reconstruct(this, name, startLabel, returnLabel, formals, throwTypes, constraints, body);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        Label Lr;
        Label Li;
        JifConstructorDecl_c n = (JifConstructorDecl_c)super.disambiguate(ar);
        JifConstructorInstance jci = (JifConstructorInstance)n.constructorInstance();
        JifTypeSystem jts = (JifTypeSystem)ar.typeSystem();
        if (n.startLabel() != null && !n.startLabel().isDisambiguated()) {
            return n;
        }
        if (n.returnLabel() != null && !n.returnLabel().isDisambiguated()) {
            return n;
        }
        ArrayList<Type> formalTypes = new ArrayList<Type>(n.formals().size());
        List formals = n.formals();
        for (Formal f : formals) {
            if (!f.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            formalTypes.add(f.declType());
        }
        jci.setFormalTypes(formalTypes);
        boolean isDefaultPCBound = false;
        DefaultSignature ds = jts.defaultSignature();
        if (n.startLabel() == null) {
            Li = ds.defaultPCBound(n.position(), n.name());
            isDefaultPCBound = true;
        } else {
            Li = n.startLabel().label();
            Li = jts.join(Li, jci.provider());
        }
        jci.setPCBound(Li, isDefaultPCBound);
        boolean isDefaultReturnLabel = false;
        if (n.returnLabel() == null) {
            Lr = ds.defaultReturnLabel(n);
            isDefaultReturnLabel = true;
        } else {
            Lr = n.returnLabel().label();
        }
        jci.setReturnLabel(Lr, isDefaultReturnLabel);
        LinkedList<Type> newThrowTypes = new LinkedList<Type>();
        List throwTypes = n.throwTypes();
        for (TypeNode tn : throwTypes) {
            if (!tn.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            Type xt = tn.type();
            if (!jts.isLabeled(xt)) {
                xt = jts.labeledType(xt.position(), xt, Lr);
            }
            newThrowTypes.add(xt);
        }
        jci.setThrowTypes(newThrowTypes);
        ArrayList<Assertion> constraints = new ArrayList<Assertion>(n.constraints().size());
        for (ConstraintNode<Assertion> cn : n.constraints()) {
            if (!cn.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            constraints.addAll(cn.constraints());
        }
        jci.setConstraints(constraints);
        return n.constructorInstance(jci);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Node n = super.typeCheck(tc);
        JifConstructorDecl_c jcd = (JifConstructorDecl_c)n;
        jcd.checkConstructorCall(tc);
        return jcd;
    }

    private void checkConstructorCall(TypeChecker tc) throws SemanticException {
        ClassType ct;
        JifTypeSystem ts = (JifTypeSystem)tc.typeSystem();
        if (ts.equals((TypeObject)(ct = tc.context().currentClass()), (TypeObject)ts.Object())) {
            return;
        }
        ClassType untrusted = ts.hasUntrustedAncestor((Type)ct);
        if (ts.isSignature((Type)ct)) {
            this.checkFirstStmtConstructorCall("The first statement of a constructor of a Java class must be a constructor call.", true, false);
        } else if (!ts.isSignature((Type)ct) && untrusted != null) {
            this.checkFirstStmtConstructorCall("The first statement of a constructor of a Jif class with an untrusted Java superclass must be an explicit call to the default super constructor,\"super()\".", false, true);
        } else if (!ts.isSignature((Type)ct) && ts.isSignature(ct.superType())) {
            this.checkFirstStmtConstructorCall("The first statement of a constructor of a Jif class with a Java superclass must be either a \"this(...)\" constructor call, or a call to the default super constructor, \"super()\".", true, true);
        }
    }

    private void checkFirstStmtConstructorCall(String message, boolean allowThisCalls, boolean superCallMustBeDefault) throws SemanticException {
        if (this.body == null) {
            return;
        }
        if (this.body().statements().size() < 1) {
            throw new SemanticException("Empty constructor body.", this.position());
        }
        Stmt s = (Stmt)this.body().statements().get(0);
        if (!(s instanceof ConstructorCall)) {
            throw new SemanticException(message, this.position());
        }
        ConstructorCall cc = (ConstructorCall)s;
        if (!allowThisCalls && cc.kind() == ConstructorCall.THIS) {
            throw new SemanticException(message, this.position());
        }
        if (superCallMustBeDefault && cc.kind() == ConstructorCall.SUPER && cc.arguments().size() > 0) {
            throw new SemanticException(message, this.position());
        }
    }
}

