/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import jif.ast.ConstraintNode;
import jif.ast.JifClassDecl;
import jif.ast.ParamDecl;
import jif.ast.PrincipalNode;
import jif.types.ActsForConstraint;
import jif.types.Assertion;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifParsedPolyType;
import jif.types.JifTypeSystem;
import jif.types.LabelLeAssertion;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.label.AccessPathThis;
import jif.types.label.Label;
import jif.types.principal.Principal;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl_c;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Javadoc;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.param.types.MuPClass;
import polyglot.ext.param.types.PClass;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;

@Deprecated
public class JifClassDecl_c
extends ClassDecl_c
implements JifClassDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<ParamDecl> params;
    protected List<PrincipalNode> authority;
    protected List<ConstraintNode<Assertion>> constraints;

    public JifClassDecl_c(Position pos, Flags flags, Id name, List<ParamDecl> params, TypeNode superClass, List<TypeNode> interfaces, List<PrincipalNode> authority, List<ConstraintNode<Assertion>> constraints, ClassBody body, Javadoc javadoc) {
        this(pos, flags, name, params, superClass, interfaces, authority, constraints, body, javadoc, null);
    }

    public JifClassDecl_c(Position pos, Flags flags, Id name, List<ParamDecl> params, TypeNode superClass, List<TypeNode> interfaces, List<PrincipalNode> authority, List<ConstraintNode<Assertion>> constraints, ClassBody body, Javadoc javadoc, Ext ext) {
        super(pos, flags, name, superClass, interfaces, body, javadoc, ext);
        this.params = ListUtil.copy(params, (boolean)true);
        this.authority = ListUtil.copy(authority, (boolean)true);
        this.constraints = ListUtil.copy(constraints, (boolean)true);
    }

    @Override
    public List<ConstraintNode<Assertion>> constraints() {
        return this.constraints;
    }

    @Override
    public JifClassDecl constraints(List<ConstraintNode<Assertion>> constraints) {
        return this.constraints(this, constraints);
    }

    protected <N extends JifClassDecl_c> N constraints(N n, List<ConstraintNode<Assertion>> constraints) {
        if (CollectionUtil.equals(n.constraints, constraints)) {
            return n;
        }
        n = (JifClassDecl_c)this.copyIfNeeded((Node)n);
        n.constraints = ListUtil.copy(constraints, (boolean)true);
        return n;
    }

    @Override
    public List<ParamDecl> params() {
        return this.params;
    }

    @Override
    public JifClassDecl params(List<ParamDecl> params) {
        return this.params(this, params);
    }

    protected <N extends JifClassDecl_c> N params(N n, List<ParamDecl> params) {
        if (CollectionUtil.equals(n.params, params)) {
            return n;
        }
        n = (JifClassDecl_c)this.copyIfNeeded((Node)n);
        n.params = ListUtil.copy(params, (boolean)true);
        return n;
    }

    @Override
    public List<PrincipalNode> authority() {
        return this.authority;
    }

    @Override
    public JifClassDecl authority(List<PrincipalNode> authority) {
        return this.authority(this, authority);
    }

    protected <N extends JifClassDecl_c> N authority(N n, List<PrincipalNode> authority) {
        if (CollectionUtil.equals(n.authority, authority)) {
            return n;
        }
        n = (JifClassDecl_c)this.copyIfNeeded((Node)n);
        n.authority = ListUtil.copy(authority, (boolean)true);
        return n;
    }

    protected <N extends JifClassDecl_c> N reconstruct(N n, Id name, List<ParamDecl> params, TypeNode superClass, List<TypeNode> interfaces, List<PrincipalNode> authority, List<ConstraintNode<Assertion>> constraints, ClassBody body) {
        n = (JifClassDecl_c)super.reconstruct(n, name, superClass, interfaces, body);
        n = this.params(n, params);
        n = this.authority(n, authority);
        n = this.constraints(n, constraints);
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild((Node)this.name, v);
        List params = this.visitList(this.params, v);
        TypeNode superClass = (TypeNode)this.visitChild((Node)this.superClass, v);
        List interfaces = this.visitList(this.interfaces, v);
        List authority = this.visitList(this.authority, v);
        List constraints = this.visitList(this.constraints, v);
        ClassBody body = (ClassBody)this.visitChild((Node)this.body, v);
        return this.reconstruct(this, name, params, superClass, interfaces, authority, constraints, body);
    }

    public Context enterScope(Context c) {
        JifContext A = (JifContext)c;
        A = this.addParamsToContext(A);
        A.setProvider(((JifClassType)this.type).provider());
        return this.addConstraintsToContext(A);
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.body) {
            JifParsedPolyType ct;
            JifContext A = (JifContext)c;
            JifParsedPolyType inst = ct = (JifParsedPolyType)this.type;
            A = (JifContext)A.pushClass(ct, inst);
            return this.addAuthorityToContext(A);
        }
        return super.enterChildScope(child, c);
    }

    public JifContext addConstraintsToContext(JifContext A) {
        JifParsedPolyType ct = (JifParsedPolyType)this.type;
        for (Assertion constraint : ct.constraints()) {
            if (constraint instanceof ActsForConstraint) {
                ActsForConstraint pi = (ActsForConstraint)constraint;
                Object actor = pi.actor();
                Object granter = pi.granter();
                if (actor instanceof Principal && granter instanceof Principal) {
                    A.addActsFor((Principal)actor, (Principal)granter);
                    continue;
                }
                if (actor instanceof Label) {
                    A.addActsFor((Label)actor, (Principal)granter);
                    continue;
                }
                throw new InternalCompilerError("Unexpected ActsForParam type: " + actor.getClass() + " actsfor " + granter.getClass());
            }
            if (constraint instanceof LabelLeAssertion) {
                LabelLeAssertion lle = (LabelLeAssertion)constraint;
                A.addAssertionLE(lle.lhs(), lle.rhs());
                continue;
            }
            throw new InternalCompilerError("Unexpected assertion type: " + constraint, constraint.position());
        }
        return A;
    }

    @Override
    public JifContext addParamsToContext(JifContext A) {
        JifParsedPolyType ct = (JifParsedPolyType)this.type;
        A = (JifContext)A.pushBlock();
        for (ParamInstance pi : ct.params()) {
            A.addVariable(pi);
        }
        return A;
    }

    @Override
    public JifContext addAuthorityToContext(JifContext A) {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        JifParsedPolyType ct = (JifParsedPolyType)this.type;
        LinkedHashSet<Principal> s = new LinkedHashSet<Principal>(ct.authority());
        if (ts.isSubtype((Type)ct, ts.PrincipalClass())) {
            s.add(ts.dynamicPrincipal(ct.position(), new AccessPathThis(ct, ct.position())));
        }
        A.setAuthority(s);
        return A;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        JifClassDecl_c n = (JifClassDecl_c)super.buildTypes(tb);
        n.buildParams((JifTypeSystem)tb.typeSystem());
        return n;
    }

    private void buildParams(JifTypeSystem ts) throws SemanticException {
        JifParsedPolyType ct = (JifParsedPolyType)this.type;
        if (ct == null) {
            return;
        }
        MuPClass pc = ts.mutablePClass(ct.position());
        ct.setInstantiatedFrom((PClass<ParamInstance, Param>)pc);
        pc.clazz((ClassType)ct);
        LinkedHashSet<String> names = new LinkedHashSet<String>(this.params.size());
        ArrayList<ParamInstance> newParams = new ArrayList<ParamInstance>(this.params.size());
        for (ParamDecl p : this.params) {
            newParams.add(p.paramInstance());
            if (names.contains(p.name())) {
                throw new SemanticException("Redefined Parameter Error.", p.position());
            }
            names.add(p.name());
        }
        ct.setParams(newParams);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        JifClassDecl_c n = (JifClassDecl_c)super.disambiguate(ar);
        JifParsedPolyType ct = (JifParsedPolyType)n.type;
        ArrayList<Principal> principals = new ArrayList<Principal>(n.authority().size());
        for (PrincipalNode p : n.authority()) {
            principals.add(p.principal());
        }
        ct.setAuthority(principals);
        ArrayList<Assertion> constraints = new ArrayList<Assertion>(n.constraints().size());
        for (ConstraintNode<Assertion> cn : n.constraints()) {
            if (!cn.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            constraints.addAll(cn.constraints());
        }
        ct.setConstraints(constraints);
        return n;
    }

    @Override
    public JifClassDecl type(Type type) {
        JifClassDecl_c n = (JifClassDecl_c)this.copy();
        n.type = (ParsedClassType)type;
        return n;
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        Object p;
        Iterator<Object> i;
        if (this.flags.isInterface()) {
            w.write(this.flags.clearInterface().clearAbstract().translate());
            w.write("interface ");
        } else {
            w.write(this.flags.translate());
            w.write("class ");
        }
        w.write(this.name.id());
        if (!this.params.isEmpty()) {
            w.write("[");
            i = this.params.iterator();
            while (i.hasNext()) {
                p = i.next();
                this.print((Node)p, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.write("]");
        }
        if (!this.authority.isEmpty()) {
            w.write(" authority(");
            i = this.authority.iterator();
            while (i.hasNext()) {
                p = (PrincipalNode)i.next();
                this.print((Node)p, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.write(")");
        }
        if (this.superClass() != null) {
            w.write(" extends ");
            this.print((Node)this.superClass(), w, tr);
        }
        if (!this.interfaces.isEmpty()) {
            if (this.flags.isInterface()) {
                w.write(" extends ");
            } else {
                w.write(" implements ");
            }
            i = this.interfaces().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print((Node)tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(", ");
            }
        }
        w.write(" {");
    }

    public void translate(CodeWriter w, Translator tr) {
        throw new InternalCompilerError("cannot translate " + this);
    }
}

