/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.List;
import jif.ast.AmbPrincipalNode;
import jif.ast.JifNodeFactory;
import jif.ast.PrincipalNode_c;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.JifVarInstance;
import jif.types.ParamInstance;
import jif.types.PrincipalInstance;
import jif.types.SemanticDetailedException;
import jif.types.label.AccessPath;
import jif.types.principal.ExternalPrincipal;
import jif.types.principal.ParamPrincipal;
import jif.visit.JifTypeChecker;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Field;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.types.Context;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class AmbPrincipalNode_c
extends PrincipalNode_c
implements AmbPrincipalNode {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr expr;
    protected Id name;

    public AmbPrincipalNode_c(Position pos, Expr expr) {
        this(pos, expr, null);
    }

    public AmbPrincipalNode_c(Position pos, Expr expr, Ext ext) {
        super(pos, ext);
        this.expr = expr;
        this.name = null;
    }

    public AmbPrincipalNode_c(Position pos, Id name) {
        this(pos, name, null);
    }

    public AmbPrincipalNode_c(Position pos, Id name, Ext ext) {
        super(pos, ext);
        this.expr = null;
        this.name = name;
    }

    protected <N extends AmbPrincipalNode_c> N expr(N n, Expr expr) {
        if (n.expr == expr) {
            return n;
        }
        n = (AmbPrincipalNode_c)this.copyIfNeeded((Node)n);
        n.expr = expr;
        return n;
    }

    protected <N extends AmbPrincipalNode_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = (AmbPrincipalNode_c)this.copyIfNeeded((Node)n);
        n.name = name;
        return n;
    }

    @Override
    public boolean isDisambiguated() {
        return false;
    }

    @Override
    public String toString() {
        if (this.expr != null) {
            return this.expr + "{amb}";
        }
        return this.name + "{amb}";
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.name != null) {
            return this.disambiguateName(ar, this.name);
        }
        if (!ar.isASTDisambiguated((Node)this.expr)) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        JifTypeSystem ts = (JifTypeSystem)ar.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)ar.nodeFactory();
        JifTypeChecker tc = new JifTypeChecker(ar.job(), (TypeSystem)ts, nf, true);
        Expr expr = (Expr)this.expr.visit((NodeVisitor)(tc = (TypeChecker)tc.context(ar.context())));
        if (!expr.isTypeChecked()) {
            Field f;
            if (expr instanceof Field && ts.unlabel((f = (Field)expr).target().type()) instanceof JifClassType) {
                JifSubstType jst;
                JifClassType jct = (JifClassType)ts.unlabel(f.target().type());
                ParsedClassType pct = null;
                if (jct instanceof ParsedClassType) {
                    pct = (ParsedClassType)jct;
                } else if (jct instanceof JifSubstType && (jst = (JifSubstType)jct).base() instanceof ParsedClassType) {
                    pct = (ParsedClassType)jst.base();
                }
                if (pct != null) {
                    Scheduler sched = ar.job().extensionInfo().scheduler();
                    Goal g = sched.Disambiguated(pct.job());
                    throw new MissingDependencyException(g);
                }
            }
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this.reconstruct(this, expr, this.name);
        }
        if (expr.type() != null && expr.type().isCanonical() && !ts.isFinalAccessExprOrConst(expr, (Type)ts.Principal())) {
            AccessPath ap = ts.exprToAccessPath(expr, (Type)ts.Principal(), (JifContext)ar.context());
            ap.verify((JifContext)ar.context());
            throw new SemanticDetailedException("Illegal dynamic principal.", "Only final access paths or principal expressions can be used as a dynamic principal. A final access path is an expression starting with either \"this\" or a final local variable \"v\", followed by zero or more final field accesses. That is, a final access path is either this.f1.f2....fn, or v.f1.f2.....fn, where v is a final local variables, and each field f1 to fn is a final field. A principal expression is either a principal parameter, or an external principal.", this.position());
        }
        return nf.CanonicalPrincipalNode(this.position(), ts.dynamicPrincipal(this.position(), ts.exprToAccessPath(expr, (Type)ts.Principal(), (JifContext)ar.context())));
    }

    protected Node disambiguateName(AmbiguityRemover ar, Id name) throws SemanticException {
        if ("_".equals(name.id())) {
            JifTypeSystem ts = (JifTypeSystem)ar.typeSystem();
            JifNodeFactory nf = (JifNodeFactory)ar.nodeFactory();
            return nf.CanonicalPrincipalNode(this.position(), ts.bottomPrincipal(this.position()));
        }
        Context c = ar.context();
        VarInstance vi = c.findVariable(name.id());
        if (vi instanceof JifVarInstance) {
            return this.varToPrincipal((JifVarInstance)vi, ar);
        }
        if (vi instanceof PrincipalInstance) {
            return this.principalToPrincipal((PrincipalInstance)vi, ar);
        }
        if (vi instanceof ParamInstance) {
            return this.paramToPrincipal((ParamInstance)vi, ar);
        }
        throw new SemanticException(vi + " cannot be used as principal.", this.position());
    }

    protected Node varToPrincipal(JifVarInstance vi, AmbiguityRemover sc) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)sc.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        if (vi.flags().isFinal()) {
            return nf.CanonicalPrincipalNode(this.position(), ts.dynamicPrincipal(this.position(), ts.varInstanceToAccessPath(vi, this.position())));
        }
        throw new SemanticException(vi + " is not a final variable " + "of type \"principal\".");
    }

    protected Node principalToPrincipal(PrincipalInstance vi, AmbiguityRemover sc) throws SemanticException {
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        ExternalPrincipal ep = vi.principal();
        return nf.CanonicalPrincipalNode(this.position(), ep);
    }

    protected Node paramToPrincipal(ParamInstance pi, AmbiguityRemover sc) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)sc.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        if (pi.isPrincipal()) {
            ParamPrincipal p = ts.principalParam(this.position(), pi);
            return nf.CanonicalPrincipalNode(this.position(), p);
        }
        throw new SemanticException(pi + " may not be used as a principal.", this.position());
    }

    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        return succs;
    }

    public Term firstChild() {
        return null;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr expr = this.expr;
        Id name = this.name;
        if (this.expr != null) {
            expr = (Expr)this.visitChild((Node)this.expr, v);
        }
        if (this.name != null) {
            name = (Id)this.visitChild((Node)this.name, v);
        }
        return this.reconstruct(this, expr, name);
    }

    protected <N extends AmbPrincipalNode_c> N reconstruct(N n, Expr expr, Id name) {
        n = this.expr(n, expr);
        n = this.id(n, name);
        return n;
    }
}

