/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import jif.ast.AmbParam;
import jif.ast.JifNodeFactory;
import jif.types.JifTypeSystem;
import jif.types.JifVarInstance;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.PrincipalInstance;
import jif.types.SemanticDetailedException;
import jif.types.label.CovariantParamLabel;
import jif.types.label.DynamicLabel;
import jif.types.label.ParamLabel;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.ParamPrincipal;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;

public class AmbParam_c
extends Node_c
implements AmbParam {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Id name;
    protected ParamInstance pi;
    private int disambCount = 0;
    protected static final int MAX_DISAMB_CALLS = 100;

    public AmbParam_c(Position pos, Id name, ParamInstance pi) {
        this(pos, name, pi, null);
    }

    public AmbParam_c(Position pos, Id name, ParamInstance pi, Ext ext) {
        super(pos, ext);
        this.name = name;
        this.pi = pi;
    }

    public boolean isDisambiguated() {
        return false;
    }

    public String name() {
        return this.name.id();
    }

    public AmbParam name(String name) {
        return this.name(this, name);
    }

    protected <N extends AmbParam_c> N name(N n, String name) {
        if (n.name.id().equals(name)) {
            return n;
        }
        return this.id(n, n.name.id(name));
    }

    public AmbParam id(Id id) {
        return this.id(this, id);
    }

    protected <N extends AmbParam_c> N id(N n, Id id) {
        if (n.name == id) {
            return n;
        }
        n = (AmbParam_c)this.copyIfNeeded((Node)n);
        n.name = id;
        return n;
    }

    @Override
    public Param parameter() {
        throw new InternalCompilerError("No parameter yet");
    }

    public String toString() {
        return this.name + "{amb}";
    }

    public Node visitChildren(NodeVisitor v) {
        if (this.name == null) {
            return this;
        }
        Id name = (Id)this.visitChild((Node)this.name, v);
        return this.reconstruct(this, name);
    }

    protected <N extends AmbParam_c> N reconstruct(N n, Id name) {
        n = this.id(n, name);
        return n;
    }

    public Node disambiguate(AmbiguityRemover sc) throws SemanticException {
        Context c = sc.context();
        VarInstance vi = c.findVariable(this.name.id());
        if (!vi.isCanonical() && this.pi == null && this.disambCount++ < 100) {
            sc.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        if (vi instanceof JifVarInstance) {
            return this.varToParam((JifVarInstance)vi, sc);
        }
        if (vi instanceof PrincipalInstance) {
            return this.principalToParam((PrincipalInstance)vi, sc);
        }
        if (vi instanceof ParamInstance) {
            return this.paramToParam((ParamInstance)vi, sc);
        }
        throw new SemanticDetailedException(vi + " cannot be used as parameter.", "The variable " + this.name + " is not suitable for use as a parameter.", this.position());
    }

    protected Node varToParam(JifVarInstance vi, AmbiguityRemover sc) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)sc.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        if (vi.flags().isFinal()) {
            if (ts.isLabel(vi.type()) || this.pi != null && this.pi.isLabel()) {
                DynamicLabel l = ts.dynamicLabel(this.position(), ts.varInstanceToAccessPath(vi, this.position()));
                return nf.CanonicalLabelNode(this.position(), l);
            }
            if (ts.isImplicitCastValid(vi.type(), (Type)ts.Principal()) || this.pi != null && this.pi.isPrincipal()) {
                DynamicPrincipal p = ts.dynamicPrincipal(this.position(), ts.varInstanceToAccessPath(vi, this.position()));
                return nf.CanonicalPrincipalNode(this.position(), p);
            }
            throw new SemanticDetailedException("Only final variables of type \"label\" or \"principal\" may be used as class parameters.", "Only final variables of type \"label\" or \"principal\" may be used as class parameters. The variable " + vi.name() + " is not of type \"label\", nor of type \"principal\".", this.position());
        }
        throw new SemanticDetailedException("Only final variables of type \"label\" or \"principal\" may be used as class parameters.", "Only final variables of type \"label\" or \"principal\" may be used as class parameters. The variable " + vi.name() + " is not final.", this.position());
    }

    protected Node principalToParam(PrincipalInstance vi, AmbiguityRemover sc) {
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        return nf.CanonicalPrincipalNode(this.position(), vi.principal());
    }

    protected Node paramToParam(ParamInstance pi, AmbiguityRemover sc) {
        JifTypeSystem ts = (JifTypeSystem)sc.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)sc.nodeFactory();
        if (pi.isCovariantLabel()) {
            CovariantParamLabel L = ts.covariantLabel(this.position(), pi);
            return nf.CanonicalLabelNode(this.position(), L);
        }
        if (pi.isInvariantLabel()) {
            ParamLabel L = ts.paramLabel(this.position(), pi);
            L.setDescription("label parameter " + pi.name() + " of class " + pi.container().fullName());
            return nf.CanonicalLabelNode(this.position(), L);
        }
        if (pi.isPrincipal()) {
            ParamPrincipal p = ts.principalParam(this.position(), pi);
            return nf.CanonicalPrincipalNode(this.position(), p);
        }
        throw new InternalCompilerError("Unrecognized parameter type for " + pi, this.position());
    }
}

